/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.mongodb.LoggerSettings;
import com.willfp.eco.libs.mongodb.MongoCompressor;
import com.willfp.eco.libs.mongodb.MongoCredential;
import com.willfp.eco.libs.mongodb.MongoDriverInformation;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.ServerApi;
import com.willfp.eco.libs.mongodb.annotations.ThreadSafe;
import com.willfp.eco.libs.mongodb.connection.ClusterConnectionMode;
import com.willfp.eco.libs.mongodb.connection.ConnectionPoolSettings;
import com.willfp.eco.libs.mongodb.connection.ServerId;
import com.willfp.eco.libs.mongodb.connection.ServerSettings;
import com.willfp.eco.libs.mongodb.connection.StreamFactory;
import com.willfp.eco.libs.mongodb.event.CommandListener;
import com.willfp.eco.libs.mongodb.internal.connection.Cluster;
import com.willfp.eco.libs.mongodb.internal.connection.ClusterableServer;
import com.willfp.eco.libs.mongodb.internal.connection.ClusterableServerFactory;
import com.willfp.eco.libs.mongodb.internal.connection.DefaultConnectionFactory;
import com.willfp.eco.libs.mongodb.internal.connection.DefaultConnectionPool;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.willfp.eco.libs.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.willfp.eco.libs.mongodb.internal.connection.LoadBalancedServer;
import com.willfp.eco.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.willfp.eco.libs.mongodb.internal.event.EventListenerHelper;
import com.willfp.eco.libs.mongodb.internal.inject.EmptyProvider;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.spi.dns.InetAddressResolver;
import java.util.List;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;
    private final InetAddressResolver inetAddressResolver;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
        this.inetAddressResolver = inetAddressResolver;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi, this.inetAddressResolver), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance());
        connectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), connectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

