/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.mongodb.MongoSocketException;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.spi.dns.InetAddressResolver;
import com.willfp.eco.libs.mongodb.spi.dns.InetAddressResolverProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class ServerAddressWithResolver
extends ServerAddress {
    private static final long serialVersionUID = 1L;
    @Nullable
    private static final InetAddressResolver DEFAULT_INET_ADDRESS_RESOLVER = StreamSupport.stream(ServiceLoader.load(InetAddressResolverProvider.class).spliterator(), false).findFirst().map(InetAddressResolverProvider::create).orElse(null);
    @Nullable
    private final transient InetAddressResolver resolver;

    ServerAddressWithResolver(ServerAddress serverAddress, @Nullable InetAddressResolver inetAddressResolver) {
        super(serverAddress.getHost(), serverAddress.getPort());
        this.resolver = inetAddressResolver == null ? DEFAULT_INET_ADDRESS_RESOLVER : inetAddressResolver;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        if (this.resolver == null) {
            return super.getSocketAddress();
        }
        return this.getSocketAddresses().get(0);
    }

    @Override
    public List<InetSocketAddress> getSocketAddresses() {
        if (this.resolver == null) {
            return super.getSocketAddresses();
        }
        try {
            return this.resolver.lookupByName(this.getHost()).stream().map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, this.getPort())).collect(Collectors.toList());
        }
        catch (UnknownHostException e) {
            throw new MongoSocketException(e.getMessage(), this, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerAddressWithResolver that = (ServerAddressWithResolver)o;
        return Objects.equals(this.resolver, that.resolver);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolver);
    }
}

