/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.mongodb.MongoChangeStreamException;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.MongoCursorNotFoundException;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.MongoInterruptedException;
import com.willfp.eco.libs.mongodb.MongoNotPrimaryException;
import com.willfp.eco.libs.mongodb.MongoSocketException;
import java.util.Arrays;
import java.util.List;

final class ChangeStreamBatchCursorHelper {
    static final List<Integer> RETRYABLE_SERVER_ERROR_CODES = Arrays.asList(6, 7, 63, 89, 91, 133, 150, 189, 234, 262, 9001, 10107, 11600, 11602, 13388, 13435, 13436);
    static final String RESUMABLE_CHANGE_STREAM_ERROR_LABEL = "ResumableChangeStreamError";

    static boolean isResumableError(Throwable t2, int maxWireVersion) {
        if (!(t2 instanceof MongoException) || t2 instanceof MongoChangeStreamException || t2 instanceof MongoInterruptedException) {
            return false;
        }
        if (t2 instanceof MongoNotPrimaryException || t2 instanceof MongoCursorNotFoundException || t2 instanceof MongoSocketException | t2 instanceof MongoClientException) {
            return true;
        }
        if (maxWireVersion >= 9) {
            return ((MongoException)t2).getErrorLabels().contains(RESUMABLE_CHANGE_STREAM_ERROR_LABEL);
        }
        return RETRYABLE_SERVER_ERROR_CODES.contains(((MongoException)t2).getCode());
    }

    private ChangeStreamBatchCursorHelper() {
    }
}

