/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.ReadBinding;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.ReadOperation;

public class CommandReadOperation<T>
implements AsyncReadOperation<T>,
ReadOperation<T> {
    private final String databaseName;
    private final BsonDocument command;
    private final Decoder<T> decoder;

    public CommandReadOperation(String databaseName, BsonDocument command2, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.command = Assertions.notNull("command", command2);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(ReadBinding binding) {
        return (T)CommandOperationHelper.executeRetryableRead(binding, this.databaseName, this.getCommandCreator(), this.decoder, (result2, source, connection) -> result2, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.databaseName, this.getCommandCreator(), this.decoder, (result2, source, connection) -> result2, false, callback);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (serverDescription, connectionDescription) -> this.command;
    }
}

