/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.BsonArrayCodec;
import com.willfp.eco.libs.bson.codecs.BsonBinaryCodec;
import com.willfp.eco.libs.bson.codecs.BsonBooleanCodec;
import com.willfp.eco.libs.bson.codecs.BsonDBPointerCodec;
import com.willfp.eco.libs.bson.codecs.BsonDateTimeCodec;
import com.willfp.eco.libs.bson.codecs.BsonDecimal128Codec;
import com.willfp.eco.libs.bson.codecs.BsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.BsonDoubleCodec;
import com.willfp.eco.libs.bson.codecs.BsonInt32Codec;
import com.willfp.eco.libs.bson.codecs.BsonInt64Codec;
import com.willfp.eco.libs.bson.codecs.BsonJavaScriptCodec;
import com.willfp.eco.libs.bson.codecs.BsonJavaScriptWithScopeCodec;
import com.willfp.eco.libs.bson.codecs.BsonMaxKeyCodec;
import com.willfp.eco.libs.bson.codecs.BsonMinKeyCodec;
import com.willfp.eco.libs.bson.codecs.BsonNullCodec;
import com.willfp.eco.libs.bson.codecs.BsonObjectIdCodec;
import com.willfp.eco.libs.bson.codecs.BsonRegularExpressionCodec;
import com.willfp.eco.libs.bson.codecs.BsonStringCodec;
import com.willfp.eco.libs.bson.codecs.BsonSymbolCodec;
import com.willfp.eco.libs.bson.codecs.BsonTimestampCodec;
import com.willfp.eco.libs.bson.codecs.BsonUndefinedCodec;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.bson.codecs.configuration.CodecProvider;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
        this.addCodec(new BsonJavaScriptWithScopeCodec(new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result2 = this.payloadDecoder.getClass().hashCode();
        result2 = 31 * result2 + this.fieldsContainingPayload.hashCode();
        return result2;
    }
}

