/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.BsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.ReadBinding;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.DocumentHelper;
import com.willfp.eco.libs.mongodb.internal.operation.OperationReadConcernHelper;
import com.willfp.eco.libs.mongodb.internal.operation.ReadOperation;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class CountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private long skip;
    private long limit;
    private long maxTimeMS;
    private Collation collation;

    public CountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountOperation filter(BsonDocument filter2) {
        this.filter = filter2;
        return this;
    }

    public CountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public CountOperation hint(BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CountOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), DECODER, this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), DECODER, this.asyncTransformer(), this.retryReads, callback);
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result2, source, connection) -> result2.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result2, source, connection) -> result2.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> this.getCommand(sessionContext, connectionDescription);
    }

    private BsonDocument getCommand(SessionContext sessionContext, ConnectionDescription connectionDescription) {
        BsonDocument document2 = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document2);
        DocumentHelper.putIfNotNull(document2, "query", this.filter);
        DocumentHelper.putIfNotZero(document2, "limit", this.limit);
        DocumentHelper.putIfNotZero(document2, "skip", this.skip);
        DocumentHelper.putIfNotNull(document2, "hint", this.hint);
        DocumentHelper.putIfNotZero(document2, "maxTimeMS", this.maxTimeMS);
        if (this.collation != null) {
            document2.put("collation", this.collation.asDocument());
        }
        return document2;
    }
}

