/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.BsonValueCodec;
import com.willfp.eco.libs.mongodb.MongoCommandException;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.ReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.WriteBinding;
import com.willfp.eco.libs.mongodb.internal.connection.AsyncConnection;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.ListCollectionsOperation;
import com.willfp.eco.libs.mongodb.internal.operation.OperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.WriteConcernHelper;
import com.willfp.eco.libs.mongodb.internal.operation.WriteOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;

public class DropCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final String ENCRYPT_PREFIX = "enxcol_.";
    private static final BsonValueCodec BSON_VALUE_CODEC = new BsonValueCodec();
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private BsonDocument encryptedFields;
    private boolean autoEncryptedFields;

    public DropCollectionOperation(MongoNamespace namespace) {
        this(namespace, null);
    }

    public DropCollectionOperation(MongoNamespace namespace, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public DropCollectionOperation encryptedFields(BsonDocument encryptedFields) {
        this.encryptedFields = encryptedFields;
        return this;
    }

    public DropCollectionOperation autoEncryptedFields(boolean autoEncryptedFields) {
        this.autoEncryptedFields = autoEncryptedFields;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        BsonDocument localEncryptedFields = this.getEncryptedFields((ReadWriteBinding)binding);
        return OperationHelper.withConnection(binding, connection -> {
            this.getCommands(localEncryptedFields).forEach(command2 -> {
                try {
                    CommandOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), (BsonDocument)command2.get(), connection, CommandOperationHelper.writeConcernErrorTransformer());
                }
                catch (MongoCommandException e) {
                    CommandOperationHelper.rethrowIfNotNamespaceError(e);
                }
            });
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        this.getEncryptedFields((AsyncReadWriteBinding)binding, (result2, t2) -> {
            if (t2 != null) {
                errHandlingCallback.onResult(null, t2);
            } else {
                OperationHelper.withAsyncConnection(binding, (connection, t1) -> {
                    if (t1 != null) {
                        errHandlingCallback.onResult(null, t1);
                    } else {
                        new ProcessCommandsCallback(binding, connection, this.getCommands((BsonDocument)result2), OperationHelper.releasingCallback(errHandlingCallback, connection)).onResult(null, null);
                    }
                });
            }
        });
    }

    private List<Supplier<BsonDocument>> getCommands(BsonDocument encryptedFields) {
        if (encryptedFields == null) {
            return Collections.singletonList(this::dropCollectionCommand);
        }
        return Arrays.asList(() -> this.getDropEncryptedFieldsCollectionCommand(encryptedFields, "esc"), () -> this.getDropEncryptedFieldsCollectionCommand(encryptedFields, "ecoc"), this::dropCollectionCommand);
    }

    private BsonDocument getDropEncryptedFieldsCollectionCommand(BsonDocument encryptedFields, String collectionSuffix) {
        BsonString defaultCollectionName = new BsonString(ENCRYPT_PREFIX + this.namespace.getCollectionName() + "." + collectionSuffix);
        return new BsonDocument("drop", encryptedFields.getOrDefault(collectionSuffix + "Collection", defaultCollectionName));
    }

    private BsonDocument dropCollectionCommand() {
        BsonDocument commandDocument = new BsonDocument("drop", new BsonString(this.namespace.getCollectionName()));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }

    @Nullable
    private BsonDocument getEncryptedFields(ReadWriteBinding readWriteBinding) {
        if (this.encryptedFields == null && this.autoEncryptedFields) {
            try (Object cursor = this.listCollectionOperation().execute(readWriteBinding);){
                BsonDocument bsonDocument = this.getCollectionEncryptedFields(this.encryptedFields, cursor.tryNext());
                return bsonDocument;
            }
        }
        return this.encryptedFields;
    }

    private void getEncryptedFields(AsyncReadWriteBinding asyncReadWriteBinding, SingleResultCallback<BsonDocument> callback) {
        if (this.encryptedFields == null && this.autoEncryptedFields) {
            this.listCollectionOperation().executeAsync((AsyncReadBinding)asyncReadWriteBinding, (cursor, t2) -> {
                if (t2 != null) {
                    callback.onResult(null, t2);
                } else {
                    cursor.next((bsonValues, t1) -> {
                        if (t1 != null) {
                            callback.onResult(null, t1);
                        } else {
                            callback.onResult(this.getCollectionEncryptedFields(this.encryptedFields, (List<BsonValue>)bsonValues), null);
                        }
                    });
                }
            });
        } else {
            callback.onResult(this.encryptedFields, null);
        }
    }

    private BsonDocument getCollectionEncryptedFields(BsonDocument defaultEncryptedFields, @Nullable List<BsonValue> bsonValues) {
        if (bsonValues != null && bsonValues.size() > 0) {
            return bsonValues.get(0).asDocument().getDocument("options", new BsonDocument()).getDocument("encryptedFields", new BsonDocument());
        }
        return defaultEncryptedFields;
    }

    private ListCollectionsOperation<BsonValue> listCollectionOperation() {
        return new ListCollectionsOperation<BsonValue>(this.namespace.getDatabaseName(), BSON_VALUE_CODEC).filter(new BsonDocument("name", new BsonString(this.namespace.getCollectionName()))).batchSize(1);
    }

    class ProcessCommandsCallback
    implements SingleResultCallback<Void> {
        private final AsyncWriteBinding binding;
        private final AsyncConnection connection;
        private final SingleResultCallback<Void> finalCallback;
        private final Deque<Supplier<BsonDocument>> commands;

        ProcessCommandsCallback(AsyncWriteBinding binding, AsyncConnection connection, List<Supplier<BsonDocument>> commands, SingleResultCallback<Void> finalCallback) {
            this.binding = binding;
            this.connection = connection;
            this.finalCallback = finalCallback;
            this.commands = new ArrayDeque<Supplier<BsonDocument>>(commands);
        }

        @Override
        public void onResult(@Nullable Void result2, @Nullable Throwable t2) {
            if (t2 != null && !CommandOperationHelper.isNamespaceError(t2)) {
                this.finalCallback.onResult(null, t2);
                return;
            }
            Supplier<BsonDocument> nextCommandFunction = this.commands.poll();
            if (nextCommandFunction == null) {
                this.finalCallback.onResult(null, null);
            } else {
                CommandOperationHelper.executeCommandAsync(this.binding, DropCollectionOperation.this.namespace.getDatabaseName(), nextCommandFunction.get(), this.connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), this);
            }
        }
    }
}

