/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDocumentWrapper;
import com.willfp.eco.libs.bson.BsonJavaScript;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.CollectibleCodec;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.AutoEncryptionSettings;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.BulkWriteOptions;
import com.willfp.eco.libs.mongodb.client.model.ClusteredIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.client.model.CountOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateViewOptions;
import com.willfp.eco.libs.mongodb.client.model.DeleteManyModel;
import com.willfp.eco.libs.mongodb.client.model.DeleteOneModel;
import com.willfp.eco.libs.mongodb.client.model.DeleteOptions;
import com.willfp.eco.libs.mongodb.client.model.DropCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.DropIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.EstimatedDocumentCountOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndDeleteOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndUpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.IndexModel;
import com.willfp.eco.libs.mongodb.client.model.IndexOptionDefaults;
import com.willfp.eco.libs.mongodb.client.model.InsertManyOptions;
import com.willfp.eco.libs.mongodb.client.model.InsertOneModel;
import com.willfp.eco.libs.mongodb.client.model.InsertOneOptions;
import com.willfp.eco.libs.mongodb.client.model.MapReduceAction;
import com.willfp.eco.libs.mongodb.client.model.RenameCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.ReplaceOneModel;
import com.willfp.eco.libs.mongodb.client.model.ReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.ReturnDocument;
import com.willfp.eco.libs.mongodb.client.model.UpdateManyModel;
import com.willfp.eco.libs.mongodb.client.model.UpdateOneModel;
import com.willfp.eco.libs.mongodb.client.model.UpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.ValidationOptions;
import com.willfp.eco.libs.mongodb.client.model.WriteModel;
import com.willfp.eco.libs.mongodb.client.model.changestream.FullDocument;
import com.willfp.eco.libs.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.willfp.eco.libs.mongodb.internal.bulk.DeleteRequest;
import com.willfp.eco.libs.mongodb.internal.bulk.IndexRequest;
import com.willfp.eco.libs.mongodb.internal.bulk.InsertRequest;
import com.willfp.eco.libs.mongodb.internal.bulk.UpdateRequest;
import com.willfp.eco.libs.mongodb.internal.bulk.WriteRequest;
import com.willfp.eco.libs.mongodb.internal.client.model.AggregationLevel;
import com.willfp.eco.libs.mongodb.internal.client.model.FindOptions;
import com.willfp.eco.libs.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.willfp.eco.libs.mongodb.internal.operation.AggregateOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AggregateToCollectionOperation;
import com.willfp.eco.libs.mongodb.internal.operation.ChangeStreamOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CommandReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CountDocumentsOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CreateCollectionOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CreateIndexesOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CreateViewOperation;
import com.willfp.eco.libs.mongodb.internal.operation.DistinctOperation;
import com.willfp.eco.libs.mongodb.internal.operation.DropCollectionOperation;
import com.willfp.eco.libs.mongodb.internal.operation.DropDatabaseOperation;
import com.willfp.eco.libs.mongodb.internal.operation.DropIndexOperation;
import com.willfp.eco.libs.mongodb.internal.operation.EstimatedDocumentCountOperation;
import com.willfp.eco.libs.mongodb.internal.operation.FindAndDeleteOperation;
import com.willfp.eco.libs.mongodb.internal.operation.FindAndReplaceOperation;
import com.willfp.eco.libs.mongodb.internal.operation.FindAndUpdateOperation;
import com.willfp.eco.libs.mongodb.internal.operation.FindOperation;
import com.willfp.eco.libs.mongodb.internal.operation.ListCollectionsOperation;
import com.willfp.eco.libs.mongodb.internal.operation.ListDatabasesOperation;
import com.willfp.eco.libs.mongodb.internal.operation.ListIndexesOperation;
import com.willfp.eco.libs.mongodb.internal.operation.MapReduceToCollectionOperation;
import com.willfp.eco.libs.mongodb.internal.operation.MapReduceWithInlineResultsOperation;
import com.willfp.eco.libs.mongodb.internal.operation.MixedBulkWriteOperation;
import com.willfp.eco.libs.mongodb.internal.operation.RenameCollectionOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class Operations<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;

    Operations(@Nullable MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads) {
        this.namespace = namespace;
        this.documentClass = documentClass;
        this.readPreference = readPreference;
        this.codecRegistry = codecRegistry;
        this.readConcern = readConcern;
        this.writeConcern = writeConcern;
        this.retryWrites = retryWrites;
        this.retryReads = retryReads;
    }

    @Nullable
    MongoNamespace getNamespace() {
        return this.namespace;
    }

    Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    boolean isRetryWrites() {
        return this.retryWrites;
    }

    boolean isRetryReads() {
        return this.retryReads;
    }

    CountDocumentsOperation countDocuments(Bson filter2, CountOptions options2) {
        CountDocumentsOperation operation = new CountDocumentsOperation(Assertions.assertNotNull(this.namespace)).retryReads(this.retryReads).filter(this.toBsonDocument(filter2)).skip(options2.getSkip()).limit(options2.getLimit()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options2.getCollation()).comment(options2.getComment());
        if (options2.getHint() != null) {
            operation.hint(this.toBsonDocument(options2.getHint()));
        } else if (options2.getHintString() != null) {
            operation.hint(new BsonString(options2.getHintString()));
        }
        return operation;
    }

    EstimatedDocumentCountOperation estimatedDocumentCount(EstimatedDocumentCountOptions options2) {
        return new EstimatedDocumentCountOperation(Assertions.assertNotNull(this.namespace)).retryReads(this.retryReads).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).comment(options2.getComment());
    }

    <TResult> FindOperation<TResult> findFirst(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.createFindOperation(Assertions.assertNotNull(this.namespace), filter2, resultClass, options2).batchSize(0).limit(-1);
    }

    <TResult> FindOperation<TResult> find(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.createFindOperation(Assertions.assertNotNull(this.namespace), filter2, resultClass, options2);
    }

    <TResult> FindOperation<TResult> find(MongoNamespace findNamespace, @Nullable Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.createFindOperation(findNamespace, filter2, resultClass, options2);
    }

    private <TResult> FindOperation<TResult> createFindOperation(MongoNamespace findNamespace, @Nullable Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        FindOperation<TResult> operation = new FindOperation<TResult>(findNamespace, this.codecRegistry.get(resultClass)).retryReads(this.retryReads).filter(filter2 == null ? new BsonDocument() : filter2.toBsonDocument(this.documentClass, this.codecRegistry)).batchSize(options2.getBatchSize()).skip(options2.getSkip()).limit(options2.getLimit()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).maxAwaitTime(options2.getMaxAwaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).projection(this.toBsonDocument(options2.getProjection())).sort(this.toBsonDocument(options2.getSort())).cursorType(options2.getCursorType()).noCursorTimeout(options2.isNoCursorTimeout()).oplogReplay(options2.isOplogReplay()).partial(options2.isPartial()).collation(options2.getCollation()).comment(options2.getComment()).let(this.toBsonDocument(options2.getLet())).min(this.toBsonDocument(options2.getMin())).max(this.toBsonDocument(options2.getMax())).returnKey(options2.isReturnKey()).showRecordId(options2.isShowRecordId()).allowDiskUse(options2.isAllowDiskUse());
        if (options2.getHint() != null) {
            operation.hint(this.toBsonDocument(options2.getHint()));
        } else if (options2.getHintString() != null) {
            operation.hint(new BsonString(options2.getHintString()));
        }
        return operation;
    }

    <TResult> DistinctOperation<TResult> distinct(String fieldName, @Nullable Bson filter2, Class<TResult> resultClass, long maxTimeMS, Collation collation, BsonValue comment) {
        return new DistinctOperation<TResult>(Assertions.assertNotNull(this.namespace), fieldName, this.codecRegistry.get(resultClass)).retryReads(this.retryReads).filter(filter2 == null ? null : filter2.toBsonDocument(this.documentClass, this.codecRegistry)).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).collation(collation).comment(comment);
    }

    <TResult> AggregateOperation<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, @Nullable Integer batchSize, Collation collation, @Nullable Bson hint, @Nullable String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return new AggregateOperation<TResult>(Assertions.assertNotNull(this.namespace), Assertions.assertNotNull(this.toBsonDocumentList(pipeline)), this.codecRegistry.get(resultClass), aggregationLevel).retryReads(this.retryReads).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).maxAwaitTime(maxAwaitTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(allowDiskUse).batchSize(batchSize).collation(collation).hint(hint != null ? this.toBsonDocument(hint) : (hintString != null ? new BsonString(hintString) : null)).comment(comment).let(this.toBsonDocument(variables));
    }

    AggregateToCollectionOperation aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, @Nullable Bson hint, @Nullable String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return new AggregateToCollectionOperation(Assertions.assertNotNull(this.namespace), Assertions.assertNotNull(this.toBsonDocumentList(pipeline)), this.readConcern, this.writeConcern, aggregationLevel).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(allowDiskUse).bypassDocumentValidation(bypassDocumentValidation).collation(collation).hint(hint != null ? this.toBsonDocument(hint) : (hintString != null ? new BsonString(hintString) : null)).comment(comment).let(this.toBsonDocument(variables));
    }

    MapReduceToCollectionOperation mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, @Nullable String finalizeFunction, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort, boolean verbose, MapReduceAction action, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(Assertions.assertNotNull(this.namespace), new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), collectionName, this.writeConcern).filter(this.toBsonDocument(filter2)).limit(limit).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).jsMode(jsMode).scope(this.toBsonDocument(scope2)).sort(this.toBsonDocument(sort)).verbose(verbose).action(action.getValue()).nonAtomic(nonAtomic).sharded(sharded).databaseName(databaseName).bypassDocumentValidation(bypassDocumentValidation).collation(collation);
        if (finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(finalizeFunction));
        }
        return operation;
    }

    <TResult> MapReduceWithInlineResultsOperation<TResult> mapReduce(String mapFunction, String reduceFunction, @Nullable String finalizeFunction, Class<TResult> resultClass, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort, boolean verbose, Collation collation) {
        MapReduceWithInlineResultsOperation<TResult> operation = new MapReduceWithInlineResultsOperation<TResult>(Assertions.assertNotNull(this.namespace), new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), this.codecRegistry.get(resultClass)).filter(this.toBsonDocument(filter2)).limit(limit).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).jsMode(jsMode).scope(this.toBsonDocument(scope2)).sort(this.toBsonDocument(sort)).verbose(verbose).collation(collation);
        if (finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(finalizeFunction));
        }
        return operation;
    }

    FindAndDeleteOperation<TDocument> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options2) {
        return ((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)new FindAndDeleteOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec()).filter(this.toBsonDocument(filter2))).projection(this.toBsonDocument(options2.getProjection()))).sort(this.toBsonDocument(options2.getSort()))).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)).collation(options2.getCollation())).hint(options2.getHint())).hintString(options2.getHintString())).comment(options2.getComment())).let(this.toBsonDocument(options2.getLet()));
    }

    FindAndReplaceOperation<TDocument> findOneAndReplace(Bson filter2, TDocument replacement, FindOneAndReplaceOptions options2) {
        return ((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)new FindAndReplaceOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec(), this.documentToBsonDocument(replacement)).filter(this.toBsonDocument(filter2))).projection(this.toBsonDocument(options2.getProjection()))).sort(this.toBsonDocument(options2.getSort()))).returnOriginal(options2.getReturnDocument() == ReturnDocument.BEFORE).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation())).hint(options2.getHint())).hintString(options2.getHintString())).comment(options2.getComment())).let(this.toBsonDocument(options2.getLet()));
    }

    FindAndUpdateOperation<TDocument> findOneAndUpdate(Bson filter2, Bson update2, FindOneAndUpdateOptions options2) {
        return ((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)new FindAndUpdateOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec(), Assertions.assertNotNull(this.toBsonDocument(update2))).filter(this.toBsonDocument(filter2))).projection(this.toBsonDocument(options2.getProjection()))).sort(this.toBsonDocument(options2.getSort()))).returnOriginal(options2.getReturnDocument() == ReturnDocument.BEFORE).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation())).arrayFilters(this.toBsonDocumentList(options2.getArrayFilters())).hint(options2.getHint())).hintString(options2.getHintString())).comment(options2.getComment())).let(this.toBsonDocument(options2.getLet()));
    }

    FindAndUpdateOperation<TDocument> findOneAndUpdate(Bson filter2, List<? extends Bson> update2, FindOneAndUpdateOptions options2) {
        return ((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)new FindAndUpdateOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec(), Assertions.assertNotNull(this.toBsonDocumentList(update2))).filter(this.toBsonDocument(filter2))).projection(this.toBsonDocument(options2.getProjection()))).sort(this.toBsonDocument(options2.getSort()))).returnOriginal(options2.getReturnDocument() == ReturnDocument.BEFORE).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation())).arrayFilters(this.toBsonDocumentList(options2.getArrayFilters())).hint(options2.getHint())).hintString(options2.getHintString())).comment(options2.getComment())).let(this.toBsonDocument(options2.getLet()));
    }

    MixedBulkWriteOperation insertOne(TDocument document2, InsertOneOptions options2) {
        return this.bulkWrite(Collections.singletonList(new InsertOneModel<TDocument>(document2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()));
    }

    MixedBulkWriteOperation replaceOne(Bson filter2, TDocument replacement, ReplaceOptions options2) {
        return this.bulkWrite(Collections.singletonList(new ReplaceOneModel<TDocument>(filter2, replacement, options2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation deleteOne(Bson filter2, DeleteOptions options2) {
        return this.bulkWrite(Collections.singletonList(new DeleteOneModel(filter2, options2)), new BulkWriteOptions().comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation deleteMany(Bson filter2, DeleteOptions options2) {
        return this.bulkWrite(Collections.singletonList(new DeleteManyModel(filter2, options2)), new BulkWriteOptions().comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation updateOne(Bson filter2, Bson update2, UpdateOptions options2) {
        return this.bulkWrite(Collections.singletonList(new UpdateOneModel(filter2, update2, options2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation updateOne(Bson filter2, List<? extends Bson> update2, UpdateOptions options2) {
        return this.bulkWrite(Collections.singletonList(new UpdateOneModel(filter2, update2, options2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation updateMany(Bson filter2, Bson update2, UpdateOptions options2) {
        return this.bulkWrite(Collections.singletonList(new UpdateManyModel(filter2, update2, options2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation updateMany(Bson filter2, List<? extends Bson> update2, UpdateOptions options2) {
        return this.bulkWrite(Collections.singletonList(new UpdateManyModel(filter2, update2, options2)), new BulkWriteOptions().bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()).let(options2.getLet()));
    }

    MixedBulkWriteOperation insertMany(List<? extends TDocument> documents, InsertManyOptions options2) {
        Assertions.notNull("documents", documents);
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (TDocument document2 : documents) {
            if (document2 == null) {
                throw new IllegalArgumentException("documents can not contain a null value");
            }
            if (this.getCodec() instanceof CollectibleCodec) {
                document2 = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document2);
            }
            requests.add(new InsertRequest(this.documentToBsonDocument(document2)));
        }
        return new MixedBulkWriteOperation(Assertions.assertNotNull(this.namespace), requests, options2.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment());
    }

    MixedBulkWriteOperation bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options2) {
        Assertions.notNull("requests", requests);
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<TDocument> writeModel : requests) {
            BsonValue update2;
            WriteRequest writeRequest;
            if (writeModel == null) {
                throw new IllegalArgumentException("requests can not contain a null value");
            }
            if (writeModel instanceof InsertOneModel) {
                Object document2 = ((InsertOneModel)writeModel).getDocument();
                if (this.getCodec() instanceof CollectibleCodec) {
                    document2 = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document2);
                }
                writeRequest = new InsertRequest(this.documentToBsonDocument(document2));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(Assertions.assertNotNull(this.toBsonDocument(replaceOneModel.getFilter())), this.documentToBsonDocument(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getReplaceOptions().isUpsert()).collation(replaceOneModel.getReplaceOptions().getCollation()).hint(replaceOneModel.getReplaceOptions().getHint()).hintString(replaceOneModel.getReplaceOptions().getHintString());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                update2 = updateOneModel.getUpdate() != null ? this.toBsonDocument(updateOneModel.getUpdate()) : new BsonArray(this.toBsonDocumentList(updateOneModel.getUpdatePipeline()));
                writeRequest = new UpdateRequest(Assertions.assertNotNull(this.toBsonDocument(updateOneModel.getFilter())), update2, WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert()).collation(updateOneModel.getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(updateOneModel.getOptions().getArrayFilters())).hint(updateOneModel.getOptions().getHint()).hintString(updateOneModel.getOptions().getHintString());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                update2 = updateManyModel.getUpdate() != null ? this.toBsonDocument(updateManyModel.getUpdate()) : new BsonArray(this.toBsonDocumentList(updateManyModel.getUpdatePipeline()));
                writeRequest = new UpdateRequest(Assertions.assertNotNull(this.toBsonDocument(updateManyModel.getFilter())), update2, WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert()).collation(updateManyModel.getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(updateManyModel.getOptions().getArrayFilters())).hint(updateManyModel.getOptions().getHint()).hintString(updateManyModel.getOptions().getHintString());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(Assertions.assertNotNull(this.toBsonDocument(deleteOneModel.getFilter()))).multi(false).collation(deleteOneModel.getOptions().getCollation()).hint(deleteOneModel.getOptions().getHint()).hintString(deleteOneModel.getOptions().getHintString());
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(Assertions.assertNotNull(this.toBsonDocument(deleteManyModel.getFilter()))).multi(true).collation(deleteManyModel.getOptions().getCollation()).hint(deleteManyModel.getOptions().getHint()).hintString(deleteManyModel.getOptions().getHintString());
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add((InsertRequest)writeRequest);
        }
        return new MixedBulkWriteOperation(Assertions.assertNotNull(this.namespace), writeRequests, options2.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(options2.getBypassDocumentValidation()).comment(options2.getComment()).let(this.toBsonDocument(options2.getLet()));
    }

    <TResult> CommandReadOperation<TResult> commandRead(Bson command2, Class<TResult> resultClass) {
        Assertions.notNull("command", command2);
        Assertions.notNull("resultClass", resultClass);
        return new CommandReadOperation<TResult>(Assertions.assertNotNull(this.namespace).getDatabaseName(), Assertions.assertNotNull(this.toBsonDocument(command2)), this.codecRegistry.get(resultClass));
    }

    DropDatabaseOperation dropDatabase() {
        return new DropDatabaseOperation(Assertions.assertNotNull(this.namespace).getDatabaseName(), this.getWriteConcern());
    }

    CreateCollectionOperation createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        IndexOptionDefaults indexOptionDefaults;
        Bson storageEngine;
        Map<String, BsonDocument> encryptedFieldsMap;
        CreateCollectionOperation operation = new CreateCollectionOperation(Assertions.assertNotNull(this.namespace).getDatabaseName(), collectionName, this.writeConcern).collation(createCollectionOptions.getCollation()).capped(createCollectionOptions.isCapped()).sizeInBytes(createCollectionOptions.getSizeInBytes()).maxDocuments(createCollectionOptions.getMaxDocuments()).storageEngineOptions(this.toBsonDocument(createCollectionOptions.getStorageEngineOptions())).expireAfter(createCollectionOptions.getExpireAfter(TimeUnit.SECONDS)).timeSeriesOptions(createCollectionOptions.getTimeSeriesOptions()).changeStreamPreAndPostImagesOptions(createCollectionOptions.getChangeStreamPreAndPostImagesOptions());
        ClusteredIndexOptions clusteredIndexOptions = createCollectionOptions.getClusteredIndexOptions();
        if (clusteredIndexOptions != null) {
            operation.clusteredIndexKey(this.toBsonDocument(clusteredIndexOptions.getKey()));
            operation.clusteredIndexUnique(clusteredIndexOptions.isUnique());
            operation.clusteredIndexName(clusteredIndexOptions.getName());
        }
        Bson encryptedFields = createCollectionOptions.getEncryptedFields();
        operation.encryptedFields(this.toBsonDocument(encryptedFields));
        if (encryptedFields == null && autoEncryptionSettings != null && (encryptedFieldsMap = autoEncryptionSettings.getEncryptedFieldsMap()) != null) {
            operation.encryptedFields(encryptedFieldsMap.getOrDefault(this.namespace.getDatabaseName() + "." + collectionName, null));
        }
        if ((storageEngine = (indexOptionDefaults = createCollectionOptions.getIndexOptionDefaults()).getStorageEngine()) != null) {
            operation.indexOptionDefaults(new BsonDocument("storageEngine", this.toBsonDocument(storageEngine)));
        }
        ValidationOptions validationOptions = createCollectionOptions.getValidationOptions();
        Bson validator = validationOptions.getValidator();
        operation.validator(this.toBsonDocument(validator));
        operation.validationLevel(validationOptions.getValidationLevel());
        operation.validationAction(validationOptions.getValidationAction());
        return operation;
    }

    DropCollectionOperation dropCollection(DropCollectionOptions dropCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        Map<String, BsonDocument> encryptedFieldsMap;
        DropCollectionOperation operation = new DropCollectionOperation(Assertions.assertNotNull(this.namespace), this.writeConcern);
        Bson encryptedFields = dropCollectionOptions.getEncryptedFields();
        if (encryptedFields != null) {
            operation.encryptedFields(Assertions.assertNotNull(this.toBsonDocument(encryptedFields)));
        } else if (autoEncryptionSettings != null && (encryptedFieldsMap = autoEncryptionSettings.getEncryptedFieldsMap()) != null) {
            operation.encryptedFields(encryptedFieldsMap.getOrDefault(this.namespace.getFullName(), null));
            operation.autoEncryptedFields(true);
        }
        return operation;
    }

    RenameCollectionOperation renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        return new RenameCollectionOperation(Assertions.assertNotNull(this.namespace), newCollectionNamespace, this.writeConcern).dropTarget(renameCollectionOptions.isDropTarget());
    }

    CreateViewOperation createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        Assertions.notNull("options", createViewOptions);
        Assertions.notNull("pipeline", pipeline);
        return new CreateViewOperation(Assertions.assertNotNull(this.namespace).getDatabaseName(), viewName, viewOn, Assertions.assertNotNull(this.toBsonDocumentList(pipeline)), this.writeConcern).collation(createViewOptions.getCollation());
    }

    CreateIndexesOperation createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        Assertions.notNull("indexes", indexes);
        Assertions.notNull("createIndexOptions", createIndexOptions);
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>(indexes.size());
        for (IndexModel model : indexes) {
            if (model == null) {
                throw new IllegalArgumentException("indexes can not contain a null value");
            }
            indexRequests.add(new IndexRequest(Assertions.assertNotNull(this.toBsonDocument(model.getKeys()))).name(model.getOptions().getName()).background(model.getOptions().isBackground()).unique(model.getOptions().isUnique()).sparse(model.getOptions().isSparse()).expireAfter(model.getOptions().getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(model.getOptions().getVersion()).weights(this.toBsonDocument(model.getOptions().getWeights())).defaultLanguage(model.getOptions().getDefaultLanguage()).languageOverride(model.getOptions().getLanguageOverride()).textVersion(model.getOptions().getTextVersion()).sphereVersion(model.getOptions().getSphereVersion()).bits(model.getOptions().getBits()).min(model.getOptions().getMin()).max(model.getOptions().getMax()).bucketSize(model.getOptions().getBucketSize()).storageEngine(this.toBsonDocument(model.getOptions().getStorageEngine())).partialFilterExpression(this.toBsonDocument(model.getOptions().getPartialFilterExpression())).collation(model.getOptions().getCollation()).wildcardProjection(this.toBsonDocument(model.getOptions().getWildcardProjection())).hidden(model.getOptions().isHidden()));
        }
        return new CreateIndexesOperation(Assertions.assertNotNull(this.namespace), indexRequests, this.writeConcern).maxTime(createIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).commitQuorum(createIndexOptions.getCommitQuorum());
    }

    DropIndexOperation dropIndex(String indexName2, DropIndexOptions dropIndexOptions) {
        return new DropIndexOperation(Assertions.assertNotNull(this.namespace), indexName2, this.writeConcern).maxTime(dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    DropIndexOperation dropIndex(Bson keys2, DropIndexOptions dropIndexOptions) {
        return new DropIndexOperation(Assertions.assertNotNull(this.namespace), keys2.toBsonDocument(BsonDocument.class, this.codecRegistry), this.writeConcern).maxTime(dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    <TResult> ListCollectionsOperation<TResult> listCollections(String databaseName, Class<TResult> resultClass, Bson filter2, boolean collectionNamesOnly, @Nullable Integer batchSize, long maxTimeMS, BsonValue comment) {
        return new ListCollectionsOperation<TResult>(databaseName, this.codecRegistry.get(resultClass)).retryReads(this.retryReads).filter(this.toBsonDocument(filter2)).nameOnly(collectionNamesOnly).batchSize(batchSize == null ? 0 : batchSize).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).comment(comment);
    }

    <TResult> ListDatabasesOperation<TResult> listDatabases(Class<TResult> resultClass, Bson filter2, Boolean nameOnly, long maxTimeMS, Boolean authorizedDatabasesOnly, BsonValue comment) {
        return new ListDatabasesOperation<TResult>(this.codecRegistry.get(resultClass)).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).retryReads(this.retryReads).filter(this.toBsonDocument(filter2)).nameOnly(nameOnly).authorizedDatabasesOnly(authorizedDatabasesOnly).comment(comment);
    }

    <TResult> ListIndexesOperation<TResult> listIndexes(Class<TResult> resultClass, @Nullable Integer batchSize, long maxTimeMS, BsonValue comment) {
        return new ListIndexesOperation<TResult>(Assertions.assertNotNull(this.namespace), this.codecRegistry.get(resultClass)).retryReads(this.retryReads).batchSize(batchSize == null ? 0 : batchSize).maxTime(maxTimeMS, TimeUnit.MILLISECONDS).comment(comment);
    }

    <TResult> ChangeStreamOperation<TResult> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> pipeline, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, @Nullable Integer batchSize, Collation collation, BsonValue comment, long maxAwaitTimeMS, BsonDocument resumeToken, BsonTimestamp startAtOperationTime, BsonDocument startAfter, boolean showExpandedEvents) {
        return new ChangeStreamOperation<TResult>(Assertions.assertNotNull(this.namespace), fullDocument, fullDocumentBeforeChange, Assertions.assertNotNull(this.toBsonDocumentList(pipeline)), decoder, changeStreamLevel).batchSize(batchSize).collation(collation).comment(comment).maxAwaitTime(maxAwaitTimeMS, TimeUnit.MILLISECONDS).resumeAfter(resumeToken).startAtOperationTime(startAtOperationTime).startAfter(startAfter).showExpandedEvents(showExpandedEvents).retryReads(this.retryReads);
    }

    private Codec<TDocument> getCodec() {
        return this.codecRegistry.get(this.documentClass);
    }

    private BsonDocument documentToBsonDocument(TDocument document2) {
        return BsonDocumentWrapper.asBsonDocument(document2, this.codecRegistry);
    }

    @Nullable
    private BsonDocument toBsonDocument(@Nullable Bson bson) {
        return bson == null ? null : bson.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    @Nullable
    private List<BsonDocument> toBsonDocumentList(@Nullable List<? extends Bson> bsonList) {
        if (bsonList == null) {
            return null;
        }
        ArrayList<BsonDocument> bsonDocumentList = new ArrayList<BsonDocument>(bsonList.size());
        for (Bson bson : bsonList) {
            if (bson == null) {
                throw new IllegalArgumentException("All documents in the list must be non-null");
            }
            bsonDocumentList.add(this.toBsonDocument(bson));
        }
        return bsonDocumentList;
    }
}

