/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncOperations;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursor;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.BatchCursorFlux;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactivestreams.Subscriber;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.util.function.Supplier;

public abstract class BatchCursorPublisher<T>
implements Publisher<T> {
    private final ClientSession clientSession;
    private final MongoOperationPublisher<T> mongoOperationPublisher;
    private Integer batchSize;

    BatchCursorPublisher(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher) {
        this(clientSession, mongoOperationPublisher, null);
    }

    BatchCursorPublisher(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, @Nullable Integer batchSize) {
        this.clientSession = clientSession;
        this.mongoOperationPublisher = Assertions.notNull("mongoOperationPublisher", mongoOperationPublisher);
        this.batchSize = batchSize;
    }

    abstract AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int var1);

    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncFirstReadOperation() {
        return this.asAsyncReadOperation(1);
    }

    @Nullable
    ClientSession getClientSession() {
        return this.clientSession;
    }

    MongoOperationPublisher<T> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    AsyncOperations<T> getOperations() {
        return this.mongoOperationPublisher.getOperations();
    }

    MongoNamespace getNamespace() {
        return Assertions.assertNotNull(this.mongoOperationPublisher.getNamespace());
    }

    ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    boolean getRetryReads() {
        return this.mongoOperationPublisher.getRetryReads();
    }

    Class<T> getDocumentClass() {
        return this.mongoOperationPublisher.getDocumentClass();
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Publisher<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Publisher<T> first() {
        return this.batchCursor(this::asAsyncFirstReadOperation).flatMap(batchCursor -> Mono.create(sink -> {
            batchCursor.setBatchSize(1);
            Mono.from(batchCursor.next()).doOnTerminate(batchCursor::close).doOnError(sink::error).doOnSuccess(results -> {
                if (results == null || results.isEmpty()) {
                    sink.success();
                } else {
                    sink.success(results.get(0));
                }
            }).contextWrite(sink.contextView()).subscribe();
        }));
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        new BatchCursorFlux<T>(this).subscribe(subscriber);
    }

    public Mono<BatchCursor<T>> batchCursor(int initialBatchSize) {
        return this.batchCursor(() -> this.asAsyncReadOperation(initialBatchSize));
    }

    Mono<BatchCursor<T>> batchCursor(Supplier<AsyncReadOperation<AsyncBatchCursor<T>>> supplier) {
        return this.mongoOperationPublisher.createReadOperationMono(supplier, this.clientSession).map(BatchCursor::new);
    }
}

