/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.ServerApi;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterType;
import com.willfp.eco.libs.mongodb.connection.ServerDescription;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AbstractReferenceCounted;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncConnectionSource;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.TransactionContext;
import com.willfp.eco.libs.mongodb.internal.connection.AsyncConnection;
import com.willfp.eco.libs.mongodb.internal.connection.OperationContext;
import com.willfp.eco.libs.mongodb.internal.session.ClientSessionContext;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = Assertions.notNull("wrapped", wrapped).retain();
        this.ownsSession = ownsSession;
        this.session = Assertions.notNull("session", session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.isConnectionSourcePinningRequired((isConnectionSourcePinningRequired, t2) -> {
            if (t2 != null) {
                callback.onResult(null, t2);
            } else if (isConnectionSourcePinningRequired.booleanValue()) {
                this.getPinnedConnectionSource(true, callback);
            } else {
                this.wrapped.getReadConnectionSource(new WrappingCallback(callback));
            }
        });
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.isConnectionSourcePinningRequired((isConnectionSourcePinningRequired, t2) -> {
            if (t2 != null) {
                callback.onResult(null, t2);
            } else if (isConnectionSourcePinningRequired.booleanValue()) {
                this.getPinnedConnectionSource(false, callback);
            } else {
                this.wrapped.getWriteConnectionSource(new WrappingCallback(callback));
            }
        });
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Override
    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    @Override
    public OperationContext getOperationContext() {
        return this.wrapped.getOperationContext();
    }

    private void getPinnedConnectionSource(boolean isRead, SingleResultCallback<AsyncConnectionSource> callback) {
        WrappingCallback wrappingCallback = new WrappingCallback(callback);
        Object transactionContext = TransactionContext.get(this.session);
        if (transactionContext == null) {
            SingleResultCallback<AsyncConnectionSource> connectionSourceCallback = (result2, t2) -> {
                if (t2 != null) {
                    wrappingCallback.onResult(null, t2);
                } else {
                    TransactionContext newTransactionContext = new TransactionContext(this.wrapped.getCluster().getDescription().getType());
                    this.session.setTransactionContext(result2.getServerDescription().getAddress(), newTransactionContext);
                    newTransactionContext.release();
                    wrappingCallback.onResult((AsyncConnectionSource)result2, (Throwable)null);
                }
            };
            if (isRead) {
                this.wrapped.getReadConnectionSource(connectionSourceCallback);
            } else {
                this.wrapped.getWriteConnectionSource(connectionSourceCallback);
            }
        } else {
            this.wrapped.getConnectionSource(Assertions.assertNotNull(this.session.getPinnedServerAddress()), new WrappingCallback(callback));
        }
    }

    @Override
    public AsyncReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, callback);
    }

    @Override
    public int release() {
        int count2 = super.release();
        if (count2 == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count2;
    }

    private void isConnectionSourcePinningRequired(SingleResultCallback<Boolean> callback) {
        try {
            callback.onResult(this.isConnectionSourcePinningRequired(), null);
        }
        catch (Exception e) {
            callback.onResult(null, e);
        }
    }

    private boolean isConnectionSourcePinningRequired() {
        ClusterType clusterType = this.wrapped.getCluster().getDescription().getType();
        return this.session.hasActiveTransaction() && (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED);
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        AsyncClientSessionContext(ClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean isSnapshot() {
            Boolean snapshot = this.clientSession.getOptions().isSnapshot();
            return snapshot != null && snapshot != false;
        }

        @Override
        public void setSnapshotTimestamp(@Nullable BsonTimestamp snapshotTimestamp) {
            this.clientSession.setSnapshotTimestamp(snapshotTimestamp);
        }

        @Override
        @Nullable
        public BsonTimestamp getSnapshotTimestamp() {
            return this.clientSession.getSnapshotTimestamp();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return Assertions.assertNotNull(this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource result2, @Nullable Throwable t2) {
            if (t2 != null) {
                this.callback.onResult(null, t2);
            } else {
                this.callback.onResult(new SessionBindingAsyncConnectionSource(Assertions.assertNotNull(result2)), null);
            }
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Override
        @Nullable
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        @Override
        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        @Override
        public OperationContext getOperationContext() {
            return this.wrapped.getOperationContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            Object transactionContext = TransactionContext.get(ClientSessionBinding.this.session);
            if (transactionContext != null && ((TransactionContext)transactionContext).isConnectionPinningRequired()) {
                AsyncConnection pinnedConnection = (AsyncConnection)((TransactionContext)transactionContext).getPinnedConnection();
                if (pinnedConnection == null) {
                    this.wrapped.getConnection((connection, t2) -> {
                        if (t2 != null) {
                            callback.onResult(null, t2);
                        } else {
                            transactionContext.pinConnection(connection, AsyncConnection::markAsPinned);
                            callback.onResult((AsyncConnection)connection, null);
                        }
                    });
                } else {
                    callback.onResult(pinnedConnection.retain(), null);
                }
            } else {
                this.wrapped.getConnection(callback);
            }
        }

        @Override
        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int count2 = this.wrapped.release();
            if (count2 == 0) {
                ClientSessionBinding.this.release();
            }
            return count2;
        }
    }
}

