/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonObjectId;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSFile;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClients;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoCollection;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoDatabase;
import com.willfp.eco.libs.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.willfp.eco.libs.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.gridfs.GridFSUploadPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs.GridFSPublisherCreator;
import com.willfp.eco.libs.reactivestreams.Publisher;
import java.nio.ByteBuffer;

public final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;

    public GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    public GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this(Assertions.notNull("bucketName", bucketName), 261120, GridFSBucketImpl.getFilesCollection(Assertions.notNull("database", database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.bucketName = Assertions.notNull("bucketName", bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = Assertions.notNull("filesCollection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries(database.getCodecRegistry(), MongoClients.getDefaultCodecRegistry()));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClients.getDefaultCodecRegistry());
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        Assertions.notNull("readPreference", readPreference);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        Assertions.notNull("writeConcern", writeConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        Assertions.notNull("readConcern", readConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options2) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, null, new BsonObjectId(), filename, options2, source).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id2, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(id2, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id2, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options2) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, null, id2, filename, options2, source);
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(clientSession, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options2) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession), new BsonObjectId(), filename, options2, source).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id2, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(clientSession, id2, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id2, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options2) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession), new BsonObjectId(), filename, options2, source);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ObjectId id2) {
        return this.downloadToPublisher(new BsonObjectId(id2));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(BsonValue id2) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, null, GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, new BsonDocument("_id", id2)));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename) {
        return this.downloadToPublisher(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename, GridFSDownloadOptions options2) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, null, GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, filename, options2));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, ObjectId id2) {
        return this.downloadToPublisher(clientSession, new BsonObjectId(id2));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, BsonValue id2) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, Assertions.notNull("clientSession", clientSession), GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, clientSession, new BsonDocument("_id", id2)));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename) {
        return this.downloadToPublisher(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename, GridFSDownloadOptions options2) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, Assertions.notNull("clientSession", clientSession), GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, clientSession, filename, options2));
    }

    @Override
    public GridFSFindPublisher find() {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, null);
    }

    @Override
    public GridFSFindPublisher find(Bson filter2) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, Assertions.notNull("filter", filter2));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, Assertions.notNull("clientSession", clientSession), null);
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession, Bson filter2) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, Assertions.notNull("clientSession", clientSession), Assertions.notNull("filter", filter2));
    }

    @Override
    public Publisher<Void> delete(ObjectId id2) {
        return this.delete(new BsonObjectId(id2));
    }

    @Override
    public Publisher<Void> delete(BsonValue id2) {
        return GridFSPublisherCreator.createDeletePublisher(this.filesCollection, this.chunksCollection, null, id2);
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, ObjectId id2) {
        return this.delete(clientSession, new BsonObjectId(id2));
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, BsonValue id2) {
        return GridFSPublisherCreator.createDeletePublisher(this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession), id2);
    }

    @Override
    public Publisher<Void> rename(ObjectId id2, String newFilename) {
        return this.rename(new BsonObjectId(id2), newFilename);
    }

    @Override
    public Publisher<Void> rename(BsonValue id2, String newFilename) {
        return GridFSPublisherCreator.createRenamePublisher(this.filesCollection, null, id2, newFilename);
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, ObjectId id2, String newFilename) {
        return this.rename(clientSession, new BsonObjectId(id2), newFilename);
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, BsonValue id2, String newFilename) {
        return GridFSPublisherCreator.createRenamePublisher(this.filesCollection, Assertions.notNull("clientSession", clientSession), id2, newFilename);
    }

    @Override
    public Publisher<Void> drop() {
        return GridFSPublisherCreator.createDropPublisher(this.filesCollection, this.chunksCollection, null);
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return GridFSPublisherCreator.createDropPublisher(this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession));
    }
}

