/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.MongoGridFSException;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSFile;
import com.willfp.eco.libs.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.willfp.eco.libs.mongodb.client.result.DeleteResult;
import com.willfp.eco.libs.mongodb.client.result.UpdateResult;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.FindPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoCollection;
import com.willfp.eco.libs.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs.GridFSDownloadPublisherImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs.GridFSFindPublisherImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.gridfs.GridFSUploadPublisherImpl;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.nio.ByteBuffer;

public final class GridFSPublisherCreator {
    private GridFSPublisherCreator() {
    }

    public static GridFSUploadPublisherImpl createGridFSUploadPublisher(int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, BsonValue id2, String filename, GridFSUploadOptions options2, Publisher<ByteBuffer> source) {
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("chunksCollection", chunksCollection);
        Assertions.notNull("id", id2);
        Assertions.notNull("filename", filename);
        Assertions.notNull("options", options2);
        Integer chunkSize = options2.getChunkSizeBytes();
        if (chunkSize == null) {
            chunkSize = chunkSizeBytes;
        }
        return new GridFSUploadPublisherImpl(clientSession, filesCollection, chunksCollection, id2, filename, chunkSize, options2.getMetadata(), source);
    }

    public static GridFSDownloadPublisherImpl createGridFSDownloadPublisher(MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, GridFSFindPublisher publisher) {
        Assertions.notNull("chunksCollection", chunksCollection);
        Assertions.notNull("publisher", publisher);
        return new GridFSDownloadPublisherImpl(clientSession, Mono.from(publisher), chunksCollection);
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter2) {
        Assertions.notNull("filesCollection", filesCollection);
        return new GridFSFindPublisherImpl(GridFSPublisherCreator.createFindPublisher(filesCollection, clientSession, filter2));
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options2) {
        int sort;
        int skip;
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("filename", filename);
        Assertions.notNull("options", options2);
        int revision = options2.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        return GridFSPublisherCreator.createGridFSFindPublisher(filesCollection, clientSession, new Document("filename", filename)).skip(skip).sort(new Document("uploadDate", sort));
    }

    public static FindPublisher<GridFSFile> createFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter2) {
        Assertions.notNull("filesCollection", filesCollection);
        FindPublisher<GridFSFile> publisher = clientSession == null ? filesCollection.find() : filesCollection.find(clientSession);
        if (filter2 != null) {
            publisher = publisher.filter(filter2);
        }
        return publisher;
    }

    public static Publisher<Void> createDeletePublisher(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, BsonValue id2) {
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("chunksCollection", chunksCollection);
        Assertions.notNull("id", id2);
        BsonDocument filter2 = new BsonDocument("_id", id2);
        Publisher<DeleteResult> fileDeletePublisher = clientSession == null ? filesCollection.deleteOne(filter2) : filesCollection.deleteOne(clientSession, filter2);
        return Mono.from(fileDeletePublisher).flatMap(deleteResult -> {
            if (deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
                throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id2));
            }
            if (clientSession == null) {
                return Mono.from(chunksCollection.deleteMany(new BsonDocument("files_id", id2)));
            }
            return Mono.from(chunksCollection.deleteMany(clientSession, new BsonDocument("files_id", id2)));
        }).flatMap(i -> Mono.empty());
    }

    public static Publisher<Void> createRenamePublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, BsonValue id2, String newFilename) {
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("id", id2);
        Assertions.notNull("newFilename", newFilename);
        BsonDocument filter2 = new BsonDocument("_id", id2);
        BsonDocument update2 = new BsonDocument("$set", new BsonDocument("filename", new BsonString(newFilename)));
        Publisher<UpdateResult> publisher = clientSession == null ? filesCollection.updateOne((Bson)filter2, update2) : filesCollection.updateOne(clientSession, (Bson)filter2, update2);
        return Mono.from(publisher).flatMap(updateResult -> {
            if (updateResult.wasAcknowledged() && updateResult.getModifiedCount() == 0L) {
                throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id2));
            }
            return Mono.empty();
        });
    }

    public static Publisher<Void> createDropPublisher(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession) {
        Publisher<Void> filesDropPublisher = clientSession == null ? filesCollection.drop() : filesCollection.drop(clientSession);
        Publisher<Void> chunksDropPublisher = clientSession == null ? chunksCollection.drop() : chunksCollection.drop(clientSession);
        return Mono.from(filesDropPublisher).then(Mono.from(chunksDropPublisher));
    }
}

