/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.objenesis.instantiator.android;

import com.willfp.eco.libs.objenesis.ObjenesisException;
import com.willfp.eco.libs.objenesis.instantiator.ObjectInstantiator;
import com.willfp.eco.libs.objenesis.instantiator.annotations.Instantiator;
import com.willfp.eco.libs.objenesis.instantiator.annotations.Typology;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;

@Instantiator(value=Typology.STANDARD)
public class Android10Instantiator<T>
implements ObjectInstantiator<T> {
    private final Class<T> type;
    private final Method newStaticMethod;

    public Android10Instantiator(Class<T> type2) {
        this.type = type2;
        this.newStaticMethod = Android10Instantiator.getNewStaticMethod();
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(this.newStaticMethod.invoke(null, this.type, Object.class));
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }

    private static Method getNewStaticMethod() {
        try {
            Method newStaticMethod = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
            newStaticMethod.setAccessible(true);
            return newStaticMethod;
        }
        catch (NoSuchMethodException | RuntimeException e) {
            throw new ObjenesisException(e);
        }
    }
}

