/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reactor.core.publisher;

import com.willfp.eco.libs.reactivestreams.Subscription;
import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.Scannable;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.core.publisher.Operators;
import com.willfp.eco.libs.reactor.core.publisher.SourceProducer;
import com.willfp.eco.libs.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

final class MonoRunnable<T>
extends Mono<T>
implements Callable<Void>,
SourceProducer<T> {
    final Runnable run;

    MonoRunnable(Runnable run2) {
        this.run = Objects.requireNonNull(run2, "run");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        MonoRunnableEagerSubscription s2 = new MonoRunnableEagerSubscription();
        actual.onSubscribe(s2);
        if (s2.isCancelled()) {
            return;
        }
        try {
            this.run.run();
            actual.onComplete();
        }
        catch (Throwable ex) {
            actual.onError(Operators.onOperatorError(ex, actual.currentContext()));
        }
    }

    @Override
    @Nullable
    public T block(Duration m4) {
        this.run.run();
        return null;
    }

    @Override
    @Nullable
    public T block() {
        this.run.run();
        return null;
    }

    @Override
    @Nullable
    public Void call() throws Exception {
        this.run.run();
        return null;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    static final class MonoRunnableEagerSubscription
    extends AtomicBoolean
    implements Subscription {
        MonoRunnableEagerSubscription() {
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
            this.set(true);
        }

        public boolean isCancelled() {
            return this.get();
        }
    }
}

