/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.NamespacedKeyUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.persistence.PersistentDataType;

public final class BlockUtils {
    @NotNull
    public static Set<Block> getVein(@NotNull Block start, @NotNull List<Material> allowedMaterials, int limit) {
        HashSet<Block> blocks = new HashSet<Block>();
        LinkedList<Block> toProcess = new LinkedList<Block>();
        if (allowedMaterials.contains(start.getType())) {
            toProcess.add(start);
        }
        while (!toProcess.isEmpty() && blocks.size() < limit) {
            Block currentBlock = (Block)toProcess.poll();
            if (blocks.contains(currentBlock)) continue;
            blocks.add(currentBlock);
            for (BlockFace face : BlockFace.values()) {
                Block adjacentBlock = currentBlock.getRelative(face);
                if (blocks.contains(adjacentBlock) || !allowedMaterials.contains(adjacentBlock.getType())) continue;
                toProcess.add(adjacentBlock);
            }
        }
        return blocks;
    }

    public static boolean isPlayerPlaced(@NotNull Block block) {
        Chunk chunk = block.getChunk();
        return chunk.getPersistentDataContainer().has(NamespacedKeyUtils.createEcoKey(Integer.toString(block.getLocation().hashCode(), 16)), PersistentDataType.INTEGER);
    }

    private BlockUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

