/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ListUtils {
    @NotNull
    public static <T> List<List<T>> create2DList(int rows, int columns2) {
        ArrayList<List<T>> list = new ArrayList<List<T>>(rows);
        while (list.size() < rows) {
            ArrayList row2 = new ArrayList(columns2);
            while (row2.size() < columns2) {
                row2.add(null);
            }
            list.add(row2);
        }
        return list;
    }

    @NotNull
    public static <T> Map<T, Integer> listToFrequencyMap(@NotNull List<T> list) {
        HashMap<T, Integer> frequencyMap = new HashMap<T, Integer>();
        for (T object : list) {
            if (frequencyMap.containsKey(object)) {
                frequencyMap.put(object, (Integer)frequencyMap.get(object) + 1);
                continue;
            }
            frequencyMap.put(object, 1);
        }
        return frequencyMap;
    }

    @NotNull
    public static <T> List<T> toSingletonList(@Nullable T object) {
        if (object == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(object);
    }

    @Nullable
    public static <T> T getOrNull(@Nullable List<T> list, int index) {
        if (list == null) {
            return null;
        }
        return index >= 0 && index < list.size() ? (T)list.get(index) : null;
    }

    public static boolean containsIgnoreCase(@NotNull Iterable<String> list, @NotNull String element) {
        for (String s2 : list) {
            if (!s2.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    private ListUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

