/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.math.MathContext;
import com.willfp.eco.core.placeholder.AdditionalPlayer;
import com.willfp.eco.core.placeholder.PlaceholderInjectable;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Player;

public final class NumberUtils {
    private static final double[] SIN_LOOKUP = new double[65536];
    private static final TreeMap<Integer, String> NUMERALS = new TreeMap();

    public static double fastSin(double a) {
        float f = (float)a;
        return SIN_LOOKUP[(int)(f * 10430.378f) & 0xFFFF];
    }

    public static double fastCos(double a) {
        float f = (float)a;
        return SIN_LOOKUP[(int)(f * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static double bias(double input, double bias) {
        double k = Math.pow(1.0 - bias, 3.0);
        return input * k / (input * k - input + 1.0);
    }

    @NotNull
    public static String toNumeral(int number) {
        if (number >= 1 && number <= 4096) {
            int l = NUMERALS.floorKey(number);
            if (number == l) {
                return NUMERALS.get(number);
            }
            return NUMERALS.get(l) + NumberUtils.toNumeral(number - l);
        }
        return String.valueOf(number);
    }

    public static int fromNumeral(@NotNull String numeral) {
        if (numeral.isEmpty()) {
            return 0;
        }
        for (Map.Entry entry : NUMERALS.descendingMap().entrySet()) {
            if (!numeral.startsWith((String)entry.getValue())) continue;
            return (Integer)entry.getKey() + NumberUtils.fromNumeral(numeral.substring(((String)entry.getValue()).length()));
        }
        return 0;
    }

    public static int randInt(int min2, int max) {
        return ThreadLocalRandom.current().nextInt(min2, max + 1);
    }

    public static double randFloat(double min2, double max) {
        return ThreadLocalRandom.current().nextDouble(min2, max);
    }

    public static double triangularDistribution(double minimum, double maximum, double peak) {
        double f = (peak - minimum) / (maximum - minimum);
        double rand = Math.random();
        if (rand < f) {
            return minimum + Math.sqrt(rand * (maximum - minimum) * (peak - minimum));
        }
        return maximum - Math.sqrt((1.0 - rand) * (maximum - minimum) * (maximum - peak));
    }

    public static int log2(int a) {
        return (int)NumberUtils.logBase(a, 2.0);
    }

    public static double logBase(double a, double base) {
        return Math.log(a) / Math.log(base);
    }

    @NotNull
    public static String format(double toFormat) {
        DecimalFormat df = new DecimalFormat("0.00");
        String formatted = df.format(toFormat);
        return formatted.endsWith("00") ? String.valueOf((int)toFormat) : formatted;
    }

    @NotNull
    public static String formatWithCommas(double toFormat) {
        DecimalFormat df = new DecimalFormat("#,##0.00");
        String formatted = df.format(toFormat);
        return formatted.endsWith(".00") ? formatted.substring(0, formatted.length() - 3) : formatted;
    }

    public static double evaluateExpression(@NotNull String expression) {
        return NumberUtils.evaluateExpression(expression, PlaceholderContext.EMPTY);
    }

    public static double evaluateExpression(@NotNull String expression, @Nullable Player player) {
        return NumberUtils.evaluateExpression(expression, player, null);
    }

    public static double evaluateExpression(@NotNull String expression, @Nullable Player player, @Nullable PlaceholderInjectable context) {
        return NumberUtils.evaluateExpression(expression, player, context, new ArrayList<AdditionalPlayer>());
    }

    public static double evaluateExpression(@NotNull String expression, @Nullable Player player, @Nullable PlaceholderInjectable context, @NotNull Collection<AdditionalPlayer> additionalPlayers) {
        return NumberUtils.evaluateExpression(expression, new PlaceholderContext(player, null, context, additionalPlayers));
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    public static double evaluateExpression(@NotNull String expression, @NotNull MathContext context) {
        return NumberUtils.evaluateExpression(expression, context.toPlaceholderContext());
    }

    public static double evaluateExpression(@NotNull String expression, @NotNull PlaceholderContext context) {
        return Objects.requireNonNullElse(NumberUtils.evaluateExpressionOrNull(expression, context), 0.0);
    }

    @Nullable
    public static Double evaluateExpressionOrNull(@NotNull String expression, @NotNull PlaceholderContext context) {
        return Eco.get().evaluate(expression, context);
    }

    private NumberUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NUMERALS.put(1000, "M");
        NUMERALS.put(900, "CM");
        NUMERALS.put(500, "D");
        NUMERALS.put(400, "CD");
        NUMERALS.put(100, "C");
        NUMERALS.put(90, "XC");
        NUMERALS.put(50, "L");
        NUMERALS.put(40, "XL");
        NUMERALS.put(10, "X");
        NUMERALS.put(9, "IX");
        NUMERALS.put(5, "V");
        NUMERALS.put(4, "IV");
        NUMERALS.put(1, "I");
        for (int i = 0; i < 65536; ++i) {
            NumberUtils.SIN_LOOKUP[i] = Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

