/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.examination.string;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.stream.Stream;

final class Strings {
    private Strings() {
    }

    @NotNull
    static String withSuffix(String string, char suffix) {
        return string + suffix;
    }

    @NotNull
    static String wrapIn(String string, char wrap) {
        return wrap + string + wrap;
    }

    static int maxLength(Stream<String> strings) {
        return strings.mapToInt(String::length).max().orElse(0);
    }

    @NotNull
    static String repeat(@NotNull String string, int count2) {
        if (count2 == 0) {
            return "";
        }
        if (count2 == 1) {
            return string;
        }
        StringBuilder sb = new StringBuilder(string.length() * count2);
        for (int i = 0; i < count2; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    @NotNull
    static String padEnd(@NotNull String string, int minLength, char padding) {
        return string.length() >= minLength ? string : String.format("%-" + minLength + "s", Character.valueOf(padding));
    }
}

