/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.exposed.dao.BackReference;
import org.jetbrains.exposed.dao.ColumnWithTransform;
import org.jetbrains.exposed.dao.DaoEntityID;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityCacheKt;
import org.jetbrains.exposed.dao.ImmutableEntityClass;
import org.jetbrains.exposed.dao.OptionalBackReference;
import org.jetbrains.exposed.dao.OptionalReference;
import org.jetbrains.exposed.dao.OptionalReferrers;
import org.jetbrains.exposed.dao.Reference;
import org.jetbrains.exposed.dao.Referrers;
import org.jetbrains.exposed.dao.View;
import org.jetbrains.exposed.dao.exceptions.EntityNotFoundException;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Count;
import org.jetbrains.exposed.sql.EntityIDColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.IterableExKt;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryAlias;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SizedCollection;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0010\b\u0001\u0010\u0003 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B%\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0010\b\u0002\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&J%\u0010(\u001a\u00028\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J+\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\u001d\u0010%\u001a\u0019\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0/\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u0004\u0018\u00018\u00012\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00104J\u001d\u00102\u001a\u0004\u0018\u00018\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0016\u00a2\u0006\u0002\u00105JD\u00106\u001a\b\u0012\u0004\u0012\u00028\u0001072\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020'0/\u00a2\u0006\u0002\b12\u001d\u0010%\u001a\u0019\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0/\u00a2\u0006\u0002\b1J\"\u00109\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000*0\u000fH\u0016J\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\u0016\u0010<\u001a\u00028\u00012\u0006\u00103\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00104J\u001c\u0010<\u001a\u00028\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0086\u0002\u00a2\u0006\u0002\u00105J\u001b\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0010\u00a2\u0006\u0002\b@J:\u0010A\u001a\u00020'\"\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002\"\u000e\b\u0003\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0000J0\u0010C\u001a\u00028\u00012\b\u00103\u001a\u0004\u0018\u00018\u00002\u0017\u0010D\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020>0/\u00a2\u0006\u0002\b1H\u0016\u00a2\u0006\u0002\u0010EJ&\u0010C\u001a\u00028\u00012\u0017\u0010D\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020>0/\u00a2\u0006\u0002\b1H\u0016\u00a2\u0006\u0002\u0010FJ;\u0010G\u001a\u0014\u0012\u0004\u0012\u0002HI\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010H\"\u000e\b\u0002\u0010I*\b\u0012\u0004\u0012\u0002HI0\u00022\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HI0\u0010H\u0086\u0004J9\u0010K\u001a\u0014\u0012\u0004\u0012\u0002HI\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010L\"\u000e\b\u0002\u0010I*\b\u0012\u0004\u0012\u0002HI0\u00022\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\u0010H\u0086\u0004J4\u0010M\u001a\u0002HN\"\n\b\u0002\u0010N\u0018\u0001*\u00020\u00052\n\u0010J\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010O\u001a\b\u0012\u0004\u0012\u0002HN0PH\u0082\b\u00a2\u0006\u0002\u0010QJ%\u0010R\u001a\u0004\u0018\u00018\u00012\f\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010T\u001a\u00020'\u00a2\u0006\u0002\u0010UJ\u0014\u0010V\u001a\u00020>2\f\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\u0016\u0010W\u001a\u00020X2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J%\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u0001072\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020'0/\u00a2\u0006\u0002\b1J\u001b\u0010Y\u001a\u0004\u0018\u00018\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000*\u00a2\u0006\u0002\u00105J1\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u00010[2\u001d\u0010%\u001a\u0019\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0/\u00a2\u0006\u0002\b1H\u0086\b\u00f8\u0001\u0000J\b\u0010\\\u001a\u00020]H\u0014J7\u0010^\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\u0010\u0010_\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0\u000f2\u0006\u0010`\u001a\u00020a2\n\b\u0002\u0010b\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010cJA\u0010d\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f\"\u0004\b\u0002\u0010e2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002He0\u000f2\u000e\u0010f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001He0\u00102\n\b\u0002\u0010b\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010gJ?\u0010h\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f\"\u0004\b\u0002\u0010e2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002He0\u000f2\f\u0010f\u001a\b\u0012\u0004\u0012\u0002He0\u00102\n\b\u0002\u0010b\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010gJ#\u0010i\u001a\u00028\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000*2\b\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\u0002\u0010-J\u0013\u0010j\u001a\u00028\u00012\u0006\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010kJ%\u0010j\u001a\u00028\u00012\u0006\u0010+\u001a\u00020,2\u0010\u0010l\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070m\u00a2\u0006\u0002\u0010nJ\u001b\u0010j\u001a\u00028\u00012\u0006\u0010+\u001a\u00020,2\u0006\u0010l\u001a\u00020o\u00a2\u0006\u0002\u0010pJ\u001a\u0010q\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020,0\"J,\u0010q\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0010\u0010l\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070mJ\"\u0010q\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0006\u0010l\u001a\u00020oJi\u0010s\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002Hu0t\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\u0010H\u0086\u0004Jp\u0010s\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002Hu0t\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HI0\u0010H\u0087\u0004\u00a2\u0006\u0002\bwJ{\u0010x\u001a&\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002HI0y\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\u0010H\u0086\u0004J\u0082\u0001\u0010x\u001a&\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002HI0y\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HI0\u0010H\u0087\u0004\u00a2\u0006\u0002\bzJ}\u0010{\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu\u0012\u0004\u0012\u0002HI0|\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HI0\u0010H\u0086\u0004J\u0084\u0001\u0010{\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu\u0012\u0004\u0012\u0002HI0|\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HI0\u00102\b\b\u0002\u0010}\u001a\u00020'J{\u0010~\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu\u0012\u0004\u0012\u0002HI0\u007f\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\u0010H\u0086\u0004J\u0080\u0001\u0010~\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu\u0012\u0004\u0012\u0002HI0\u007f\"\u000e\b\u0002\u0010v*\b\u0012\u0004\u0012\u0002Hv0\u0002\"\u000e\b\u0003\u0010u*\b\u0012\u0004\u0012\u0002Hv0\u0004\"\u000e\b\u0004\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0002*\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u0002Hu0\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\u00102\u0006\u0010}\u001a\u00020'J\r\u0010\u0080\u0001\u001a\u00020X*\u00020XH\u0002J]\u0010\u0081\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u0083\u0001\u0012\u0005\u0012\u0003H\u0084\u00010\u0082\u0001\"\u0005\b\u0002\u0010\u0083\u0001\"\u0005\b\u0003\u0010\u0084\u0001*\t\u0012\u0005\u0012\u0003H\u0083\u00010\u00102\u0015\u0010\u0085\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u0084\u0001\u0012\u0005\u0012\u0003H\u0083\u00010/2\u0015\u0010\u0086\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u0083\u0001\u0012\u0005\u0012\u0003H\u0084\u00010/R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00050\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019RR\u0010\u001a\u001aF\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\u0012\u0004\u0012\u00020\u00050\u001bj\"\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\u0012\u0004\u0012\u00020\u0005`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0087\u0001"}, d2={"Lorg/jetbrains/exposed/dao/EntityClass;", "ID", "", "T", "Lorg/jetbrains/exposed/dao/Entity;", "", "table", "Lorg/jetbrains/exposed/dao/id/IdTable;", "entityType", "Ljava/lang/Class;", "(Lorg/jetbrains/exposed/dao/id/IdTable;Ljava/lang/Class;)V", "ctor", "Lkotlin/reflect/KFunction;", "kotlin.jvm.PlatformType", "dependsOnColumns", "", "Lorg/jetbrains/exposed/sql/Column;", "getDependsOnColumns", "()Ljava/util/List;", "dependsOnTables", "Lorg/jetbrains/exposed/sql/ColumnSet;", "getDependsOnTables", "()Lorg/jetbrains/exposed/sql/ColumnSet;", "klass", "getKlass$exposed_dao", "()Ljava/lang/Class;", "refDefinitions", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lkotlin/reflect/KClass;", "Lkotlin/collections/HashMap;", "getTable", "()Lorg/jetbrains/exposed/dao/id/IdTable;", "all", "Lorg/jetbrains/exposed/sql/SizedIterable;", "count", "", "op", "Lorg/jetbrains/exposed/sql/Op;", "", "createInstance", "entityId", "Lorg/jetbrains/exposed/dao/id/EntityID;", "row", "Lorg/jetbrains/exposed/sql/ResultRow;", "(Lorg/jetbrains/exposed/dao/id/EntityID;Lorg/jetbrains/exposed/sql/ResultRow;)Lorg/jetbrains/exposed/dao/Entity;", "find", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "findById", "id", "(Ljava/lang/Comparable;)Lorg/jetbrains/exposed/dao/Entity;", "(Lorg/jetbrains/exposed/dao/id/EntityID;)Lorg/jetbrains/exposed/dao/Entity;", "findWithCacheCondition", "Lkotlin/sequences/Sequence;", "cacheCheckCondition", "forEntityIds", "ids", "forIds", "get", "invalidateEntityInCache", "", "o", "invalidateEntityInCache$exposed_dao", "isAssignableTo", "entityClass", "new", "init", "(Ljava/lang/Comparable;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/dao/Entity;", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/dao/Entity;", "optionalReferencedOn", "Lorg/jetbrains/exposed/dao/OptionalReference;", "REF", "column", "referencedOn", "Lorg/jetbrains/exposed/dao/Reference;", "registerRefRule", "R", "ref", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/sql/Column;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "reload", "entity", "flush", "(Lorg/jetbrains/exposed/dao/Entity;Z)Lorg/jetbrains/exposed/dao/Entity;", "removeFromCache", "searchQuery", "Lorg/jetbrains/exposed/sql/Query;", "testCache", "view", "Lorg/jetbrains/exposed/dao/View;", "warmCache", "Lorg/jetbrains/exposed/dao/EntityCache;", "warmUpLinkedReferences", "references", "linkTable", "Lorg/jetbrains/exposed/sql/Table;", "forUpdate", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/Table;Ljava/lang/Boolean;)Ljava/util/List;", "warmUpOptReferences", "SID", "refColumn", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Boolean;)Ljava/util/List;", "warmUpReferences", "wrap", "wrapRow", "(Lorg/jetbrains/exposed/sql/ResultRow;)Lorg/jetbrains/exposed/dao/Entity;", "alias", "Lorg/jetbrains/exposed/sql/Alias;", "(Lorg/jetbrains/exposed/sql/ResultRow;Lorg/jetbrains/exposed/sql/Alias;)Lorg/jetbrains/exposed/dao/Entity;", "Lorg/jetbrains/exposed/sql/QueryAlias;", "(Lorg/jetbrains/exposed/sql/ResultRow;Lorg/jetbrains/exposed/sql/QueryAlias;)Lorg/jetbrains/exposed/dao/Entity;", "wrapRows", "rows", "backReferencedOn", "Lkotlin/properties/ReadOnlyProperty;", "Target", "TargetID", "backReferencedOnOpt", "optionalBackReferencedOn", "Lorg/jetbrains/exposed/dao/OptionalBackReference;", "optionalBackReferencedOnOpt", "optionalReferrersOn", "Lorg/jetbrains/exposed/dao/OptionalReferrers;", "cache", "referrersOn", "Lorg/jetbrains/exposed/dao/Referrers;", "setForUpdateStatus", "transform", "Lorg/jetbrains/exposed/dao/ColumnWithTransform;", "TColumn", "TReal", "toColumn", "toReal", "exposed-dao"})
public abstract class EntityClass<ID extends Comparable<? super ID>, T extends Entity<ID>> {
    @NotNull
    private final IdTable<ID> table;
    @NotNull
    private final Class<?> klass;
    @NotNull
    private final KFunction<Object> ctor;
    @NotNull
    private final HashMap<Pair<Column<?>, KClass<?>>, Object> refDefinitions;

    public EntityClass(@NotNull IdTable<ID> table, @Nullable Class<T> entityType) {
        Intrinsics.checkNotNullParameter(table, "table");
        this.table = table;
        Class<Object> clazz = entityType;
        if (clazz == null && (clazz = this.getClass().getEnclosingClass()) == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<T of org.jetbrains.exposed.dao.EntityClass>");
        }
        this.klass = clazz;
        KFunction<?> kFunction = KClasses.getPrimaryConstructor(JvmClassMappingKt.getKotlinClass(this.klass));
        Intrinsics.checkNotNull(kFunction);
        this.ctor = kFunction;
        this.refDefinitions = new HashMap();
    }

    public /* synthetic */ EntityClass(IdTable idTable, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clazz = null;
        }
        this(idTable, clazz);
    }

    @NotNull
    public final IdTable<ID> getTable() {
        return this.table;
    }

    @NotNull
    public final Class<?> getKlass$exposed_dao() {
        return this.klass;
    }

    @NotNull
    public final T get(@NotNull EntityID<ID> id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        T t2 = this.findById(id2);
        if (t2 == null) {
            throw new EntityNotFoundException(id2, this);
        }
        return t2;
    }

    @NotNull
    public final T get(@NotNull ID id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        return this.get((ID)new DaoEntityID<ID>(id2, this.table));
    }

    @NotNull
    protected EntityCache warmCache() {
        return EntityCacheKt.getEntityCache(TransactionManager.Companion.current());
    }

    @Nullable
    public final T findById(@NotNull ID id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        return this.findById((EntityID)new DaoEntityID<ID>(id2, this.table));
    }

    @Nullable
    public T findById(@NotNull EntityID<ID> id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        Object object = this.testCache(id2);
        if (object == null) {
            object = (Entity)CollectionsKt.firstOrNull((Iterable)this.find((Function1<SqlExpressionBuilder, Op<Boolean>>)new Function1<SqlExpressionBuilder, Op<Boolean>>(this, id2){
                final /* synthetic */ EntityClass<ID, T> this$0;
                final /* synthetic */ EntityID<ID> $id;
                {
                    this.this$0 = $receiver;
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                    Intrinsics.checkNotNullParameter($this$find, "$this$find");
                    return $this$find.eq((ExpressionWithColumnType)this.this$0.getTable().getId(), this.$id);
                }
            }));
        }
        return object;
    }

    @Nullable
    public final T reload(@NotNull Entity<ID> entity, boolean flush2) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (flush2) {
            if (entity.isNewEntity$exposed_dao()) {
                EntityCacheKt.getEntityCache(TransactionManager.Companion.current()).flushInserts$exposed_dao(this.table);
            } else {
                Entity.flush$default(entity, null, 1, null);
            }
        }
        this.removeFromCache(entity);
        return entity.getId().get_value() != null ? (T)this.findById(entity.getId()) : null;
    }

    public static /* synthetic */ Entity reload$default(EntityClass entityClass, Entity entity, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reload");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return entityClass.reload(entity, bl);
    }

    public void invalidateEntityInCache$exposed_dao(@NotNull Entity<ID> o) {
        Intrinsics.checkNotNullParameter(o, "o");
        boolean entityAlreadyFlushed = o.getId().get_value() != null;
        boolean sameDatabase = Intrinsics.areEqual(TransactionManager.Companion.current().getDb(), o.getDb());
        if (entityAlreadyFlushed && sameDatabase) {
            T currentEntityInCache = this.testCache(o.getId());
            if (currentEntityInCache == null) {
                this.get((ID)o.getId());
                this.warmCache().store(o);
            } else if (currentEntityInCache != o) {
                SQLLogKt.getExposedLogger().error("Entity instance in cache differs from the provided: " + Reflection.getOrCreateKotlinClass(o.getClass()).getSimpleName() + " with ID " + o.getId().getValue() + ". Changes on entity could be missed.");
            }
        }
    }

    @Nullable
    public final T testCache(@NotNull EntityID<ID> id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        return this.warmCache().find(this, id2);
    }

    @NotNull
    public final Sequence<T> testCache(@NotNull Function1<? super T, Boolean> cacheCheckCondition) {
        Intrinsics.checkNotNullParameter(cacheCheckCondition, "cacheCheckCondition");
        return SequencesKt.filter(CollectionsKt.asSequence(this.warmCache().findAll(this)), new Function1<T, Boolean>(cacheCheckCondition){
            final /* synthetic */ Function1<T, Boolean> $cacheCheckCondition;
            {
                this.$cacheCheckCondition = $cacheCheckCondition;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$cacheCheckCondition.invoke(it);
            }
        });
    }

    public final void removeFromCache(@NotNull Entity<ID> entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        EntityCache cache2 = this.warmCache();
        cache2.remove(this.table, entity);
        Map $this$forEach$iv = cache2.getReferrers$exposed_dao();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it;
            Map.Entry element$iv;
            Map.Entry $dstr$col$referrers = element$iv = iterator2.next();
            boolean bl = false;
            Column col = (Column)$dstr$col$referrers.getKey();
            Map referrers = (Map)$dstr$col$referrers.getValue();
            referrers.remove(entity.getId());
            if (!Intrinsics.areEqual(col.getTable(), this.getTable())) continue;
            Entity<ID> $this$removeFromCache_u24lambda_u2d2_u24lambda_u2d0 = entity;
            boolean bl2 = false;
            if ($this$removeFromCache_u24lambda_u2d2_u24lambda_u2d0.lookup(col) == null) continue;
            boolean bl3 = false;
            SizedIterable cfr_ignored_0 = (SizedIterable)referrers.remove((EntityID)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SizedIterable<T> forEntityIds(@NotNull List<? extends EntityID<ID>> ids2) {
        void $this$forEntityIds_u24lambda_u2d4;
        SqlExpressionBuilder $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids2, "ids");
        List distinctIds = CollectionsKt.distinct((Iterable)ids2);
        if (distinctIds.isEmpty()) {
            return IterableExKt.emptySized();
        }
        Iterable $this$mapNotNull$iv = distinctIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            T it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            EntityID it = (EntityID)element$iv$iv;
            boolean bl2 = false;
            if (this.testCache(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cached = (List)destination$iv$iv;
        if (cached.size() == distinctIds.size()) {
            return new SizedCollection(cached);
        }
        Op.Companion this_$iv = Op.Companion;
        boolean $i$f$build = false;
        $this$mapNotNullTo$iv$iv = SqlExpressionBuilder.INSTANCE;
        EntityClass entityClass = this;
        EntityClass entityClass2 = this;
        boolean bl = false;
        Op op = $this$forEntityIds_u24lambda_u2d4.inList(this.getTable().getId(), distinctIds);
        return entityClass2.wrapRows(entityClass.searchQuery(op));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SizedIterable<T> forIds(@NotNull List<? extends ID> ids2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids2, "ids");
        Iterable iterable = ids2;
        EntityClass entityClass = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Comparable comparable = (Comparable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DaoEntityID<void>(it, this.getTable()));
        }
        return entityClass.forEntityIds((List)destination$iv$iv);
    }

    @NotNull
    public final SizedIterable<T> wrapRows(@NotNull SizedIterable<ResultRow> rows) {
        Intrinsics.checkNotNullParameter(rows, "rows");
        return IterableExKt.mapLazy(rows, new Function1<ResultRow, T>(this){
            final /* synthetic */ EntityClass<ID, T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull ResultRow it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.wrapRow(it);
            }
        });
    }

    @NotNull
    public final SizedIterable<T> wrapRows(@NotNull SizedIterable<ResultRow> rows, @NotNull Alias<? extends IdTable<?>> alias) {
        Intrinsics.checkNotNullParameter(rows, "rows");
        Intrinsics.checkNotNullParameter(alias, "alias");
        return IterableExKt.mapLazy(rows, new Function1<ResultRow, T>(this, alias){
            final /* synthetic */ EntityClass<ID, T> this$0;
            final /* synthetic */ Alias<IdTable<?>> $alias;
            {
                this.this$0 = $receiver;
                this.$alias = $alias;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull ResultRow it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.wrapRow(it, this.$alias);
            }
        });
    }

    @NotNull
    public final SizedIterable<T> wrapRows(@NotNull SizedIterable<ResultRow> rows, @NotNull QueryAlias alias) {
        Intrinsics.checkNotNullParameter(rows, "rows");
        Intrinsics.checkNotNullParameter(alias, "alias");
        return IterableExKt.mapLazy(rows, new Function1<ResultRow, T>(this, alias){
            final /* synthetic */ EntityClass<ID, T> this$0;
            final /* synthetic */ QueryAlias $alias;
            {
                this.this$0 = $receiver;
                this.$alias = $alias;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull ResultRow it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.wrapRow(it, this.$alias);
            }
        });
    }

    @NotNull
    public final T wrapRow(@NotNull ResultRow row2) {
        Intrinsics.checkNotNullParameter(row2, "row");
        T entity = this.wrap((EntityID)row2.get(this.table.getId()), row2);
        if (((Entity)entity).get_readValues() == null) {
            ((Entity)entity).set_readValues(row2);
        }
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final T wrapRow(@NotNull ResultRow row2, @NotNull Alias<? extends IdTable<?>> alias) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(row2, "row");
        Intrinsics.checkNotNullParameter(alias, "alias");
        if (!Intrinsics.areEqual(alias.getDelegate(), this.table)) {
            boolean $i$a$-require-EntityClass$wrapRow$22 = false;
            String $i$a$-require-EntityClass$wrapRow$22 = "Alias for a wrong table " + alias.getDelegate().getTableName() + " while " + this.getTable().getTableName() + " expected";
            throw new IllegalArgumentException($i$a$-require-EntityClass$wrapRow$22.toString());
        }
        Map<Expression<?>, Integer> $this$mapNotNull$iv = row2.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        Map<Expression<?>, Integer> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair<Expression, Object> pair;
            Column column;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry $dstr$exp$_u24__u24 = element$iv$iv;
            boolean bl2 = false;
            Expression exp = (Expression)$dstr$exp$_u24__u24.getKey();
            Column column2 = exp instanceof Column ? (Column)exp : null;
            Object value = row2.get(exp);
            if (column2 == null) {
                column = null;
            } else {
                Column it;
                boolean bl3 = false;
                column = alias.originalColumn(it);
            }
            Column originalColumn = column;
            if (originalColumn != null) {
                pair = TuplesKt.to(originalColumn, value);
            } else {
                Column column3 = column2;
                pair = Intrinsics.areEqual(column3 == null ? null : column3.getTable(), alias.getDelegate()) ? null : TuplesKt.to(exp, value);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map newFieldsMapping = MapsKt.toMap((List)destination$iv$iv);
        return this.wrapRow(ResultRow.Companion.createAndFillValues(newFieldsMapping));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final T wrapRow(@NotNull ResultRow row2, @NotNull QueryAlias alias) {
        void $this$mapNotNullTo$iv$iv;
        Object it;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter(row2, "row");
            Intrinsics.checkNotNullParameter(alias, "alias");
            Iterable $this$any$iv = alias.getColumns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Column)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((Alias)((Column)it).getTable()).getDelegate(), this.getTable())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (!bl) {
            boolean $i$a$-require-EntityClass$wrapRow$42 = false;
            String $i$a$-require-EntityClass$wrapRow$42 = "QueryAlias doesn't have any column from " + this.getTable().getTableName() + " table";
            throw new IllegalArgumentException($i$a$-require-EntityClass$wrapRow$42.toString());
        }
        List<Column<?>> originalColumns = alias.getQuery().getSet().getSource().getColumns();
        Map<Expression<?>, Integer> $this$mapNotNull$iv = row2.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair<Expression<Object>, Object> pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry $dstr$exp$_u24__u24 = element$iv$iv;
            boolean bl4 = false;
            Expression exp = (Expression)$dstr$exp$_u24__u24.getKey();
            Object value = row2.get(exp);
            if (exp instanceof Column && ((Column)exp).getTable() instanceof Alias) {
                Object delegate = ((Alias)((Column)exp).getTable()).getDelegate();
                Iterable $this$single$iv = originalColumns;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    Column it2 = (Column)element$iv;
                    boolean bl5 = false;
                    if (!(Intrinsics.areEqual(delegate, it2.getTable()) && Intrinsics.areEqual(((Column)exp).getName(), it2.getName()))) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Column column = single$iv;
                pair = TuplesKt.to(column, value);
            } else {
                pair = exp instanceof Column && Intrinsics.areEqual(((Column)exp).getTable(), this.getTable()) ? null : TuplesKt.to(exp, value);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map newFieldsMapping = MapsKt.toMap((List)destination$iv$iv);
        return this.wrapRow(ResultRow.Companion.createAndFillValues(newFieldsMapping));
    }

    @NotNull
    public SizedIterable<T> all() {
        return this.wrapRows(QueriesKt.selectAll(this.table).notForUpdate());
    }

    @NotNull
    public final SizedIterable<T> find(@NotNull Op<Boolean> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        this.warmCache();
        return this.wrapRows(this.searchQuery(op));
    }

    @NotNull
    public final SizedIterable<T> find(@NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        return this.find(op.invoke(SqlExpressionBuilder.INSTANCE));
    }

    @NotNull
    public final Sequence<T> findWithCacheCondition(@NotNull Function1<? super T, Boolean> cacheCheckCondition, @NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(cacheCheckCondition, "cacheCheckCondition");
        Intrinsics.checkNotNullParameter(op, "op");
        Sequence<? super T> cached = this.testCache(cacheCheckCondition);
        return SequencesKt.any(cached) ? cached : CollectionsKt.asSequence((Iterable)this.find(op));
    }

    @NotNull
    public ColumnSet getDependsOnTables() {
        return this.table;
    }

    @NotNull
    public List<Column<? extends Object>> getDependsOnColumns() {
        return this.getDependsOnTables().getColumns();
    }

    @NotNull
    public Query searchQuery(@NotNull Op<Boolean> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        FieldSet $this$select$iv = this.getDependsOnTables().slice(this.getDependsOnColumns());
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        EntityClass entityClass = this;
        boolean bl = false;
        Op<Boolean> op2 = op;
        return entityClass.setForUpdateStatus(QueriesKt.select(fieldSet, op2));
    }

    public final long count(@Nullable Op<Boolean> op) {
        Count countExpression = SQLExpressionBuilderKt.count((ExpressionWithColumnType)this.table.getId());
        Query query2 = QueriesKt.selectAll(this.table.slice(countExpression, new Expression[0])).notForUpdate();
        Op<Boolean> op2 = op;
        if (op2 != null) {
            Op<Boolean> it = op2;
            boolean bl = false;
            query2.adjustWhere((Function1<? super Op<Boolean>, ? extends Op<Boolean>>)new Function1<Op<Boolean>, Op<Boolean>>(op){
                final /* synthetic */ Op<Boolean> $op;
                {
                    this.$op = $op;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@Nullable Op<Boolean> $this$adjustWhere) {
                    return this.$op;
                }
            });
        }
        return ((Number)((ResultRow)CollectionsKt.first(query2)).get(countExpression)).longValue();
    }

    public static /* synthetic */ long count$default(EntityClass entityClass, Op op, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: count");
        }
        if ((n & 1) != 0) {
            op = null;
        }
        return entityClass.count(op);
    }

    @NotNull
    protected T createInstance(@NotNull EntityID<ID> entityId2, @Nullable ResultRow row2) {
        Intrinsics.checkNotNullParameter(entityId2, "entityId");
        Object[] objectArray = new Object[]{entityId2};
        Object r = this.ctor.call(objectArray);
        if (r == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of org.jetbrains.exposed.dao.EntityClass");
        }
        return (T)((Entity)r);
    }

    @NotNull
    public final T wrap(@NotNull EntityID<ID> id2, @Nullable ResultRow row2) {
        Object t2;
        Intrinsics.checkNotNullParameter(id2, "id");
        Transaction transaction2 = TransactionManager.Companion.current();
        Object t3 = EntityCacheKt.getEntityCache(transaction2).find(this, id2);
        if (t3 == null) {
            T t4;
            T t5 = t4 = this.createInstance(id2, row2);
            boolean bl = false;
            ((Entity)t5).setKlass$exposed_dao(this);
            ((Entity)t5).setDb$exposed_dao(transaction2.getDb());
            this.warmCache().store(this, t5);
            t2 = t4;
        } else {
            t2 = t3;
        }
        return t2;
    }

    @NotNull
    public T new(@NotNull Function1<? super T, Unit> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        return this.new(null, init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public T new(@Nullable ID id2, @NotNull Function1<? super T, Unit> init) {
        EntityID<ID> entityID;
        Intrinsics.checkNotNullParameter(init, "init");
        if (id2 == null && this.table.getId().getDefaultValueFun() != null) {
            Function0<EntityID<ID>> function0 = this.table.getId().getDefaultValueFun();
            Intrinsics.checkNotNull(function0);
            entityID = function0.invoke();
        } else {
            entityID = (EntityID<ID>)new DaoEntityID<ID>(id2, this.table);
        }
        EntityID<ID> entityId2 = entityID;
        EntityCache entityCache2 = this.warmCache();
        T prototype = this.createInstance(entityId2, null);
        ((Entity)prototype).setKlass$exposed_dao(this);
        ((Entity)prototype).setDb$exposed_dao(TransactionManager.Companion.current().getDb());
        ((Entity)prototype).set_readValues(ResultRow.Companion.createAndFillDefaults(this.getDependsOnColumns()));
        if (entityId2.get_value() != null) {
            Map map2 = ((Entity)prototype).getWriteValues();
            Column<EntityID<ID>> column = this.table.getId();
            map2.put(column, entityId2);
        }
        try {
            entityCache2.addNotInitializedEntityToQueue$exposed_dao((Entity<?>)prototype);
            init.invoke(prototype);
        }
        finally {
            entityCache2.finishEntityInitialization$exposed_dao((Entity<?>)prototype);
        }
        if (entityId2.get_value() == null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            ResultRow resultRow = ((Entity)prototype).get_readValues();
            Intrinsics.checkNotNull(resultRow);
            ResultRow readValues = resultRow;
            LinkedHashMap<Column<Object>, Object> writeValues = ((Entity)prototype).getWriteValues();
            Iterable $this$filter$iv = this.table.getColumns();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Column col = (Column)element$iv$iv;
                boolean bl = false;
                if (!(col.getDefaultValueFun() != null && !((Map)writeValues).containsKey(col) && readValues.hasValue(col))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Column col = (Column)element$iv;
                boolean bl = false;
                ((Map)writeValues).put(col, readValues.get(col));
            }
        }
        entityCache2.scheduleInsert(this, prototype);
        return prototype;
    }

    @NotNull
    public final View<T> view(@NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        boolean $i$f$view = false;
        return new View(op.invoke(SqlExpressionBuilder.INSTANCE), this);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <R> R registerRefRule(Column<?> column, Function0<? extends R> ref) {
        Object object;
        void $this$getOrPut$iv;
        boolean $i$f$registerRefRule = false;
        Map map2 = this.refDefinitions;
        Intrinsics.reifiedOperationMarker(4, "R");
        Pair<Column<?>, KClass> key$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(Object.class));
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            R answer$iv = ref.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.reifiedOperationMarker(1, "R");
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <REF extends Comparable<? super REF>> Reference<REF, ID, T> referencedOn(@NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass this_$iv = this;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(Reference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            Reference answer$iv$iv = new Reference(column, this);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (Reference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <REF extends Comparable<? super REF>> OptionalReference<REF, ID, T> optionalReferencedOn(@NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass this_$iv = this;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(OptionalReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalReference answer$iv$iv = new OptionalReference(column, this);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> ReadOnlyProperty<Entity<ID>, Target> backReferencedOn(@NotNull EntityClass<TargetID, ? extends Target> $this$backReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$backReferencedOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$backReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(BackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            BackReference answer$iv$iv = new BackReference(column, $this$backReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (BackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="backReferencedOnOpt")
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> ReadOnlyProperty<Entity<ID>, Target> backReferencedOnOpt(@NotNull EntityClass<TargetID, ? extends Target> $this$backReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$backReferencedOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$backReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(BackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            BackReference answer$iv$iv = new BackReference(column, $this$backReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (BackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalBackReference<TargetID, Target, ID, Entity<ID>, REF> optionalBackReferencedOn(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalBackReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalBackReferencedOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalBackReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(OptionalBackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalBackReference answer$iv$iv = new OptionalBackReference(column, $this$optionalBackReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalBackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="optionalBackReferencedOnOpt")
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalBackReference<TargetID, Target, ID, Entity<ID>, REF> optionalBackReferencedOnOpt(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalBackReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalBackReferencedOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalBackReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(OptionalBackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalBackReference answer$iv$iv = new OptionalBackReference(column, $this$optionalBackReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalBackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> Referrers<ID, Entity<ID>, TargetID, Target, REF> referrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$referrersOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$referrersOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$referrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(Referrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            Referrers answer$iv$iv = new Referrers(column, $this$referrersOn, true);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (Referrers)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> Referrers<ID, Entity<ID>, TargetID, Target, REF> referrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$referrersOn, @NotNull Column<REF> column, boolean cache2) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$referrersOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$referrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(Referrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            Referrers answer$iv$iv = new Referrers(column, $this$referrersOn, cache2);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (Referrers)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalReferrers<ID, Entity<ID>, TargetID, Target, REF> optionalReferrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalReferrersOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalReferrersOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalReferrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(OptionalReferrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalReferrers answer$iv$iv = new OptionalReferrers(column, $this$optionalReferrersOn, true);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalReferrers)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalReferrers<ID, Entity<ID>, TargetID, Target, REF> optionalReferrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalReferrersOn, @NotNull Column<REF> column, boolean cache2) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalReferrersOn, "<this>");
        Intrinsics.checkNotNullParameter(column, "column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalReferrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair<Column<REF>, KClass> key$iv$iv = TuplesKt.to(column, Reflection.getOrCreateKotlinClass(OptionalReferrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalReferrers answer$iv$iv = new OptionalReferrers(column, $this$optionalReferrersOn, cache2);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalReferrers)object;
    }

    public static /* synthetic */ OptionalReferrers optionalReferrersOn$default(EntityClass entityClass, EntityClass entityClass2, Column column, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: optionalReferrersOn");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return entityClass.optionalReferrersOn(entityClass2, column, bl);
    }

    @NotNull
    public final <TColumn, TReal> ColumnWithTransform<TColumn, TReal> transform(@NotNull Column<TColumn> $this$transform, @NotNull Function1<? super TReal, ? extends TColumn> toColumn, @NotNull Function1<? super TColumn, ? extends TReal> toReal) {
        Intrinsics.checkNotNullParameter($this$transform, "<this>");
        Intrinsics.checkNotNullParameter(toColumn, "toColumn");
        Intrinsics.checkNotNullParameter(toReal, "toReal");
        return new ColumnWithTransform<TColumn, TReal>($this$transform, toColumn, toReal);
    }

    private final Query setForUpdateStatus(Query $this$setForUpdateStatus) {
        return this instanceof ImmutableEntityClass ? $this$setForUpdateStatus.notForUpdate() : $this$setForUpdateStatus;
    }

    @NotNull
    public final <SID> List<T> warmUpOptReferences(@NotNull List<? extends SID> references2, @NotNull Column<SID> refColumn, @Nullable Boolean forUpdate) {
        Intrinsics.checkNotNullParameter(references2, "references");
        Intrinsics.checkNotNullParameter(refColumn, "refColumn");
        return this.warmUpReferences(references2, refColumn, forUpdate);
    }

    public static /* synthetic */ List warmUpOptReferences$default(EntityClass entityClass, List list, Column column, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warmUpOptReferences");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return entityClass.warmUpOptReferences(list, column, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <SID> List<T> warmUpReferences(@NotNull List<? extends SID> references2, @NotNull Column<SID> refColumn, @Nullable Boolean forUpdate) {
        void $this$forEach$iv;
        void $this$warmUpReferences_u24lambda_u2d34;
        Intrinsics.checkNotNullParameter(references2, "references");
        Intrinsics.checkNotNullParameter(refColumn, "refColumn");
        Column<?> column = refColumn.getReferee();
        Table table = column == null ? null : column.getTable();
        IdTable parentTable = table instanceof IdTable ? (IdTable)table : null;
        if (parentTable == null) {
            boolean $i$a$-requireNotNull-EntityClass$warmUpReferences$22 = false;
            String $i$a$-requireNotNull-EntityClass$warmUpReferences$22 = "RefColumn should have reference to IdTable";
            throw new IllegalArgumentException($i$a$-requireNotNull-EntityClass$warmUpReferences$22.toString());
        }
        if (references2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List distinctRefIds = CollectionsKt.distinct((Iterable)references2);
        Transaction transaction2 = TransactionManager.Companion.current();
        EntityCache cache2 = EntityCacheKt.getEntityCache(transaction2);
        boolean keepLoadedReferenceOutOfTransaction = transaction2.getDb().getConfig().getKeepLoadedReferencesOutOfTransaction();
        if (refColumn.getColumnType() instanceof EntityIDColumnType) {
            void $this$flatMapTo$iv$iv;
            Object result2;
            Iterator $this$groupByTo$iv$iv;
            Object element$iv$iv;
            Boolean $this$filterTo$iv$iv;
            Iterable $this$filter$iv = distinctRefIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Object object = $this$filterTo$iv$iv.iterator();
            while (object.hasNext()) {
                boolean bl;
                boolean bl2;
                Object it = element$iv$iv = object.next();
                boolean bl3 = false;
                Map<EntityID<?>, SizedIterable<?>> map2 = cache2.getReferrers$exposed_dao().get(refColumn);
                if (!(map2 == null ? true : (bl2 = !(bl = map2.containsKey(it))))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toLoad = (List)destination$iv$iv;
            if (!((Collection)toLoad).isEmpty()) {
                Object element$iv$iv2;
                SizedIterable<T> findQuery2 = this.find((Function1<SqlExpressionBuilder, Op<Boolean>>)new Function1<SqlExpressionBuilder, Op<Boolean>>(refColumn, (List<? extends Object>)toLoad){
                    final /* synthetic */ Column<SID> $refColumn;
                    final /* synthetic */ List<Object> $toLoad;
                    {
                        this.$refColumn = $refColumn;
                        this.$toLoad = $toLoad;
                        super(1);
                    }

                    @NotNull
                    public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                        Intrinsics.checkNotNullParameter($this$find, "$this$find");
                        return $this$find.inList(this.$refColumn, (Iterable)this.$toLoad);
                    }
                });
                $this$filterTo$iv$iv = forUpdate;
                List entities = CollectionsKt.toList((Iterable)(Intrinsics.areEqual($this$filterTo$iv$iv, true) ? findQuery2.forUpdate() : (Intrinsics.areEqual($this$filterTo$iv$iv, false) ? findQuery2.notForUpdate() : findQuery2)));
                Iterable $this$groupBy$iv = entities;
                boolean $i$f$groupBy = false;
                object = $this$groupBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator bl3 = $this$groupByTo$iv$iv.iterator();
                while (bl3.hasNext()) {
                    Object object2;
                    element$iv$iv2 = bl3.next();
                    Entity it = (Entity)element$iv$iv2;
                    boolean bl = false;
                    EntityID key$iv$iv = (EntityID)it.getReadValues().get(refColumn);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv2);
                }
                result2 = destination$iv$iv2;
                Iterable $this$forEach$iv2 = distinctRefIds;
                boolean $i$f$forEach = false;
                $this$groupByTo$iv$iv = $this$forEach$iv2.iterator();
                while ($this$groupByTo$iv$iv.hasNext()) {
                    Object element$iv;
                    Object id2 = element$iv = $this$groupByTo$iv$iv.next();
                    boolean bl = false;
                    Object it = element$iv$iv2 = cache2.getOrPutReferrers((EntityID)id2, refColumn, new Function0<SizedIterable<? extends T>>(result2, id2){
                        final /* synthetic */ Map<EntityID<?>, List<T>> $result;
                        final /* synthetic */ Object $id;
                        {
                            this.$result = $result;
                            this.$id = $id;
                            super(0);
                        }

                        @NotNull
                        public final SizedIterable<T> invoke() {
                            SizedCollection<T> sizedCollection;
                            List<T> list = this.$result.get(this.$id);
                            if (list == null) {
                                sizedCollection = null;
                            } else {
                                List<T> it = list;
                                boolean bl = false;
                                sizedCollection = new SizedCollection<T>((Collection)it);
                            }
                            return sizedCollection == null ? IterableExKt.emptySized() : (SizedIterable<T>)sizedCollection;
                        }
                    });
                    boolean bl5 = false;
                    if (!keepLoadedReferenceOutOfTransaction) continue;
                    T t2 = this.findById((EntityID)id2);
                    if (t2 == null) continue;
                    ((Entity)t2).storeReferenceInCache$exposed_dao(refColumn, it);
                }
            }
            Iterable $this$flatMap$iv = distinctRefIds;
            boolean $i$f$flatMap = false;
            result2 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            $this$groupByTo$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$groupByTo$iv$iv.hasNext()) {
                Object it = element$iv$iv = $this$groupByTo$iv$iv.next();
                boolean bl = false;
                SizedIterable sizedIterable = cache2.getReferrers((EntityID)it, refColumn);
                List list = sizedIterable == null ? null : CollectionsKt.toList(sizedIterable);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Op.Companion this_$iv = Op.Companion;
        boolean $i$f$build = false;
        SqlExpressionBuilder $this$flatMapTo$iv$iv = SqlExpressionBuilder.INSTANCE;
        EntityClass entityClass = this;
        boolean $i$a$-build-EntityClass$warmUpReferences$baseQuery$22 = false;
        Query baseQuery = entityClass.searchQuery($this$warmUpReferences_u24lambda_u2d34.inList(refColumn, distinctRefIds));
        Query finalQuery2 = baseQuery.getSet().getFields().contains(parentTable.getId()) ? baseQuery : baseQuery.adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(parentTable){
            final /* synthetic */ IdTable<?> $parentTable;
            {
                this.$parentTable = $parentTable;
                super(2);
            }

            @NotNull
            public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet it) {
                Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                Intrinsics.checkNotNullParameter(it, "it");
                return $this$adjustSlice.slice(CollectionsKt.plus((Collection)$this$adjustSlice.getFields(), this.$parentTable.getId()));
            }
        }).adjustColumnSet((Function1<? super ColumnSet, ? extends ColumnSet>)new Function1<ColumnSet, ColumnSet>(parentTable, refColumn){
            final /* synthetic */ IdTable<?> $parentTable;
            final /* synthetic */ Column<SID> $refColumn;
            {
                this.$parentTable = $parentTable;
                this.$refColumn = $refColumn;
                super(1);
            }

            @NotNull
            public final ColumnSet invoke(@NotNull ColumnSet $this$adjustColumnSet) {
                Intrinsics.checkNotNullParameter($this$adjustColumnSet, "$this$adjustColumnSet");
                return TableKt.innerJoin$default($this$adjustColumnSet, this.$parentTable, new Function1<ColumnSet, Expression<?>>(this.$refColumn){
                    final /* synthetic */ Column<SID> $refColumn;
                    {
                        this.$refColumn = $refColumn;
                        super(1);
                    }

                    @NotNull
                    public final Expression<?> invoke(@NotNull ColumnSet $this$innerJoin) {
                        Intrinsics.checkNotNullParameter($this$innerJoin, "$this$innerJoin");
                        return this.$refColumn;
                    }
                }, new Function1<IdTable<?>, Expression<?>>(this.$refColumn){
                    final /* synthetic */ Column<SID> $refColumn;
                    {
                        this.$refColumn = $refColumn;
                        super(1);
                    }

                    @NotNull
                    public final Expression<?> invoke(@NotNull IdTable<?> $this$innerJoin) {
                        Intrinsics.checkNotNullParameter($this$innerJoin, "$this$innerJoin");
                        Column<?> column = this.$refColumn.getReferee();
                        Intrinsics.checkNotNull(column);
                        return column;
                    }
                }, null, 8, null);
            }
        });
        SizedIterable<T> findQuery3 = this.wrapRows(finalQuery2);
        Boolean $i$a$-build-EntityClass$warmUpReferences$baseQuery$22 = forUpdate;
        List entities = CollectionsKt.distinct(CollectionsKt.toList((Iterable)(Intrinsics.areEqual($i$a$-build-EntityClass$warmUpReferences$baseQuery$22, true) ? findQuery3.forUpdate() : (Intrinsics.areEqual($i$a$-build-EntityClass$warmUpReferences$baseQuery$22, false) ? findQuery3.notForUpdate() : findQuery3))));
        Object $this$groupBy$iv = entities;
        boolean $i$f$groupBy = false;
        Iterable $this$groupByTo$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            EntityID key$iv$iv = (EntityID)it.getReadValues().get(parentTable.getId());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            SizedIterable sizedIterable;
            Map.Entry element$iv;
            Map.Entry $dstr$id$values = element$iv = iterator2.next();
            boolean bl = false;
            EntityID id3 = (EntityID)$dstr$id$values.getKey();
            List values2 = (List)$dstr$id$values.getValue();
            SizedIterable it = sizedIterable = cache2.getOrPutReferrers(id3, refColumn, new Function0<SizedIterable<? extends T>>(values2){
                final /* synthetic */ List<T> $values;
                {
                    this.$values = $values;
                    super(0);
                }

                @NotNull
                public final SizedIterable<T> invoke() {
                    return new SizedCollection<T>((Collection)this.$values);
                }
            });
            boolean bl7 = false;
            if (!keepLoadedReferenceOutOfTransaction) continue;
            T t3 = this.findById(id3);
            if (t3 == null) continue;
            ((Entity)t3).storeReferenceInCache$exposed_dao(refColumn, it);
        }
        return entities;
    }

    public static /* synthetic */ List warmUpReferences$default(EntityClass entityClass, List list, Column column, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warmUpReferences");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return entityClass.warmUpReferences(list, column, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> warmUpLinkedReferences(@NotNull List<? extends EntityID<?>> references2, @NotNull Table linkTable, @Nullable Boolean forUpdate) {
        void $this$flatMapTo$iv$iv;
        Iterable<Object> idsToLoad;
        List list;
        List list2;
        List single$iv;
        Column sourceRefColumn;
        Iterable $this$singleOrNull$iv;
        List distinctRefIds;
        block21: {
            Column column;
            Object v0;
            block20: {
                Intrinsics.checkNotNullParameter(references2, "references");
                Intrinsics.checkNotNullParameter(linkTable, "linkTable");
                if (references2.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                distinctRefIds = CollectionsKt.distinct((Iterable)references2);
                $this$singleOrNull$iv = linkTable.getColumns();
                boolean $i$f$singleOrNull = false;
                Object single$iv2 = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getReferee(), CollectionsKt.first(references2).getTable().getId())) continue;
                    if (found$iv) {
                        v0 = null;
                        break block20;
                    }
                    single$iv2 = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv2;
            }
            Object var7_27 = v0;
            Column column2 = column = var7_27 instanceof Column ? (Column)var7_27 : null;
            if (column == null) {
                throw new IllegalStateException("Can't detect source reference column".toString());
            }
            sourceRefColumn = column;
            Iterable $this$singleOrNull$iv2 = linkTable.getColumns();
            boolean $i$f$singleOrNull = false;
            single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv2) {
                Column it = (Column)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getReferee(), this.getTable().getId())) continue;
                if (found$iv) {
                    list2 = null;
                    break block21;
                }
                single$iv = (List)element$iv;
                found$iv = true;
            }
            list2 = !found$iv ? null : single$iv;
        }
        $this$singleOrNull$iv = list2;
        Column column = $this$singleOrNull$iv instanceof Column ? (Column)((Object)$this$singleOrNull$iv) : null;
        if (column == null) {
            throw new IllegalStateException("Can't detect target reference column".toString());
        }
        Column targetRefColumn = column;
        Transaction transaction2 = TransactionManager.Companion.current();
        Map<EntityID<Object>, SizedIterable<Object>> map2 = EntityCacheKt.getEntityCache(transaction2).getReferrers$exposed_dao().get(sourceRefColumn);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map<EntityID<?>, SizedIterable<?>> inCache = map2;
        List it = single$iv = CollectionsKt.minus((Iterable)distinctRefIds, (Iterable)inCache.keySet());
        boolean bl = false;
        List<Object> list3 = !((Collection)it).isEmpty() ? single$iv : null;
        if (list3 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            void $this$warmUpLinkedReferences_u24lambda_u2d48_u24lambda_u2d41;
            Object element$iv;
            idsToLoad = list3;
            boolean bl2 = false;
            element$iv = this.getDependsOnTables();
            Join join = element$iv instanceof Join ? (Join)element$iv : null;
            boolean alreadyInJoin = join == null ? false : (element$iv = join.alreadyInJoin(linkTable));
            ColumnSet entityTables = alreadyInJoin ? this.getDependsOnTables() : (ColumnSet)ColumnSet.join$default(this.getDependsOnTables(), linkTable, JoinType.INNER, targetRefColumn, this.getTable().getId(), null, 16, null);
            List<Column> columns2 = CollectionsKt.plus((Collection)CollectionsKt.distinct((Iterable)CollectionsKt.minus((Iterable)CollectionsKt.plus((Collection)this.getDependsOnColumns(), (Iterable)(!alreadyInJoin ? linkTable.getColumns() : CollectionsKt.emptyList())), sourceRefColumn)), sourceRefColumn);
            FieldSet $this$select$iv = entityTables.slice(columns2);
            boolean $i$f$select22 = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Object object = $this$select$iv;
            boolean $i$a$-select-EntityClass$warmUpLinkedReferences$loaded$2$query$22 = false;
            Query query2 = QueriesKt.select((FieldSet)object, $this$warmUpLinkedReferences_u24lambda_u2d48_u24lambda_u2d41.inList(sourceRefColumn, (Iterable)idsToLoad));
            Object $i$f$select22 = forUpdate;
            $i$f$select22 = Intrinsics.areEqual($i$f$select22, true) ? query2.forUpdate() : (Intrinsics.areEqual($i$f$select22, false) ? query2.notForUpdate() : query2);
            boolean $i$f$map = false;
            void $i$a$-select-EntityClass$warmUpLinkedReferences$loaded$2$query$22 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                ResultRow resultRow = (ResultRow)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(TuplesKt.to(it2.get(sourceRefColumn), this.wrapRow((ResultRow)it2)));
            }
            List entitiesWithRefs = (List)destination$iv$iv;
            Object $this$groupBy$iv = entitiesWithRefs;
            boolean $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Pair it3 = (Pair)element$iv$iv;
                boolean bl4 = false;
                key$iv$iv = (EntityID)it3.getFirst();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv3;
                void it4;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv2;
                boolean bl6 = false;
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map3;
                boolean bl7 = false;
                Iterable $this$map$iv2 = (Iterable)it4.getValue();
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it5;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl8 = false;
                    collection.add((Entity)it5.getSecond());
                }
                List list4 = (List)destination$iv$iv3;
                object.put(k, list4);
            }
            Map groupedBySourceId = destination$iv$iv2;
            Iterable $this$forEach$iv = idsToLoad;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                EntityID it6 = (EntityID)element$iv2;
                boolean bl9 = false;
                EntityCacheKt.getEntityCache(transaction2).getOrPutReferrers(it6, sourceRefColumn, new Function0<SizedIterable<? extends T>>(groupedBySourceId, it6){
                    final /* synthetic */ Map<EntityID<?>, List<T>> $groupedBySourceId;
                    final /* synthetic */ EntityID<?> $it;
                    {
                        this.$groupedBySourceId = $groupedBySourceId;
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final SizedIterable<T> invoke() {
                        List<T> list = this.$groupedBySourceId.get(this.$it);
                        return new SizedCollection<T>(list == null ? (Collection)CollectionsKt.emptyList() : (Collection)list);
                    }
                });
            }
            Iterable $this$map$iv3 = entitiesWithRefs;
            boolean $i$f$map3 = false;
            $this$mapValuesTo$iv$iv = $this$map$iv3;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it7;
                Pair list$iv$iv = (Pair)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl10 = false;
                object.add((Entity)it7.getSecond());
            }
            list = (List)destination$iv$iv2;
        }
        List loaded2 = list;
        Iterable $this$flatMap$iv = inCache.values();
        boolean $i$f$flatMap = false;
        idsToLoad = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SizedIterable it8 = (SizedIterable)element$iv$iv;
            boolean bl11 = false;
            Iterable list$iv$iv = CollectionsKt.toList(it8);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        List list5 = loaded2;
        if (list5 == null) {
            list5 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list5);
    }

    public static /* synthetic */ List warmUpLinkedReferences$default(EntityClass entityClass, List list, Table table, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warmUpLinkedReferences");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return entityClass.warmUpLinkedReferences(list, table, bl);
    }

    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> boolean isAssignableTo(@NotNull EntityClass<ID, ? extends T> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        return entityClass.klass.isAssignableFrom(this.klass);
    }
}

