/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.DatabaseConnectionAutoRegistration;
import org.jetbrains.exposed.sql.DatabaseKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 A2\u00020\u0001:\u0001AB-\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u000fH\u0007J\u000e\u00108\u001a\u00020 2\u0006\u00102\u001a\u000203J.\u00109\u001a\u0002H:\"\u0004\b\u0000\u0010:2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002H:0<\u00a2\u0006\u0002\b>H\u0000\u00a2\u0006\u0004\b?\u0010@R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0019\u001a\u0004\b%\u0010\"R\u001b\u0010'\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0019\u001a\u0004\b(\u0010)R$\u0010+\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 @GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010.R\u001b\u0010/\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0019\u001a\u0004\b0\u0010)R\u001b\u00102\u001a\u0002038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0019\u001a\u0004\b4\u00105\u00a8\u0006B"}, d2={"Lorg/jetbrains/exposed/sql/Database;", "", "resolvedVendor", "", "config", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "connector", "Lkotlin/Function0;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function0;)V", "getConfig", "()Lorg/jetbrains/exposed/sql/DatabaseConfig;", "getConnector", "()Lkotlin/jvm/functions/Function0;", "<set-?>", "", "defaultFetchSize", "getDefaultFetchSize", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "dialect", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "getDialect", "()Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect$delegate", "Lkotlin/Lazy;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "supportsAlterTableWithAddColumn", "", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn$delegate", "supportsMultipleResultSets", "getSupportsMultipleResultSets", "supportsMultipleResultSets$delegate", "url", "getUrl", "()Ljava/lang/String;", "url$delegate", "useNestedTransactions", "getUseNestedTransactions", "setUseNestedTransactions", "(Z)V", "vendor", "getVendor", "vendor$delegate", "version", "Ljava/math/BigDecimal;", "getVersion", "()Ljava/math/BigDecimal;", "version$delegate", "size", "isVersionCovers", "metadata", "T", "body", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "metadata$exposed_core", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "exposed-core"})
public final class Database {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String resolvedVendor;
    @NotNull
    private final DatabaseConfig config;
    @NotNull
    private final Function0<ExposedConnection<?>> connector;
    private boolean useNestedTransactions;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy vendor$delegate;
    @NotNull
    private final Lazy dialect$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private Integer defaultFetchSize;
    @NotNull
    private static final ConcurrentHashMap<String, Function0<DatabaseDialect>> dialects = new ConcurrentHashMap();
    @NotNull
    private static final DatabaseConnectionAutoRegistration connectionInstanceImpl;
    @NotNull
    private static final Map<String, String> driverMapping;
    @NotNull
    private static final Map<String, String> dialectMapping;

    private Database(String resolvedVendor, DatabaseConfig config, Function0<? extends ExposedConnection<?>> connector) {
        this.resolvedVendor = resolvedVendor;
        this.config = config;
        this.connector = connector;
        this.useNestedTransactions = this.config.getUseNestedTransactions();
        this.url$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return (String)this.this$0.metadata$exposed_core(url.1.INSTANCE);
            }
        });
        this.vendor$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = Database.access$getResolvedVendor$p(this.this$0);
                if (string == null) {
                    string = (String)this.this$0.metadata$exposed_core(vendor.1.INSTANCE);
                }
                return string;
            }
        });
        this.dialect$delegate = LazyKt.lazy((Function0)new Function0<DatabaseDialect>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseDialect invoke() {
                DatabaseDialect databaseDialect = this.this$0.getConfig().getExplicitDialect();
                if (databaseDialect == null) {
                    ConcurrentHashMap concurrentHashMap = Database.access$getDialects$cp();
                    String string = this.this$0.getVendor().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Function0 function0 = (Function0)concurrentHashMap.get(string);
                    databaseDialect = function0 == null ? null : (DatabaseDialect)function0.invoke();
                    if (databaseDialect == null) {
                        throw new IllegalStateException(("No dialect registered for " + DatabaseKt.getName(this.this$0) + ". URL=" + this.this$0.getUrl()).toString());
                    }
                }
                return databaseDialect;
            }
        });
        this.version$delegate = LazyKt.lazy((Function0)new Function0<BigDecimal>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BigDecimal invoke() {
                return (BigDecimal)this.this$0.metadata$exposed_core(version.1.INSTANCE);
            }
        });
        this.supportsAlterTableWithAddColumn$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)this.this$0.metadata$exposed_core(supportsAlterTableWithAddColumn.1.INSTANCE);
            }
        });
        this.supportsMultipleResultSets$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)this.this$0.metadata$exposed_core(supportsMultipleResultSets.1.INSTANCE);
            }
        });
        this.identifierManager$delegate = LazyKt.lazy((Function0)new Function0<IdentifierManagerApi>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IdentifierManagerApi invoke() {
                return (IdentifierManagerApi)this.this$0.metadata$exposed_core(identifierManager.1.INSTANCE);
            }
        });
        this.defaultFetchSize = this.config.getDefaultFetchSize();
    }

    /* synthetic */ Database(String string, DatabaseConfig databaseConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, databaseConfig, function0);
    }

    @NotNull
    public final DatabaseConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Function0<ExposedConnection<?>> getConnector() {
        return this.connector;
    }

    public final boolean getUseNestedTransactions() {
        return this.useNestedTransactions;
    }

    @Deprecated(message="Use DatabaseConfig to define the useNestedTransactions")
    public final void setUseNestedTransactions(boolean bl) {
        this.useNestedTransactions = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T metadata$exposed_core(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body2) {
        T t2;
        Intrinsics.checkNotNullParameter(body2, "body");
        Transaction transaction2 = TransactionManager.Companion.currentOrNull();
        if (transaction2 == null) {
            T t3;
            try (ExposedConnection<?> connection = this.connector.invoke();){
                t3 = connection.metadata(body2);
            }
            t2 = t3;
        } else {
            t2 = transaction2.getConnection().metadata(body2);
        }
        return t2;
    }

    @NotNull
    public final String getUrl() {
        Lazy lazy = this.url$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getVendor() {
        Lazy lazy = this.vendor$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final DatabaseDialect getDialect() {
        Lazy lazy = this.dialect$delegate;
        return (DatabaseDialect)lazy.getValue();
    }

    @NotNull
    public final BigDecimal getVersion() {
        Lazy lazy = this.version$delegate;
        return (BigDecimal)lazy.getValue();
    }

    public final boolean isVersionCovers(@NotNull BigDecimal version2) {
        Intrinsics.checkNotNullParameter(version2, "version");
        return this.getVersion().compareTo(version2) >= 0;
    }

    public final boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        return (IdentifierManagerApi)lazy.getValue();
    }

    @Nullable
    public final Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Deprecated(message="Use DatabaseConfig to define the defaultFetchSize")
    @NotNull
    public final Database defaultFetchSize(int size) {
        this.defaultFetchSize = size;
        return this;
    }

    public /* synthetic */ Database(String resolvedVendor, DatabaseConfig config, Function0 connector, DefaultConstructorMarker $constructor_marker) {
        this(resolvedVendor, config, connector);
    }

    public static final /* synthetic */ DatabaseConnectionAutoRegistration access$getConnectionInstanceImpl$cp() {
        return connectionInstanceImpl;
    }

    public static final /* synthetic */ String access$getResolvedVendor$p(Database $this) {
        return $this.resolvedVendor;
    }

    static {
        ServiceLoader<DatabaseConnectionAutoRegistration> serviceLoader = ServiceLoader.load(DatabaseConnectionAutoRegistration.class, Database.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(DatabaseConnectionA\u2026::class.java.classLoader)");
        Pair[] pairArray = (Pair[])CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (pairArray == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("Can't load implementation for ", Reflection.getOrCreateKotlinClass(DatabaseConnectionAutoRegistration.class).getSimpleName()).toString());
        }
        connectionInstanceImpl = pairArray;
        pairArray = new Pair[]{TuplesKt.to("jdbc:h2", "org.h2.Driver"), TuplesKt.to("jdbc:postgresql", "org.postgresql.Driver"), TuplesKt.to("jdbc:pgsql", "com.impossibl.postgres.jdbc.PGDriver"), TuplesKt.to("jdbc:mysql", "com.mysql.cj.jdbc.Driver"), TuplesKt.to("jdbc:mariadb", "org.mariadb.jdbc.Driver"), TuplesKt.to("jdbc:oracle", "oracle.jdbc.OracleDriver"), TuplesKt.to("jdbc:sqlite", "org.sqlite.JDBC"), TuplesKt.to("jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver")};
        driverMapping = MapsKt.mutableMapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to("jdbc:h2", "h2"), TuplesKt.to("jdbc:postgresql", "postgresql"), TuplesKt.to("jdbc:pgsql", "pgsql"), TuplesKt.to("jdbc:mysql", "mysql"), TuplesKt.to("jdbc:mariadb", "mariadb"), TuplesKt.to("jdbc:oracle", "oracle"), TuplesKt.to("jdbc:sqlite", "sqlite"), TuplesKt.to("jdbc:sqlserver", "sqlserver")};
        dialectMapping = MapsKt.mutableMapOf(pairArray);
        Companion.registerDialect("h2", Companion.1.INSTANCE);
        Companion.registerDialect("mysql", Companion.2.INSTANCE);
        Companion.registerDialect("postgresql", Companion.3.INSTANCE);
        Companion.registerDialect("pgsql", Companion.4.INSTANCE);
        Companion.registerDialect("sqlite", Companion.5.INSTANCE);
        Companion.registerDialect("oracle", Companion.6.INSTANCE);
        Companion.registerDialect("sqlserver", Companion.7.INSTANCE);
        Companion.registerDialect("mariadb", Companion.8.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014JH\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014H\u0007JF\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001a2\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014Jd\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u00072\b\b\u0002\u0010\u001e\u001a\u00020\u00072\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014JF\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014JV\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u00142\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u001c\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001e\u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/exposed/sql/Database$Companion;", "", "()V", "connectionInstanceImpl", "Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;", "dialectMapping", "", "", "dialects", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Function0;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "driverMapping", "connect", "Lorg/jetbrains/exposed/sql/Database;", "getNewConnection", "Ljava/sql/Connection;", "databaseConfig", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "manager", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "datasource", "Ljavax/sql/ConnectionPoolDataSource;", "setupConnection", "", "Ljavax/sql/DataSource;", "url", "driver", "user", "password", "connectPool", "doConnect", "explicitVendor", "config", "getDefaultIsolationLevel", "", "db", "getDialectName", "getDriver", "registerDialect", "prefix", "dialect", "registerJdbcDriver", "driverClassName", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerDialect(@NotNull String prefix, @NotNull Function0<? extends DatabaseDialect> dialect2) {
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(dialect2, "dialect");
            ((Map)dialects).put(prefix, dialect2);
        }

        public final void registerJdbcDriver(@NotNull String prefix, @NotNull String driverClassName, @NotNull String dialect2) {
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(driverClassName, "driverClassName");
            Intrinsics.checkNotNullParameter(dialect2, "dialect");
            driverMapping.put(prefix, driverClassName);
            dialectMapping.put(prefix, dialect2);
        }

        private final Database doConnect(String explicitVendor, DatabaseConfig config, Function0<? extends Connection> getNewConnection, Function1<? super Connection, Unit> setupConnection, Function1<? super Database, ? extends TransactionManager> manager) {
            Database database;
            DatabaseConfig databaseConfig = config;
            if (databaseConfig == null) {
                databaseConfig = DatabaseConfig.Companion.invoke$default(DatabaseConfig.Companion, null, 1, null);
            }
            Database $this$doConnect_u24lambda_u2d0 = database = new Database(explicitVendor, databaseConfig, new Function0<ExposedConnection<?>>(getNewConnection, setupConnection){
                final /* synthetic */ Function0<Connection> $getNewConnection;
                final /* synthetic */ Function1<Connection, Unit> $setupConnection;
                {
                    this.$getNewConnection = $getNewConnection;
                    this.$setupConnection = $setupConnection;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ExposedConnection<?> invoke() {
                    void $this$invoke_u24lambda_u2d0;
                    Connection connection = this.$getNewConnection.invoke();
                    Function1<Connection, Unit> function1 = this.$setupConnection;
                    Connection connection2 = connection;
                    DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = Database.access$getConnectionInstanceImpl$cp();
                    boolean bl = false;
                    function1.invoke((Connection)$this$invoke_u24lambda_u2d0);
                    return (ExposedConnection)databaseConnectionAutoRegistration.invoke(connection);
                }
            }, null);
            boolean bl = false;
            TransactionManager.Companion.registerManager($this$doConnect_u24lambda_u2d0, manager.invoke($this$doConnect_u24lambda_u2d0));
            return database;
        }

        static /* synthetic */ Database doConnect$default(Companion companion, String string, DatabaseConfig databaseConfig, Function0 function0, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = doConnect.1.INSTANCE;
            }
            if ((n & 0x10) != 0) {
                function12 = doConnect.2.INSTANCE;
            }
            return companion.doConnect(string, databaseConfig, function0, function1, function12);
        }

        @NotNull
        public final Database connect(@NotNull DataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(datasource, "datasource");
            Intrinsics.checkNotNullParameter(setupConnection, "setupConnection");
            Intrinsics.checkNotNullParameter(manager, "manager");
            return this.doConnect(null, databaseConfig, (Function0<? extends Connection>)new Function0<Connection>(datasource){
                final /* synthetic */ DataSource $datasource;
                {
                    this.$datasource = $datasource;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = this.$datasource.getConnection();
                    Intrinsics.checkNotNull(connection);
                    return connection;
                }
            }, setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, DataSource dataSource, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = connect.1.INSTANCE;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                function12 = connect.2.INSTANCE;
            }
            return companion.connect(dataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @Deprecated(message="Use connectPool instead", replaceWith=@ReplaceWith(expression="connectPool(datasource, setupConnection, manager)", imports={}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Database connect(@NotNull ConnectionPoolDataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(datasource, "datasource");
            Intrinsics.checkNotNullParameter(setupConnection, "setupConnection");
            Intrinsics.checkNotNullParameter(manager, "manager");
            return this.doConnect(null, databaseConfig, (Function0<? extends Connection>)new Function0<Connection>(datasource){
                final /* synthetic */ ConnectionPoolDataSource $datasource;
                {
                    this.$datasource = $datasource;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = this.$datasource.getPooledConnection().getConnection();
                    Intrinsics.checkNotNull(connection);
                    return connection;
                }
            }, setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, ConnectionPoolDataSource connectionPoolDataSource, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = connect.4.INSTANCE;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                function12 = connect.5.INSTANCE;
            }
            return companion.connect(connectionPoolDataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @NotNull
        public final Database connectPool(@NotNull ConnectionPoolDataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(datasource, "datasource");
            Intrinsics.checkNotNullParameter(setupConnection, "setupConnection");
            Intrinsics.checkNotNullParameter(manager, "manager");
            return this.doConnect(null, databaseConfig, (Function0<? extends Connection>)new Function0<Connection>(datasource){
                final /* synthetic */ ConnectionPoolDataSource $datasource;
                {
                    this.$datasource = $datasource;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = this.$datasource.getPooledConnection().getConnection();
                    Intrinsics.checkNotNull(connection);
                    return connection;
                }
            }, setupConnection, manager);
        }

        public static /* synthetic */ Database connectPool$default(Companion companion, ConnectionPoolDataSource connectionPoolDataSource, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = connectPool.1.INSTANCE;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                function12 = connectPool.2.INSTANCE;
            }
            return companion.connectPool(connectionPoolDataSource, function1, databaseConfig, function12);
        }

        @NotNull
        public final Database connect(@NotNull Function0<? extends Connection> getNewConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(getNewConnection, "getNewConnection");
            Intrinsics.checkNotNullParameter(manager, "manager");
            return org.jetbrains.exposed.sql.Database$Companion.doConnect$default(this, null, databaseConfig, getNewConnection, null, manager, 8, null);
        }

        public static /* synthetic */ Database connect$default(Companion companion, Function0 function0, DatabaseConfig databaseConfig, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                databaseConfig = null;
            }
            if ((n & 4) != 0) {
                function1 = connect.7.INSTANCE;
            }
            return companion.connect(function0, databaseConfig, function1);
        }

        @NotNull
        public final Database connect(@NotNull String url2, @NotNull String driver, @NotNull String user, @NotNull String password, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(url2, "url");
            Intrinsics.checkNotNullParameter(driver, "driver");
            Intrinsics.checkNotNullParameter(user, "user");
            Intrinsics.checkNotNullParameter(password, "password");
            Intrinsics.checkNotNullParameter(setupConnection, "setupConnection");
            Intrinsics.checkNotNullParameter(manager, "manager");
            Class.forName(driver).newInstance();
            String string = this.getDialectName(url2);
            if (string == null) {
                throw new IllegalStateException(Intrinsics.stringPlus("Can't resolve dialect for connection: ", url2).toString());
            }
            String dialectName = string;
            return this.doConnect(dialectName, databaseConfig, (Function0<? extends Connection>)new Function0<Connection>(url2, user, password){
                final /* synthetic */ String $url;
                final /* synthetic */ String $user;
                final /* synthetic */ String $password;
                {
                    this.$url = $url;
                    this.$user = $user;
                    this.$password = $password;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = DriverManager.getConnection(this.$url, this.$user, this.$password);
                    Intrinsics.checkNotNullExpressionValue(connection, "getConnection(url, user, password)");
                    return connection;
                }
            }, setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, String string, String string2, String string3, String string4, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = companion.getDriver(string);
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            if ((n & 0x10) != 0) {
                function1 = connect.8.INSTANCE;
            }
            if ((n & 0x20) != 0) {
                databaseConfig = null;
            }
            if ((n & 0x40) != 0) {
                function12 = connect.9.INSTANCE;
            }
            return companion.connect(string, string2, string3, string4, function1, databaseConfig, function12);
        }

        public final int getDefaultIsolationLevel(@NotNull Database db) {
            Intrinsics.checkNotNullParameter(db, "db");
            DatabaseDialect databaseDialect = db.getDialect();
            return databaseDialect instanceof SQLiteDialect ? 8 : (databaseDialect instanceof OracleDialect ? 2 : (databaseDialect instanceof PostgreSQLDialect ? 2 : 4));
        }

        private final String getDriver(String url2) {
            String string;
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = driverMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry $dstr$prefix$_u24__u24 = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix = (String)$dstr$prefix$_u24__u24.getKey();
                    if (!StringsKt.startsWith$default(url2, prefix, false, 2, null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            String string2 = string = entry == null ? null : (String)entry.getValue();
            if (string == null) {
                throw new IllegalStateException(Intrinsics.stringPlus("Database driver not found for ", url2).toString());
            }
            return string;
        }

        @Nullable
        public final String getDialectName(@NotNull String url2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(url2, "url");
                Iterable $this$firstOrNull$iv = dialectMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry $dstr$prefix$_u24__u24 = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix = (String)$dstr$prefix$_u24__u24.getKey();
                    if (!StringsKt.startsWith$default(url2, prefix, false, 2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry == null ? null : (String)entry.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

