/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.Case;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "blobType", "booleanToStatementString", "bool", "", "booleanType", "dateTimeType", "integerAutoincType", "longAutoincType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "textType", "uuidToDB", "", "value", "Ljava/util/UUID;", "uuidType", "exposed-core"})
public final class SQLServerDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final SQLServerDataTypeProvider INSTANCE = new SQLServerDataTypeProvider();

    private SQLServerDataTypeProvider() {
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "INT IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "BIGINT IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String blobType() {
        return "VARBINARY(MAX)";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "uniqueidentifier";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "value.toString()");
        return string;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "DATETIME2";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "BIT";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    @NotNull
    public String textType() {
        return "VARCHAR(MAX)";
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                Pair pair;
                boolean $i$f$build;
                Expression.Companion this_$iv;
                if (sortOrder == SortOrder.ASC_NULLS_LAST) {
                    this_$iv = Expression.Companion;
                    $i$f$build = false;
                    SqlExpressionBuilder $this$precessOrderByClause_u24lambda_u2d0 = SqlExpressionBuilder.INSTANCE;
                    boolean bl = false;
                    pair = TuplesKt.to(new Case(null, 1, null).When($this$precessOrderByClause_u24lambda_u2d0.isNull(expression), OpKt.intLiteral(1)).Else((Expression)OpKt.intLiteral(0)), SortOrder.ASC);
                } else {
                    this_$iv = Expression.Companion;
                    $i$f$build = false;
                    SqlExpressionBuilder $this$precessOrderByClause_u24lambda_u2d1 = SqlExpressionBuilder.INSTANCE;
                    boolean bl = false;
                    pair = TuplesKt.to(new Case(null, 1, null).When($this$precessOrderByClause_u24lambda_u2d1.isNull(expression), OpKt.intLiteral(0)).Else((Expression)OpKt.intLiteral(1)), SortOrder.DESC);
                }
                Pair sortOrderClause = pair;
                Object[] objectArray = new Object[]{sortOrderClause.getFirst(), ", "};
                ExpressionKt.append(queryBuilder, objectArray);
                super.precessOrderByClause(queryBuilder, expression, sortOrderClause.getSecond());
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            nArray[SortOrder.ASC.ordinal()] = 1;
            nArray[SortOrder.DESC.ordinal()] = 2;
            nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

