/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0014\u0010\u0012\u001a\u00020\u00042\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "supportsCreateSchema", "", "getSupportsCreateSchema", "()Z", "supportsCreateSequence", "getSupportsCreateSequence", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "createDatabase", "", "name", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "dropDatabase", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "Companion", "exposed-core"})
public class SQLiteDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsCreateSequence;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsCreateSchema;
    @NotNull
    public static final String dialectName = "sqlite";
    @NotNull
    private static final Lazy<Boolean> ENABLE_UPDATE_DELETE_LIMIT$delegate = LazyKt.lazy(Companion.ENABLE_UPDATE_DELETE_LIMIT.2.INSTANCE);

    public SQLiteDialect() {
        super(dialectName, SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return this.supportsCreateSchema;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default(index.getColumns(), null, null, null, 0, null, createIndex.1.INSTANCE, 31, null) + " can't be created in SQLite");
            return "";
        }
        String originalCreateIndex = super.createIndex(Index.copy$default(index, null, false, null, null, 13, null));
        return index.getUnique() ? StringsKt.replace$default(originalCreateIndex, "CREATE INDEX", "CREATE UNIQUE INDEX", false, 4, null) : originalCreateIndex;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        StringBuilder stringBuilder = new StringBuilder().append("ATTACH DATABASE '");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return stringBuilder.append(string).append(".db' AS ").append(DefaultKt.inProperCase(name)).toString();
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("DETACH DATABASE ", DefaultKt.inProperCase(name));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect$Companion;", "", "()V", "ENABLE_UPDATE_DELETE_LIMIT", "", "getENABLE_UPDATE_DELETE_LIMIT", "()Z", "ENABLE_UPDATE_DELETE_LIMIT$delegate", "Lkotlin/Lazy;", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getENABLE_UPDATE_DELETE_LIMIT() {
            Lazy lazy = ENABLE_UPDATE_DELETE_LIMIT$delegate;
            return (Boolean)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

