/*
 * Decompiled with CFR 0.152.
 */
package worldban.worldbanplugin;

import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import worldban.worldbanplugin.WorldBanCommand;

public class WorldBanPlugin
extends JavaPlugin
implements Listener {
    private List<String> worldNames;
    private String kickMessage;

    public void onEnable() {
        this.getLogger().info("World Ban Plugin enabled");
        this.loadConfig();
        this.loadLanguage();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("wb").setExecutor((CommandExecutor)new WorldBanCommand(this));
    }

    public void onDisable() {
        this.getLogger().info("World Ban Plugin disabled");
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.worldNames = config.getStringList("world-names");
        this.kickMessage = config.getString("kick-message", "");
    }

    public void loadLanguage() {
        YamlConfiguration langConfig;
        String langKickMessage;
        this.saveResource("lang.yml", false);
        File langFile = new File(this.getDataFolder(), "lang.yml");
        if (langFile.exists() && (langKickMessage = (langConfig = YamlConfiguration.loadConfiguration((File)langFile)).getString("world-ban.kick-message")) != null && !langKickMessage.isEmpty()) {
            this.kickMessage = langKickMessage;
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && this.worldNames.contains(event.getTo().getWorld().getName())) {
            event.getPlayer().sendMessage(this.kickMessage);
            event.setCancelled(true);
        }
    }
}

