/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.widget.list;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractList<E extends AbstractListEntry<E>>
extends FocusableGui
implements IRenderable {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final List<E> children = new SimpleArrayList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    private double scrollAmount;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;
    private E selected;

    public AbstractList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int itemHeightIn) {
        this.minecraft = mcIn;
        this.width = widthIn;
        this.height = heightIn;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = itemHeightIn;
        this.x0 = 0;
        this.x1 = widthIn;
    }

    public void setRenderSelection(boolean p_setRenderSelection_1_) {
        this.renderSelection = p_setRenderSelection_1_;
    }

    protected void setRenderHeader(boolean p_setRenderHeader_1_, int p_setRenderHeader_2_) {
        this.renderHeader = p_setRenderHeader_1_;
        this.headerHeight = p_setRenderHeader_2_;
        if (!p_setRenderHeader_1_) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E p_setSelected_1_) {
        this.selected = p_setSelected_1_;
    }

    @Nullable
    public E getFocused() {
        return (E)((AbstractListEntry)super.getFocused());
    }

    public final List<E> children() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> p_replaceEntries_1_) {
        this.children.clear();
        this.children.addAll(p_replaceEntries_1_);
    }

    protected E getEntry(int p_getEntry_1_) {
        return (E)((AbstractListEntry)this.children().get(p_getEntry_1_));
    }

    protected int addEntry(E p_addEntry_1_) {
        this.children.add(p_addEntry_1_);
        return this.children.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int p_isSelectedItem_1_) {
        return Objects.equals(this.getSelected(), this.children().get(p_isSelectedItem_1_));
    }

    @Nullable
    protected final E getEntryAtPosition(double p_getEntryAtPosition_1_, double p_getEntryAtPosition_3_) {
        int i = this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2;
        int k = j - i;
        int l = j + i;
        int i1 = MathHelper.func_76128_c((double)(p_getEntryAtPosition_3_ - (double)this.y0)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(p_getEntryAtPosition_1_ < (double)this.getScrollbarPosition() && p_getEntryAtPosition_1_ >= (double)k && p_getEntryAtPosition_1_ <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (AbstractListEntry)this.children().get(j1) : null);
    }

    public void updateSize(int p_updateSize_1_, int p_updateSize_2_, int p_updateSize_3_, int p_updateSize_4_) {
        this.width = p_updateSize_1_;
        this.height = p_updateSize_2_;
        this.y0 = p_updateSize_3_;
        this.y1 = p_updateSize_4_;
        this.x0 = 0;
        this.x1 = p_updateSize_1_;
    }

    public void setLeftPos(int p_setLeftPos_1_) {
        this.x0 = p_setLeftPos_1_;
        this.x1 = p_setLeftPos_1_ + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
    }

    protected void renderHeader(int p_renderHeader_1_, int p_renderHeader_2_, Tessellator p_renderHeader_3_) {
    }

    protected void renderBackground() {
    }

    protected void renderDecorations(int p_renderDecorations_1_, int p_renderDecorations_2_) {
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        int i = this.getScrollbarPosition();
        int j = i + 6;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(this.x0, this.y1, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        bufferbuilder.func_225582_a_(this.x1, this.y1, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        bufferbuilder.func_225582_a_(this.x1, this.y0, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        bufferbuilder.func_225582_a_(this.x0, this.y0, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
        int k = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(k, l, tessellator);
        }
        this.renderList(k, l, p_render_1_, p_render_2_, p_render_3_);
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        int i1 = 4;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(this.x0, this.y0 + 4, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_(this.x1, this.y0 + 4, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_(this.x1, this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_(this.x0, this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(this.x0, this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_(this.x1, this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_(this.x1, this.y1 - 4, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_(this.x0, this.y1 - 4, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        int j1 = this.getMaxScroll();
        if (j1 > 0) {
            int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_(i, this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_(j, this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_(j, this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_(i, this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_(i, l1 + k1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_(j, l1 + k1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_(j, l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_(i, l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_(i, l1 + k1 - 1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_(j - 1, l1 + k1 - 1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_(j - 1, l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_(i, l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        this.renderDecorations(p_render_1_, p_render_2_);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    protected void centerScrollOn(E p_centerScrollOn_1_) {
        this.setScrollAmount(this.children().indexOf(p_centerScrollOn_1_) * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2);
    }

    protected void ensureVisible(E p_ensureVisible_1_) {
        int k;
        int i = this.getRowTop(this.children().indexOf(p_ensureVisible_1_));
        int j = i - this.y0 - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.y1 - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int p_scroll_1_) {
        this.setScrollAmount(this.getScrollAmount() + (double)p_scroll_1_);
        this.yDrag = -2;
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double p_setScrollAmount_1_) {
        this.scrollAmount = MathHelper.func_151237_a((double)p_setScrollAmount_1_, (double)0.0, (double)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        this.scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.getScrollbarPosition() && p_updateScrollingState_1_ < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (!this.isMouseOver(p_mouseClicked_1_, p_mouseClicked_3_)) {
            return false;
        }
        E e = this.getEntryAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
        if (e != null) {
            if (e.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                this.setFocused((IGuiEventListener)e);
                this.setDragging(true);
                return true;
            }
        } else if (p_mouseClicked_5_ == 0) {
            this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.y0) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        return false;
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (p_mouseDragged_5_ == 0 && this.scrolling) {
            if (p_mouseDragged_3_ < (double)this.y0) {
                this.setScrollAmount(0.0);
            } else if (p_mouseDragged_3_ > (double)this.y1) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = this.y1 - this.y0;
                int j = MathHelper.func_76125_a((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + p_mouseDragged_8_ * d1);
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.setScrollAmount(this.getScrollAmount() - p_mouseScrolled_5_ * (double)this.itemHeight / 2.0);
        return true;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 264) {
            this.moveSelection(1);
            return true;
        }
        if (p_keyPressed_1_ == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int p_moveSelection_1_) {
        if (!this.children().isEmpty()) {
            int i = this.children().indexOf(this.getSelected());
            int j = MathHelper.func_76125_a((int)(i + p_moveSelection_1_), (int)0, (int)(this.getItemCount() - 1));
            AbstractListEntry e = (AbstractListEntry)this.children().get(j);
            this.setSelected(e);
            this.ensureVisible(e);
        }
    }

    public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return p_isMouseOver_3_ >= (double)this.y0 && p_isMouseOver_3_ <= (double)this.y1 && p_isMouseOver_1_ >= (double)this.x0 && p_isMouseOver_1_ <= (double)this.x1;
    }

    protected void renderList(int p_renderList_1_, int p_renderList_2_, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        int i = this.getItemCount();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int j = 0; j < i; ++j) {
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l < this.y0 || k > this.y1) continue;
            int i1 = p_renderList_2_ + j * this.itemHeight + this.headerHeight;
            int j1 = this.itemHeight - 4;
            E e = this.getEntry(j);
            int k1 = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(j)) {
                int l1 = this.x0 + this.width / 2 - k1 / 2;
                int i2 = this.x0 + this.width / 2 + k1 / 2;
                RenderSystem.disableTexture();
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_(l1, i1 + j1 + 2, 0.0).func_181675_d();
                bufferbuilder.func_225582_a_(i2, i1 + j1 + 2, 0.0).func_181675_d();
                bufferbuilder.func_225582_a_(i2, i1 - 2, 0.0).func_181675_d();
                bufferbuilder.func_225582_a_(l1, i1 - 2, 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_(l1 + 1, i1 + j1 + 1, 0.0).func_181675_d();
                bufferbuilder.func_225582_a_(i2 - 1, i1 + j1 + 1, 0.0).func_181675_d();
                bufferbuilder.func_225582_a_(i2 - 1, i1 - 1, 0.0).func_181675_d();
                bufferbuilder.func_225582_a_(l1 + 1, i1 - 1, 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.enableTexture();
            }
            int j2 = this.getRowLeft();
            ((AbstractListEntry)e).render(j, k, j2, k1, j1, p_renderList_3_, p_renderList_4_, this.isMouseOver(p_renderList_3_, p_renderList_4_) && Objects.equals(this.getEntryAtPosition(p_renderList_3_, p_renderList_4_), e), p_renderList_5_);
        }
    }

    protected int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    protected int getRowTop(int p_getRowTop_1_) {
        return this.y0 + 4 - (int)this.getScrollAmount() + p_getRowTop_1_ * this.itemHeight + this.headerHeight;
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.getRowTop(p_getRowBottom_1_) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(int p_renderHoleBackground_1_, int p_renderHoleBackground_2_, int p_renderHoleBackground_3_, int p_renderHoleBackground_4_) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(this.x0, p_renderHoleBackground_2_, 0.0).func_225583_a_(0.0f, (float)p_renderHoleBackground_2_ / 32.0f).func_225586_a_(64, 64, 64, p_renderHoleBackground_4_).func_181675_d();
        bufferbuilder.func_225582_a_(this.x0 + this.width, p_renderHoleBackground_2_, 0.0).func_225583_a_((float)this.width / 32.0f, (float)p_renderHoleBackground_2_ / 32.0f).func_225586_a_(64, 64, 64, p_renderHoleBackground_4_).func_181675_d();
        bufferbuilder.func_225582_a_(this.x0 + this.width, p_renderHoleBackground_1_, 0.0).func_225583_a_((float)this.width / 32.0f, (float)p_renderHoleBackground_1_ / 32.0f).func_225586_a_(64, 64, 64, p_renderHoleBackground_3_).func_181675_d();
        bufferbuilder.func_225582_a_(this.x0, p_renderHoleBackground_1_, 0.0).func_225583_a_(0.0f, (float)p_renderHoleBackground_1_ / 32.0f).func_225586_a_(64, 64, 64, p_renderHoleBackground_3_).func_181675_d();
        tessellator.func_78381_a();
    }

    protected E remove(int p_remove_1_) {
        AbstractListEntry e = (AbstractListEntry)this.children.get(p_remove_1_);
        return (E)(this.removeEntry((AbstractListEntry)this.children.get(p_remove_1_)) ? e : null);
    }

    protected boolean removeEntry(E p_removeEntry_1_) {
        boolean flag = this.children.remove(p_removeEntry_1_);
        if (flag && p_removeEntry_1_ == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.y0;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getLeft() {
        return this.x0;
    }

    public int getRight() {
        return this.x1;
    }

    @OnlyIn(value=Dist.CLIENT)
    class SimpleArrayList
    extends java.util.AbstractList<E> {
        private final List<E> field_216871_b = Lists.newArrayList();

        private SimpleArrayList() {
        }

        @Override
        public E get(int p_get_1_) {
            return (AbstractListEntry)this.field_216871_b.get(p_get_1_);
        }

        @Override
        public int size() {
            return this.field_216871_b.size();
        }

        @Override
        public E set(int p_set_1_, E p_set_2_) {
            AbstractListEntry e = (AbstractListEntry)this.field_216871_b.set(p_set_1_, p_set_2_);
            ((AbstractListEntry)p_set_2_).list = AbstractList.this;
            return e;
        }

        @Override
        public void add(int p_add_1_, E p_add_2_) {
            this.field_216871_b.add(p_add_1_, p_add_2_);
            ((AbstractListEntry)p_add_2_).list = AbstractList.this;
        }

        @Override
        public E remove(int p_remove_1_) {
            return (AbstractListEntry)this.field_216871_b.remove(p_remove_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class AbstractListEntry<E extends AbstractListEntry<E>>
    implements IGuiEventListener {
        @Deprecated
        protected AbstractList<E> list;

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
            return Objects.equals(this.list.getEntryAtPosition(p_isMouseOver_1_, p_isMouseOver_3_), this);
        }
    }
}

