/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.widget.list;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindingList
extends AbstractOptionList<Entry> {
    private final ControlsScreen field_148191_k;
    private int field_148188_n;

    public KeyBindingList(ControlsScreen controls, Minecraft mcIn) {
        super(mcIn, controls.width + 45, controls.height, 43, controls.height - 32, 20);
        this.field_148191_k = controls;
        KeyBinding[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        Arrays.sort(akeybinding);
        String s = null;
        for (KeyBinding keybinding : akeybinding) {
            int i;
            String s1 = keybinding.func_151466_e();
            if (!s1.equals(s)) {
                s = s1;
                this.addEntry((AbstractList.AbstractListEntry)((Object)new CategoryEntry(s1)));
            }
            if ((i = mcIn.field_71466_p.func_78256_a(I18n.func_135052_a(keybinding.func_151464_g(), new Object[0]))) > this.field_148188_n) {
                this.field_148188_n = i;
            }
            this.addEntry((AbstractList.AbstractListEntry)((Object)new KeyEntry(keybinding)));
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15 + 20;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends Entry {
        private final KeyBinding field_148282_b;
        private final String field_148283_c;
        private final Button field_148280_d;
        private final Button field_148281_e;

        private KeyEntry(final KeyBinding name) {
            this.field_148282_b = name;
            this.field_148283_c = I18n.func_135052_a(name.func_151464_g(), new Object[0]);
            this.field_148280_d = new Button(0, 0, 95, 20, this.field_148283_c, p_214386_2_ -> {
                ((KeyBindingList)KeyBindingList.this).field_148191_k.field_146491_f = name;
            }){

                protected String getNarrationMessage() {
                    return name.func_197986_j() ? I18n.func_135052_a("narrator.controls.unbound", KeyEntry.this.field_148283_c) : I18n.func_135052_a("narrator.controls.bound", KeyEntry.this.field_148283_c, super.getNarrationMessage());
                }
            };
            this.field_148281_e = new Button(0, 0, 50, 20, I18n.func_135052_a("controls.reset", new Object[0]), p_214387_2_ -> {
                this.field_148282_b.setToDefault();
                KeyBindingList.this.minecraft.field_71474_y.func_198014_a(name, name.func_197977_i());
                KeyBinding.func_74508_b();
            }){

                protected String getNarrationMessage() {
                    return I18n.func_135052_a("narrator.controls.reset", KeyEntry.this.field_148283_c);
                }
            };
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            boolean flag = ((KeyBindingList)KeyBindingList.this).field_148191_k.field_146491_f == this.field_148282_b;
            KeyBindingList.this.minecraft.field_71466_p.func_211126_b(this.field_148283_c, (float)(p_render_3_ + 90 - KeyBindingList.this.field_148188_n), (float)(p_render_2_ + p_render_5_ / 2 - 4), 0xFFFFFF);
            this.field_148281_e.x = p_render_3_ + 190 + 20;
            this.field_148281_e.y = p_render_2_;
            this.field_148281_e.active = !this.field_148282_b.func_197985_l();
            this.field_148281_e.render(p_render_6_, p_render_7_, p_render_9_);
            this.field_148280_d.x = p_render_3_ + 105;
            this.field_148280_d.y = p_render_2_;
            this.field_148280_d.setMessage(this.field_148282_b.func_197978_k());
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.field_148282_b.func_197986_j()) {
                for (KeyBinding keybinding : KeyBindingList.this.minecraft.field_71474_y.field_74324_K) {
                    if (keybinding == this.field_148282_b || !this.field_148282_b.func_197983_b(keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.field_148282_b);
                }
            }
            if (flag) {
                this.field_148280_d.setMessage(TextFormatting.WHITE + "> " + TextFormatting.YELLOW + this.field_148280_d.getMessage() + TextFormatting.WHITE + " <");
            } else if (flag1) {
                this.field_148280_d.setMessage((keyCodeModifierConflict ? TextFormatting.GOLD : TextFormatting.RED) + this.field_148280_d.getMessage());
            }
            this.field_148280_d.render(p_render_6_, p_render_7_, p_render_9_);
        }

        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)this.field_148280_d, (Object)this.field_148281_e);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (this.field_148280_d.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                return true;
            }
            return this.field_148281_e.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            return this.field_148280_d.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_) || this.field_148281_e.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        private final String field_148285_b;
        private final int field_148286_c;

        public CategoryEntry(String name) {
            this.field_148285_b = I18n.func_135052_a(name, new Object[0]);
            this.field_148286_c = KeyBindingList.this.minecraft.field_71466_p.func_78256_a(this.field_148285_b);
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            KeyBindingList.this.minecraft.field_71466_p.func_211126_b(this.field_148285_b, (float)(KeyBindingList.this.minecraft.field_71462_r.width / 2 - this.field_148286_c / 2), (float)(p_render_2_ + p_render_5_ - 9 - 1), 0xFFFFFF);
        }

        public boolean changeFocus(boolean p_changeFocus_1_) {
            return false;
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

