/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryCache {
    private static final Logger field_208324_a = LogManager.getLogger();
    private final Path field_208325_b;
    private final Path field_208326_c;
    private int field_208327_d;
    private final Map<Path, String> field_208328_e = Maps.newHashMap();
    private final Map<Path, String> field_208329_f = Maps.newHashMap();
    private final Set<Path> field_218457_g = Sets.newHashSet();

    public DirectoryCache(Path folder, String fileName) throws IOException {
        this.field_208325_b = folder;
        Path path = folder.resolve(".cache");
        Files.createDirectories(path, new FileAttribute[0]);
        this.field_208326_c = path.resolve(fileName);
        this.func_209398_c().forEach(p_209395_1_ -> {
            String s = this.field_208328_e.put((Path)p_209395_1_, "");
        });
        if (Files.isReadable(this.field_208326_c)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.field_208326_c, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(p_208315_2_ -> {
                int i = p_208315_2_.indexOf(32);
                this.field_208328_e.put(folder.resolve(p_208315_2_.substring(i + 1)), p_208315_2_.substring(0, i));
            });
        }
    }

    public void func_208317_a() throws IOException {
        BufferedWriter writer;
        this.func_209400_b();
        try {
            writer = Files.newBufferedWriter(this.field_208326_c, new OpenOption[0]);
        }
        catch (IOException ioexception) {
            field_208324_a.warn("Unable write cachefile {}: {}", (Object)this.field_208326_c, (Object)ioexception.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.field_208329_f.entrySet().stream().map(p_208319_1_ -> (String)p_208319_1_.getValue() + ' ' + this.field_208325_b.relativize((Path)p_208319_1_.getKey()).toString().replace('\\', '/')).sorted(Comparator.comparing(a -> a.split(" ")[1])).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)writer);
        ((Writer)writer).close();
        field_208324_a.debug("Caching: cache hits: {}, created: {} removed: {}", (Object)this.field_208327_d, (Object)(this.field_208329_f.size() - this.field_208327_d), (Object)this.field_208328_e.size());
    }

    @Nullable
    public String func_208323_a(Path fileIn) {
        return this.field_208328_e.get(fileIn);
    }

    public void func_208316_a(Path fileIn, String hash) {
        this.field_208329_f.put(fileIn, hash);
        if (Objects.equals(this.field_208328_e.remove(fileIn), hash)) {
            ++this.field_208327_d;
        }
    }

    public boolean func_208320_b(Path fileIn) {
        return this.field_208328_e.containsKey(fileIn);
    }

    public void func_218456_c(Path p_218456_1_) {
        this.field_218457_g.add(p_218456_1_);
    }

    private void func_209400_b() throws IOException {
        this.func_209398_c().forEach(p_208322_1_ -> {
            if (this.func_208320_b((Path)p_208322_1_) && !this.field_218457_g.contains(p_208322_1_)) {
                try {
                    Files.delete(p_208322_1_);
                }
                catch (IOException ioexception) {
                    field_208324_a.debug("Unable to delete: {} ({})", p_208322_1_, (Object)ioexception.toString());
                }
            }
        });
    }

    private Stream<Path> func_209398_c() throws IOException {
        return Files.walk(this.field_208325_b, new FileVisitOption[0]).filter(p_209397_1_ -> !Objects.equals(this.field_208326_c, p_209397_1_) && !Files.isDirectory(p_209397_1_, new LinkOption[0]));
    }
}

