/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import org.apache.commons.lang3.tuple.Pair;

public class MooshroomEntity
extends CowEntity
implements IShearable {
    private static final DataParameter<String> field_213449_bz = EntityDataManager.func_187226_a(MooshroomEntity.class, DataSerializers.field_187194_d);
    private Effect field_213450_bA;
    private int field_213447_bB;
    private UUID field_213448_bD;

    public MooshroomEntity(EntityType<? extends MooshroomEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150391_bh ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public static boolean func_223318_c(EntityType<MooshroomEntity> p_223318_0_, IWorld p_223318_1_, SpawnReason p_223318_2_, BlockPos p_223318_3_, Random p_223318_4_) {
        return p_223318_1_.func_180495_p(p_223318_3_.func_177977_b()).func_177230_c() == Blocks.field_150391_bh && p_223318_1_.func_226659_b_(p_223318_3_, 0) > 8;
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        UUID uuid = lightningBolt.func_110124_au();
        if (!uuid.equals(this.field_213448_bD)) {
            this.func_213446_a(this.func_213444_dV() == Type.RED ? Type.BROWN : Type.RED);
            this.field_213448_bD = uuid;
            this.func_184185_a(SoundEvents.field_219658_gv, 2.0f, 1.0f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213449_bz, Type.RED.field_221098_c);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151054_z && !this.func_70631_g_() && !player.field_71075_bZ.field_75098_d) {
            ItemStack itemstack1;
            itemstack.func_190918_g(1);
            boolean flag = false;
            if (this.field_213450_bA != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.field_222115_pz);
                SuspiciousStewItem.func_220037_a((ItemStack)itemstack1, (Effect)this.field_213450_bA, (int)this.field_213447_bB);
                this.field_213450_bA = null;
                this.field_213447_bB = 0;
            } else {
                itemstack1 = new ItemStack(Items.field_151009_A);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            SoundEvent soundevent = flag ? SoundEvents.field_219661_gy : SoundEvents.field_219660_gx;
            this.func_184185_a(soundevent, 1.0f, 1.0f);
            return true;
        }
        if (this.func_213444_dV() == Type.BROWN && itemstack.func_77973_b().func_206844_a(ItemTags.field_219770_E)) {
            if (this.field_213450_bA != null) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() / 2.0f), this.func_226283_e_(0.5), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() / 2.0f), 0.0, this.field_70146_Z.nextFloat() / 5.0f, 0.0);
                }
            } else {
                Pair<Effect, Integer> pair = this.func_213443_j(itemstack);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197620_m, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() / 2.0f), this.func_226283_e_(0.5), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() / 2.0f), 0.0, this.field_70146_Z.nextFloat() / 5.0f, 0.0);
                }
                this.field_213450_bA = (Effect)((Object)pair.getLeft());
                this.field_213447_bB = (Integer)pair.getRight();
                this.func_184185_a(SoundEvents.field_219659_gw, 2.0f, 1.0f);
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.func_213444_dV().field_221098_c);
        if (this.field_213450_bA != null) {
            compound.func_74774_a("EffectId", (byte)Effect.func_188409_a(this.field_213450_bA));
            compound.func_74768_a("EffectDuration", this.field_213447_bB);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_213446_a(Type.func_221097_b(compound.func_74779_i("Type")));
        if (compound.func_150297_b("EffectId", 1)) {
            this.field_213450_bA = Effect.func_188412_a(compound.func_74771_c("EffectId"));
        }
        if (compound.func_150297_b("EffectDuration", 3)) {
            this.field_213447_bB = compound.func_74762_e("EffectDuration");
        }
    }

    private Pair<Effect, Integer> func_213443_j(ItemStack p_213443_1_) {
        FlowerBlock flowerblock = (FlowerBlock)((BlockItem)p_213443_1_.func_77973_b()).func_179223_d();
        return Pair.of((Object)((Object)flowerblock.func_220094_d()), (Object)flowerblock.func_220095_e());
    }

    private void func_213446_a(Type typeIn) {
        this.field_70180_af.func_187227_b(field_213449_bz, typeIn.field_221098_c);
    }

    public Type func_213444_dV() {
        return Type.func_221097_b(this.field_70180_af.func_187225_a(MooshroomEntity.field_213449_bz));
    }

    public MooshroomEntity func_90011_a(AgeableEntity ageable) {
        MooshroomEntity mooshroomentity = EntityType.field_200780_T.func_200721_a(this.field_70170_p);
        mooshroomentity.func_213446_a(this.func_213445_a((MooshroomEntity)ageable));
        return mooshroomentity;
    }

    private Type func_213445_a(MooshroomEntity p_213445_1_) {
        Type mooshroomentity$type1;
        Type mooshroomentity$type = this.func_213444_dV();
        Type mooshroomentity$type2 = mooshroomentity$type == (mooshroomentity$type1 = p_213445_1_.func_213444_dV()) && this.field_70146_Z.nextInt(1024) == 0 ? (mooshroomentity$type == Type.BROWN ? Type.RED : Type.BROWN) : (this.field_70146_Z.nextBoolean() ? mooshroomentity$type : mooshroomentity$type1);
        return mooshroomentity$type2;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            CowEntity cowentity = EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowentity.func_70606_j(this.func_110143_aJ());
            cowentity.field_70761_aq = this.field_70761_aq;
            if (this.func_145818_k_()) {
                cowentity.func_200203_b(this.func_200201_e());
                cowentity.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_217376_c((Entity)cowentity);
            for (int i = 0; i < 5; ++i) {
                ret.add(new ItemStack(this.func_213444_dV().field_221099_d.func_177230_c()));
            }
            this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
        }
        return ret;
    }

    private static /* synthetic */ void lambda$processInteract$0(Hand hand, PlayerEntity p_213442_1_) {
        p_213442_1_.func_213334_d(hand);
    }

    public static enum Type {
        RED("red", Blocks.field_150337_Q.func_176223_P()),
        BROWN("brown", Blocks.field_150338_P.func_176223_P());

        private final String field_221098_c;
        private final BlockState field_221099_d;

        private Type(String nameIn, BlockState renderStateIn) {
            this.field_221098_c = nameIn;
            this.field_221099_d = renderStateIn;
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState func_221093_a() {
            return this.field_221099_d;
        }

        private static Type func_221097_b(String nameIn) {
            for (Type mooshroomentity$type : Type.values()) {
                if (!mooshroomentity$type.field_221098_c.equals(nameIn)) continue;
                return mooshroomentity$type;
            }
            return RED;
        }
    }
}

