/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractArrowEntity
extends Entity
implements IProjectile {
    private static final DataParameter<Byte> field_184554_g = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187203_m);
    private static final DataParameter<Byte> field_213876_as = EntityDataManager.func_187226_a(AbstractArrowEntity.class, DataSerializers.field_187191_a);
    @Nullable
    private BlockState field_195056_av;
    protected boolean field_70254_i;
    protected int field_184552_b;
    public PickupStatus field_70251_a = PickupStatus.DISALLOWED;
    public int field_70249_b;
    public UUID field_70250_c;
    private int field_70252_j;
    private int field_70257_an;
    private double field_70255_ao = 2.0;
    private int field_70256_ap;
    private SoundEvent field_213877_ay = this.func_213867_k();
    private IntOpenHashSet field_213878_az;
    private List<Entity> field_213875_aA;

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected AbstractArrowEntity(EntityType<? extends AbstractArrowEntity> type, LivingEntity shooter, World worldIn) {
        this(type, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), worldIn);
        this.func_212361_a(shooter);
        if (shooter instanceof PlayerEntity) {
            this.field_70251_a = PickupStatus.ALLOWED;
        }
    }

    public void func_213869_a(SoundEvent soundIn) {
        this.field_213877_ay = soundIn;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * AbstractArrowEntity.func_184183_bd()) * d0;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184554_g, (byte)0);
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
        this.field_70180_af.func_187214_a(field_213876_as, (byte)0);
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.field_70122_E ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a(velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)AbstractArrowEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70252_j = 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            this.field_70252_j = 0;
        }
    }

    @Override
    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        boolean flag = this.func_203047_q();
        Vec3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)AbstractArrowEntity.func_213296_b(vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos((Entity)this))).isAir((IBlockReader)((Object)this.field_70170_p), blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)((Object)this.field_70170_p), blockpos)).func_197766_b())) {
            Vec3d vec3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vec3d1)) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            if (this.field_195056_av != blockstate && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.06))) {
                this.field_70254_i = false;
                this.func_213317_d(vec3d.func_216372_d(this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f, this.field_70146_Z.nextFloat() * 0.2f));
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.field_184552_b;
        } else {
            Vec3d vec3d3;
            this.field_184552_b = 0;
            ++this.field_70257_an;
            Vec3d vec3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d2, vec3d3 = vec3d2.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(vec3d2, vec3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_212360_k();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_184549_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0) break;
                raytraceresult = null;
            }
            vec3d = this.func_213322_ci();
            double d3 = vec3d.field_72450_a;
            double d4 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            if (this.func_70241_g()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d3 * (double)i / 4.0, this.func_226278_cu_() + d4 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)AbstractArrowEntity.func_213296_b(vec3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.func_203044_p();
            }
            this.func_213317_d(vec3d.func_186678_a(f2));
            if (!this.func_189652_ae() && !flag) {
                Vec3d vec3d4 = this.func_213322_ci();
                this.func_213293_j(vec3d4.field_72450_a, vec3d4.field_72448_b - (double)0.05f, vec3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    protected void func_225516_i_() {
        ++this.field_70252_j;
        if (this.field_70252_j >= 1200) {
            this.func_70106_y();
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)raytraceResultIn);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockState blockstate;
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            this.field_195056_av = blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a(0.05f);
            this.func_226288_n_(this.func_226277_ct_() - vec3d1.field_72450_a, this.func_226278_cu_() - vec3d1.field_72448_b, this.func_226281_cx_() - vec3d1.field_72449_c);
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            this.func_213872_b((byte)0);
            this.func_213869_a(SoundEvents.field_187731_t);
            this.func_213865_o(false);
            this.func_213870_w();
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, this);
        }
    }

    private void func_213870_w() {
        if (this.field_213875_aA != null) {
            this.field_213875_aA.clear();
        }
        if (this.field_213878_az != null) {
            this.field_213878_az.clear();
        }
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)Math.max((double)f * this.field_70255_ao, 0.0));
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(entity.func_145782_y());
        }
        if (this.func_70241_g()) {
            i += this.field_70146_Z.nextInt(i / 2 + 2);
        }
        if ((entity1 = this.func_212360_k()) == null) {
            damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this);
        } else {
            damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int j = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3d vec3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a(livingentity, entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)entity1, livingentity);
                }
                this.func_184548_a(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(6, 0.0f));
                }
                if (!entity.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(livingentity);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entity1;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, this.field_213875_aA, this.field_213875_aA.size());
                    } else if (!entity.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, Arrays.asList(entity), 0);
                    }
                }
            }
            this.func_184185_a(this.field_213877_ay, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_223308_g(j);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_187731_t;
    }

    protected final SoundEvent func_203050_i() {
        return this.field_213877_ay;
    }

    protected void func_184548_a(LivingEntity living) {
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d startVec, Vec3d endVec) {
        return ProjectileHelper.func_221271_a(this.field_70170_p, this, startVec, endVec, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !(p_213871_1_.func_175149_v() || !p_213871_1_.func_70089_S() || !p_213871_1_.func_70067_L() || p_213871_1_ == this.func_212360_k() && this.field_70257_an < 5 || this.field_213878_az != null && this.field_213878_az.contains(p_213871_1_.func_145782_y())));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("life", (short)this.field_70252_j);
        if (this.field_195056_av != null) {
            compound.func_218657_a("inBlockState", NBTUtil.func_190009_a((BlockState)this.field_195056_av));
        }
        compound.func_74774_a("shake", (byte)this.field_70249_b);
        compound.func_74757_a("inGround", this.field_70254_i);
        compound.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        compound.func_74780_a("damage", this.field_70255_ao);
        compound.func_74757_a("crit", this.func_70241_g());
        compound.func_74774_a("PierceLevel", this.func_213874_s());
        if (this.field_70250_c != null) {
            compound.func_186854_a("OwnerUUID", this.field_70250_c);
        }
        compound.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c(this.field_213877_ay).toString());
        compound.func_74757_a("ShotFromCrossbow", this.func_213873_r());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.field_70252_j = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.field_195056_av = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.field_70249_b = compound.func_74771_c("shake") & 0xFF;
        this.field_70254_i = compound.func_74767_n("inGround");
        if (compound.func_150297_b("damage", 99)) {
            this.field_70255_ao = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.field_70251_a = PickupStatus.func_188795_a(compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.field_70251_a = compound.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.func_70243_d(compound.func_74767_n("crit"));
        this.func_213872_b(compound.func_74771_c("PierceLevel"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.field_70250_c = compound.func_186857_a("OwnerUUID");
        }
        if (compound.func_150297_b("SoundEvent", 8)) {
            this.field_213877_ay = Registry.field_212633_v.func_218349_b(new ResourceLocation(compound.func_74779_i("SoundEvent"))).orElse(this.func_213867_k());
        }
        this.func_213865_o(compound.func_74767_n("ShotFromCrossbow"));
    }

    public void func_212361_a(@Nullable Entity entityIn) {
        UUID uUID = this.field_70250_c = entityIn == null ? null : entityIn.func_110124_au();
        if (entityIn instanceof PlayerEntity) {
            this.field_70251_a = ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    @Nullable
    public Entity func_212360_k() {
        return this.field_70250_c != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.field_70250_c) : null;
    }

    @Override
    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == PickupStatus.ALLOWED || this.field_70251_a == PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_212360_k().func_110124_au() == entityIn.func_110124_au();
            if (this.field_70251_a == PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a(this, 1);
                this.func_70106_y();
            }
        }
    }

    protected abstract ItemStack func_184550_j();

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70239_b(double damageIn) {
        this.field_70255_ao = damageIn;
    }

    public double func_70242_d() {
        return this.field_70255_ao;
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.field_70256_ap = knockbackStrengthIn;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    public void func_70243_d(boolean critical) {
        this.func_203049_a(1, critical);
    }

    public void func_213872_b(byte level) {
        this.field_70180_af.func_187227_b(field_213876_as, level);
    }

    private void func_203049_a(int p_203049_1_, boolean p_203049_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        if (p_203049_2_) {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(b0 | p_203049_1_));
        } else {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(b0 & ~p_203049_1_));
        }
    }

    public boolean func_70241_g() {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        return (b0 & 1) != 0;
    }

    public boolean func_213873_r() {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        return (b0 & 4) != 0;
    }

    public byte func_213874_s() {
        return this.field_70180_af.func_187225_a(field_213876_as);
    }

    public void func_190547_a(LivingEntity p_190547_1_, float p_190547_2_) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_185309_u, p_190547_1_);
        int j = EnchantmentHelper.func_185284_a(Enchantments.field_185310_v, p_190547_1_);
        this.func_70239_b((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.func_70239_b(this.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a(Enchantments.field_185311_w, p_190547_1_) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float func_203044_p() {
        return 0.6f;
    }

    public void func_203045_n(boolean noClipIn) {
        this.field_70145_X = noClipIn;
        this.func_203049_a(2, noClipIn);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return (this.field_70180_af.func_187225_a(field_184554_g) & 2) != 0;
    }

    public void func_213865_o(boolean fromCrossbow) {
        this.func_203049_a(4, fromCrossbow);
    }

    @Override
    public IPacket<?> func_213297_N() {
        Entity entity = this.func_212360_k();
        return new SSpawnObjectPacket((Entity)this, entity == null ? 0 : entity.func_145782_y());
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus func_188795_a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

