/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SCommandListPacket
implements IPacket<IClientPlayNetHandler> {
    private RootCommandNode<ISuggestionProvider> field_197697_a;

    public SCommandListPacket() {
    }

    public SCommandListPacket(RootCommandNode<ISuggestionProvider> rootIn) {
        this.field_197697_a = rootIn;
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        Entry[] ascommandlistpacket$entry = new Entry[buf.func_150792_a()];
        ArrayDeque<Entry> deque = new ArrayDeque<Entry>(ascommandlistpacket$entry.length);
        for (int i = 0; i < ascommandlistpacket$entry.length; ++i) {
            ascommandlistpacket$entry[i] = this.func_197692_c(buf);
            deque.add(ascommandlistpacket$entry[i]);
        }
        while (!deque.isEmpty()) {
            boolean flag = false;
            Iterator iterator = deque.iterator();
            while (iterator.hasNext()) {
                Entry scommandlistpacket$entry = (Entry)iterator.next();
                if (!scommandlistpacket$entry.func_197723_a(ascommandlistpacket$entry)) continue;
                iterator.remove();
                flag = true;
            }
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
        this.field_197697_a = (RootCommandNode)ascommandlistpacket$entry[buf.func_150792_a()].field_197730_e;
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        HashMap map = Maps.newHashMap();
        ArrayDeque<Object> deque = new ArrayDeque<Object>();
        deque.add(this.field_197697_a);
        while (!deque.isEmpty()) {
            CommandNode commandnode = (CommandNode)deque.pollFirst();
            if (map.containsKey(commandnode)) continue;
            int i = map.size();
            map.put(commandnode, i);
            deque.addAll(commandnode.getChildren());
            if (commandnode.getRedirect() == null) continue;
            deque.add(commandnode.getRedirect());
        }
        CommandNode[] commandnode2 = new CommandNode[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            commandnode2[((Integer)entry.getValue()).intValue()] = (CommandNode)entry.getKey();
        }
        buf.func_150787_b(commandnode2.length);
        for (CommandNode commandnode1 : commandnode2) {
            this.func_197696_a(buf, (CommandNode<ISuggestionProvider>)commandnode1, map);
        }
        buf.func_150787_b((Integer)map.get(this.field_197697_a));
    }

    private Entry func_197692_c(PacketBuffer buf) {
        byte b0 = buf.readByte();
        int[] aint = buf.func_186863_b();
        int i = (b0 & 8) != 0 ? buf.func_150792_a() : 0;
        ArgumentBuilder<ISuggestionProvider, ?> argumentbuilder = this.func_197695_a(buf, b0);
        return new Entry(argumentbuilder, b0, i, aint);
    }

    @Nullable
    private ArgumentBuilder<ISuggestionProvider, ?> func_197695_a(PacketBuffer buf, byte flags) {
        int i = flags & 3;
        if (i == 2) {
            String s = buf.func_150789_c(Short.MAX_VALUE);
            ArgumentType argumenttype = ArgumentTypes.func_197486_a((PacketBuffer)buf);
            if (argumenttype == null) {
                if ((flags & 0x10) != 0) {
                    buf.func_192575_l();
                }
                return null;
            }
            RequiredArgumentBuilder requiredargumentbuilder = RequiredArgumentBuilder.argument((String)s, (ArgumentType)argumenttype);
            if ((flags & 0x10) != 0) {
                requiredargumentbuilder.suggests(SuggestionProviders.func_197498_a((ResourceLocation)buf.func_192575_l()));
            }
            return requiredargumentbuilder;
        }
        return i == 1 ? LiteralArgumentBuilder.literal((String)buf.func_150789_c(Short.MAX_VALUE)) : null;
    }

    private void func_197696_a(PacketBuffer buf, CommandNode<ISuggestionProvider> node, Map<CommandNode<ISuggestionProvider>, Integer> nodeIds) {
        int b0 = 0;
        if (node.getRedirect() != null) {
            b0 = (byte)(b0 | 8);
        }
        if (node.getCommand() != null) {
            b0 = (byte)(b0 | 4);
        }
        if (node instanceof RootCommandNode) {
            b0 = (byte)(b0 | 0);
        } else if (node instanceof ArgumentCommandNode) {
            b0 = (byte)(b0 | 2);
            if (((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                b0 = (byte)(b0 | 0x10);
            }
        } else {
            if (!(node instanceof LiteralCommandNode)) {
                throw new UnsupportedOperationException("Unknown node type " + node);
            }
            b0 = (byte)(b0 | 1);
        }
        buf.writeByte(b0);
        buf.func_150787_b(node.getChildren().size());
        for (CommandNode commandnode : node.getChildren()) {
            buf.func_150787_b(nodeIds.get(commandnode));
        }
        if (node.getRedirect() != null) {
            buf.func_150787_b(nodeIds.get(node.getRedirect()));
        }
        if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)node;
            buf.func_180714_a(argumentcommandnode.getName());
            ArgumentTypes.func_197484_a((PacketBuffer)buf, (ArgumentType)argumentcommandnode.getType());
            if (argumentcommandnode.getCustomSuggestions() != null) {
                buf.func_192572_a(SuggestionProviders.func_197497_a((SuggestionProvider)argumentcommandnode.getCustomSuggestions()));
            }
        } else if (node instanceof LiteralCommandNode) {
            buf.func_180714_a(((LiteralCommandNode)node).getLiteral());
        }
    }

    public void func_148833_a(IClientPlayNetHandler handler) {
        handler.func_195511_a(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RootCommandNode<ISuggestionProvider> func_197693_a() {
        return this.field_197697_a;
    }

    static class Entry {
        @Nullable
        private final ArgumentBuilder<ISuggestionProvider, ?> field_197726_a;
        private final byte field_197727_b;
        private final int field_197728_c;
        private final int[] field_197729_d;
        private CommandNode<ISuggestionProvider> field_197730_e;

        private Entry(@Nullable ArgumentBuilder<ISuggestionProvider, ?> argBuilderIn, byte flagsIn, int redirectTargetIn, int[] childrenIn) {
            this.field_197726_a = argBuilderIn;
            this.field_197727_b = flagsIn;
            this.field_197728_c = redirectTargetIn;
            this.field_197729_d = childrenIn;
        }

        public boolean func_197723_a(Entry[] nodeArray) {
            if (this.field_197730_e == null) {
                if (this.field_197726_a == null) {
                    this.field_197730_e = new RootCommandNode();
                } else {
                    if ((this.field_197727_b & 8) != 0) {
                        if (nodeArray[this.field_197728_c].field_197730_e == null) {
                            return false;
                        }
                        this.field_197726_a.redirect(nodeArray[this.field_197728_c].field_197730_e);
                    }
                    if ((this.field_197727_b & 4) != 0) {
                        this.field_197726_a.executes(p_197724_0_ -> 0);
                    }
                    this.field_197730_e = this.field_197726_a.build();
                }
            }
            for (int i : this.field_197729_d) {
                if (nodeArray[i].field_197730_e != null) continue;
                return false;
            }
            for (int j : this.field_197729_d) {
                CommandNode<ISuggestionProvider> commandnode = nodeArray[j].field_197730_e;
                if (commandnode instanceof RootCommandNode) continue;
                this.field_197730_e.addChild(commandnode);
            }
            return true;
        }
    }
}

