/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public abstract class NoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_222557_0_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_222557_0_[i * 24 * 24 + j * 24 + k] = (float)NoiseChunkGenerator.func_222554_b(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final BlockState field_222562_i = Blocks.field_150350_a.func_176223_P();
    private final int field_222563_j;
    private final int field_222564_k;
    private final int field_222565_l;
    private final int field_222566_m;
    private final int field_222567_n;
    protected final SharedSeedRandom field_222558_e;
    private final OctavesNoiseGenerator field_222568_o;
    private final OctavesNoiseGenerator field_222569_p;
    private final OctavesNoiseGenerator field_222570_q;
    private final INoiseGenerator field_222571_r;
    protected final BlockState field_222559_f;
    protected final BlockState field_222560_g;

    public NoiseChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, int horizontalNoiseGranularityIn, int verticalNoiseGranularityIn, int p_i49931_5_, T settingsIn, boolean usePerlin) {
        super(worldIn, biomeProviderIn, settingsIn);
        this.field_222563_j = verticalNoiseGranularityIn;
        this.field_222564_k = horizontalNoiseGranularityIn;
        this.field_222559_f = settingsIn.func_205532_l();
        this.field_222560_g = settingsIn.func_205533_m();
        this.field_222565_l = 16 / this.field_222564_k;
        this.field_222566_m = p_i49931_5_ / this.field_222563_j;
        this.field_222567_n = 16 / this.field_222564_k;
        this.field_222558_e = new SharedSeedRandom(this.field_222541_b);
        this.field_222568_o = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
        this.field_222569_p = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
        this.field_222570_q = new OctavesNoiseGenerator(this.field_222558_e, 7, 0);
        this.field_222571_r = usePerlin ? new PerlinNoiseGenerator(this.field_222558_e, 3, 0) : new OctavesNoiseGenerator(this.field_222558_e, 3, 0);
    }

    private double func_222552_a(int p_222552_1_, int p_222552_2_, int p_222552_3_, double p_222552_4_, double p_222552_6_, double p_222552_8_, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < 16; ++i) {
            ImprovedNoiseGenerator improvednoisegenerator2;
            ImprovedNoiseGenerator improvednoisegenerator1;
            double d4 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_1_ * p_222552_4_ * d3));
            double d5 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_2_ * p_222552_6_ * d3));
            double d6 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_3_ * p_222552_4_ * d3));
            double d7 = p_222552_6_ * d3;
            ImprovedNoiseGenerator improvednoisegenerator = this.field_222568_o.func_215463_a(i);
            if (improvednoisegenerator != null) {
                d0 += improvednoisegenerator.func_215456_a(d4, d5, d6, d7, (double)p_222552_2_ * d7) / d3;
            }
            if ((improvednoisegenerator1 = this.field_222569_p.func_215463_a(i)) != null) {
                d1 += improvednoisegenerator1.func_215456_a(d4, d5, d6, d7, (double)p_222552_2_ * d7) / d3;
            }
            if (i < 8 && (improvednoisegenerator2 = this.field_222570_q.func_215463_a(i)) != null) {
                d2 += improvednoisegenerator2.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_1_ * p_222552_8_ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_2_ * p_222552_10_ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_3_ * p_222552_8_ * d3)), p_222552_10_ * d3, (double)p_222552_2_ * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((d2 / 10.0 + 1.0) / 2.0));
    }

    protected double[] func_222547_b(int p_222547_1_, int p_222547_2_) {
        double[] adouble = new double[this.field_222566_m + 1];
        this.func_222548_a(adouble, p_222547_1_, p_222547_2_);
        return adouble;
    }

    protected void func_222546_a(double[] noiseColumn, int noiseX, int noiseZ, double p_222546_4_, double p_222546_6_, double p_222546_8_, double p_222546_10_, int p_222546_12_, int p_222546_13_) {
        double[] adouble = this.func_222549_a(noiseX, noiseZ);
        double d0 = adouble[0];
        double d1 = adouble[1];
        double d2 = this.func_222551_g();
        double d3 = this.func_222553_h();
        for (int i = 0; i < this.func_222550_i(); ++i) {
            double d4 = this.func_222552_a(noiseX, i, noiseZ, p_222546_4_, p_222546_6_, p_222546_8_, p_222546_10_);
            d4 -= this.func_222545_a(d0, d1, i);
            if ((double)i > d2) {
                d4 = MathHelper.func_151238_b((double)d4, (double)p_222546_13_, (double)(((double)i - d2) / (double)p_222546_12_));
            } else if ((double)i < d3) {
                d4 = MathHelper.func_151238_b((double)d4, (double)-30.0, (double)((d3 - (double)i) / (d3 - 1.0)));
            }
            noiseColumn[i] = d4;
        }
    }

    protected abstract double[] func_222549_a(int var1, int var2);

    protected abstract double func_222545_a(double var1, double var3, int var5);

    protected double func_222551_g() {
        return this.func_222550_i() - 4;
    }

    protected double func_222553_h() {
        return 0.0;
    }

    @Override
    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
        int i = Math.floorDiv(p_222529_1_, this.field_222564_k);
        int j = Math.floorDiv(p_222529_2_, this.field_222564_k);
        int k = Math.floorMod(p_222529_1_, this.field_222564_k);
        int l = Math.floorMod(p_222529_2_, this.field_222564_k);
        double d0 = (double)k / (double)this.field_222564_k;
        double d1 = (double)l / (double)this.field_222564_k;
        double[][] adouble = new double[][]{this.func_222547_b(i, j), this.func_222547_b(i, j + 1), this.func_222547_b(i + 1, j), this.func_222547_b(i + 1, j + 1)};
        int i1 = this.func_222530_f();
        for (int j1 = this.field_222566_m - 1; j1 >= 0; --j1) {
            double d2 = adouble[0][j1];
            double d3 = adouble[1][j1];
            double d4 = adouble[2][j1];
            double d5 = adouble[3][j1];
            double d6 = adouble[0][j1 + 1];
            double d7 = adouble[1][j1 + 1];
            double d8 = adouble[2][j1 + 1];
            double d9 = adouble[3][j1 + 1];
            for (int k1 = this.field_222563_j - 1; k1 >= 0; --k1) {
                double d10 = (double)k1 / (double)this.field_222563_j;
                double d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int l1 = j1 * this.field_222563_j + k1;
                if (!(d11 > 0.0) && l1 >= i1) continue;
                BlockState blockstate = d11 > 0.0 ? this.field_222559_f : this.field_222560_g;
                if (!heightmapType.func_222684_d().test(blockstate)) continue;
                return l1 + 1;
            }
        }
        return 0;
    }

    protected abstract void func_222548_a(double[] var1, int var2, int var3);

    public int func_222550_i() {
        return this.field_222566_m + 1;
    }

    @Override
    public void func_225551_a_(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
        ChunkPos chunkpos = p_225551_2_.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = p_225551_2_.func_76632_l();
        int k = chunkpos1.func_180334_c();
        int l = chunkpos1.func_180333_d();
        double d0 = 0.0625;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = k + i1;
                int l1 = l + j1;
                int i2 = p_225551_2_.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.field_222571_r.func_215460_a((double)k1 * 0.0625, (double)l1 * 0.0625, 0.0625, (double)i1 * 0.0625) * 15.0;
                p_225551_1_.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(k + i1, i2, l + j1)).func_206854_a((Random)sharedseedrandom, p_225551_2_, k1, l1, i2, d1, this.func_201496_a_().func_205532_l(), this.func_201496_a_().func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
            }
        }
        this.func_222555_a(p_225551_2_, (Random)sharedseedrandom);
    }

    protected void func_222555_a(IChunk chunkIn, Random rand) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        Object t = this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    @Override
    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        int i = this.func_222530_f();
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        for (Structure<?> structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        objectlist.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= l - 12 || l1 <= i1 - 12 || k1 >= l + 15 + 12 || l1 >= i1 + 15 + 12) continue;
                        objectlist1.add((Object)jigsawjunction);
                    }
                }
            }
        }
        double[][][] adouble = new double[2][this.field_222567_n + 1][this.field_222566_m + 1];
        for (int j5 = 0; j5 < this.field_222567_n + 1; ++j5) {
            adouble[0][j5] = new double[this.field_222566_m + 1];
            this.func_222548_a(adouble[0][j5], j * this.field_222565_l, k * this.field_222567_n + j5);
            adouble[1][j5] = new double[this.field_222566_m + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunkIn;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        for (int k5 = 0; k5 < this.field_222565_l; ++k5) {
            for (int l5 = 0; l5 < this.field_222567_n + 1; ++l5) {
                this.func_222548_a(adouble[1][l5], j * this.field_222565_l + k5 + 1, k * this.field_222567_n + l5);
            }
            for (int i6 = 0; i6 < this.field_222567_n; ++i6) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int j6 = this.field_222566_m - 1; j6 >= 0; --j6) {
                    double d16 = adouble[0][i6][j6];
                    double d17 = adouble[0][i6 + 1][j6];
                    double d18 = adouble[1][i6][j6];
                    double d0 = adouble[1][i6 + 1][j6];
                    double d1 = adouble[0][i6][j6 + 1];
                    double d2 = adouble[0][i6 + 1][j6 + 1];
                    double d3 = adouble[1][i6][j6 + 1];
                    double d4 = adouble[1][i6 + 1][j6 + 1];
                    for (int i2 = this.field_222563_j - 1; i2 >= 0; --i2) {
                        int j2 = j6 * this.field_222563_j + i2;
                        int k2 = j2 & 0xF;
                        int l2 = j2 >> 4;
                        if (chunksection.func_222632_g() >> 4 != l2) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(l2);
                            chunksection.func_222635_a();
                        }
                        double d5 = (double)i2 / (double)this.field_222563_j;
                        double d6 = MathHelper.func_219803_d((double)d5, (double)d16, (double)d1);
                        double d7 = MathHelper.func_219803_d((double)d5, (double)d18, (double)d3);
                        double d8 = MathHelper.func_219803_d((double)d5, (double)d17, (double)d2);
                        double d9 = MathHelper.func_219803_d((double)d5, (double)d0, (double)d4);
                        for (int i3 = 0; i3 < this.field_222564_k; ++i3) {
                            int j3 = l + k5 * this.field_222564_k + i3;
                            int k3 = j3 & 0xF;
                            double d10 = (double)i3 / (double)this.field_222564_k;
                            double d11 = MathHelper.func_219803_d((double)d10, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)d10, (double)d8, (double)d9);
                            for (int l3 = 0; l3 < this.field_222564_k; ++l3) {
                                int l4;
                                int k4;
                                int i4 = i1 + i6 * this.field_222564_k + l3;
                                int j4 = i4 & 0xF;
                                double d13 = (double)l3 / (double)this.field_222564_k;
                                double d14 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                                double d15 = MathHelper.func_151237_a((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                d15 = d15 / 2.0 - d15 * d15 * d15 / 24.0;
                                while (objectlistiterator.hasNext()) {
                                    AbstractVillagePiece abstractvillagepiece1 = (AbstractVillagePiece)objectlistiterator.next();
                                    MutableBoundingBox mutableboundingbox = abstractvillagepiece1.func_74874_b();
                                    k4 = Math.max(0, Math.max(mutableboundingbox.field_78897_a - j3, j3 - mutableboundingbox.field_78893_d));
                                    l4 = j2 - (mutableboundingbox.field_78895_b + abstractvillagepiece1.func_214830_d());
                                    int i5 = Math.max(0, Math.max(mutableboundingbox.field_78896_c - i4, i4 - mutableboundingbox.field_78892_f));
                                    d15 += NoiseChunkGenerator.func_222556_a(k4, l4, i5) * 0.8;
                                }
                                objectlistiterator.back(objectlist.size());
                                while (objectlistiterator1.hasNext()) {
                                    JigsawJunction jigsawjunction1 = (JigsawJunction)objectlistiterator1.next();
                                    int k6 = j3 - jigsawjunction1.func_214895_a();
                                    k4 = j2 - jigsawjunction1.func_214896_b();
                                    l4 = i4 - jigsawjunction1.func_214893_c();
                                    d15 += NoiseChunkGenerator.func_222556_a(k6, k4, l4) * 0.4;
                                }
                                objectlistiterator1.back(objectlist1.size());
                                BlockState blockstate = d15 > 0.0 ? this.field_222559_f : (j2 < i ? this.field_222560_g : field_222562_i);
                                if (blockstate == field_222562_i) continue;
                                blockpos$mutable.func_181079_c(j3, j2, i4);
                                if (blockstate.getLightValue(chunkprimer, (BlockPos)blockpos$mutable) != 0) {
                                    chunkprimer.func_201637_h((BlockPos)blockpos$mutable);
                                }
                                chunksection.func_177484_a(k3, k2, j4, blockstate, false);
                                heightmap.func_202270_a(k3, j2, j4, blockstate);
                                heightmap1.func_202270_a(k3, j2, j4, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = adouble[0];
            adouble[0] = adouble[1];
            adouble[1] = adouble1;
        }
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }
}

