/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.AddMushroomIslandLayer;
import net.minecraft.world.gen.layer.AddSnowLayer;
import net.minecraft.world.gen.layer.DeepOceanLayer;
import net.minecraft.world.gen.layer.EdgeLayer;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.MixOceansLayer;
import net.minecraft.world.gen.layer.MixRiverLayer;
import net.minecraft.world.gen.layer.OceanLayer;
import net.minecraft.world.gen.layer.RareBiomeLayer;
import net.minecraft.world.gen.layer.RemoveTooMuchOceanLayer;
import net.minecraft.world.gen.layer.RiverLayer;
import net.minecraft.world.gen.layer.ShoreLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.eventbus.api.Event;

public class LayerUtil {
    protected static final int field_203632_a = Registry.field_212624_m.func_148757_b(Biomes.field_203614_T);
    protected static final int field_203633_b = Registry.field_212624_m.func_148757_b(Biomes.field_203615_U);
    protected static final int field_202832_c = Registry.field_212624_m.func_148757_b(Biomes.field_76771_b);
    protected static final int field_203634_d = Registry.field_212624_m.func_148757_b(Biomes.field_203616_V);
    protected static final int field_202831_b = Registry.field_212624_m.func_148757_b(Biomes.field_76776_l);
    protected static final int field_203635_f = Registry.field_212624_m.func_148757_b(Biomes.field_203617_W);
    protected static final int field_203636_g = Registry.field_212624_m.func_148757_b(Biomes.field_203618_X);
    protected static final int field_202830_a = Registry.field_212624_m.func_148757_b(Biomes.field_150575_M);
    protected static final int field_203637_i = Registry.field_212624_m.func_148757_b(Biomes.field_203619_Y);
    protected static final int field_203638_j = Registry.field_212624_m.func_148757_b(Biomes.field_203620_Z);

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> func_202829_a(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> func_227475_a_(WorldType p_227475_0_, OverworldGenSettings p_227475_1_, LongFunction<C> p_227475_2_) {
        IAreaFactory<T> iareafactory = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)p_227475_2_.apply(1L));
        iareafactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2000L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2001L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(50L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(70L), (IAreaFactory)iareafactory);
        iareafactory = RemoveTooMuchOceanLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2L), (IAreaFactory)iareafactory);
        IAreaFactory<T> iareafactory1 = OceanLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)p_227475_2_.apply(2L));
        iareafactory1 = LayerUtil.func_202829_a(2001L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory1, 6, p_227475_2_);
        iareafactory = AddSnowLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(3L), (IAreaFactory)iareafactory);
        iareafactory = EdgeLayer.CoolWarm.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = EdgeLayer.HeatIce.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = EdgeLayer.Special.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(3L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2002L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(2003L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(4L), (IAreaFactory)iareafactory);
        iareafactory = AddMushroomIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(5L), (IAreaFactory)iareafactory);
        iareafactory = DeepOceanLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(4L), (IAreaFactory)iareafactory);
        iareafactory = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory, 0, p_227475_2_);
        int i = p_227475_0_ == WorldType.field_77135_d ? 6 : p_227475_1_.func_202200_j();
        i = LayerUtil.getModdedBiomeSize(p_227475_0_, i);
        int j = p_227475_1_.func_202198_k();
        IAreaFactory lvt_7_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory, 0, p_227475_2_);
        lvt_7_1_ = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(100L), lvt_7_1_);
        IAreaFactory lvt_8_1_ = p_227475_0_.getBiomeLayer(iareafactory, p_227475_1_, p_227475_2_);
        IAreaFactory<T> lvt_9_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, p_227475_2_);
        lvt_8_1_ = HillsLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)p_227475_2_.apply(1000L), lvt_8_1_, lvt_9_1_);
        lvt_7_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, p_227475_2_);
        lvt_7_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, j, p_227475_2_);
        lvt_7_1_ = RiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1L), lvt_7_1_);
        lvt_7_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1000L), lvt_7_1_);
        lvt_8_1_ = RareBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1001L), lvt_8_1_);
        for (int k = 0; k < i; ++k) {
            lvt_8_1_ = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1000 + k), lvt_8_1_);
            if (k == 0) {
                lvt_8_1_ = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(3L), lvt_8_1_);
            }
            if (k != 1 && i != 1) continue;
            lvt_8_1_ = ShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1000L), lvt_8_1_);
        }
        lvt_8_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)p_227475_2_.apply(1000L), lvt_8_1_);
        lvt_8_1_ = MixRiverLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)p_227475_2_.apply(100L), lvt_8_1_, lvt_7_1_);
        lvt_8_1_ = MixOceansLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)p_227475_2_.apply(100L), lvt_8_1_, iareafactory1);
        return lvt_8_1_;
    }

    public static Layer func_227474_a_(long p_227474_0_, WorldType p_227474_2_, OverworldGenSettings p_227474_3_) {
        int i = 25;
        IAreaFactory iareafactory = LayerUtil.func_227475_a_(p_227474_2_, p_227474_3_, p_227473_2_ -> new LazyAreaLayerContext(25, p_227474_0_, p_227473_2_));
        return new Layer(iareafactory);
    }

    public static boolean func_202826_a(int p_202826_0_, int p_202826_1_) {
        if (p_202826_0_ == p_202826_1_) {
            return true;
        }
        Biome biome = (Biome)((Object)Registry.field_212624_m.func_148745_a(p_202826_0_));
        Biome biome1 = (Biome)((Object)Registry.field_212624_m.func_148745_a(p_202826_1_));
        if (biome != null && biome1 != null) {
            if (biome != Biomes.field_150607_aa && biome != Biomes.field_150608_ab) {
                if (biome.func_201856_r() != Biome.Category.NONE && biome1.func_201856_r() != Biome.Category.NONE && biome.func_201856_r() == biome1.func_201856_r()) {
                    return true;
                }
                return biome == biome1;
            }
            return biome1 == Biomes.field_150607_aa || biome1 == Biomes.field_150608_ab;
        }
        return false;
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewSize();
    }

    protected static boolean func_202827_a(int biomeIn) {
        return biomeIn == field_203632_a || biomeIn == field_203633_b || biomeIn == field_202832_c || biomeIn == field_203634_d || biomeIn == field_202831_b || biomeIn == field_203635_f || biomeIn == field_203636_g || biomeIn == field_202830_a || biomeIn == field_203637_i || biomeIn == field_203638_j;
    }

    protected static boolean func_203631_b(int biomeIn) {
        return biomeIn == field_203632_a || biomeIn == field_203633_b || biomeIn == field_202832_c || biomeIn == field_203634_d || biomeIn == field_202831_b;
    }
}

