/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementManager
extends JsonReloadListener {
    private static final Logger field_192782_a = LogManager.getLogger();
    private static final Gson field_192783_b = new GsonBuilder().registerTypeHierarchyAdapter(Advancement.Builder.class, (jsonElement, type, jsonDeserializationContext) -> {
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "advancement");
        return Advancement.Builder.func_192059_a(jsonObject, jsonDeserializationContext);
    }).registerTypeAdapter(AdvancementRewards.class, (Object)new AdvancementRewards.Deserializer()).registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    private AdvancementList field_223388_c = new AdvancementList();

    public AdvancementManager() {
        super(field_192783_b, "advancements");
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonObject> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        HashMap hashMap = Maps.newHashMap();
        map.forEach((resourceLocation, jsonObject) -> {
            try {
                Advancement.Builder builder = (Advancement.Builder)field_192783_b.fromJson((JsonElement)jsonObject, Advancement.Builder.class);
                hashMap.put(resourceLocation, builder);
            }
            catch (JsonParseException | IllegalArgumentException throwable) {
                field_192782_a.error("Parsing error loading custom advancement {}: {}", resourceLocation, (Object)throwable.getMessage());
            }
        });
        AdvancementList \u26032 = new AdvancementList();
        \u26032.func_192083_a(hashMap);
        for (Advancement advancement : \u26032.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a(advancement);
        }
        this.field_223388_c = \u26032;
    }

    @Nullable
    public Advancement func_192778_a(ResourceLocation resourceLocation) {
        return this.field_223388_c.func_192084_a(resourceLocation);
    }

    public Collection<Advancement> func_195438_b() {
        return this.field_223388_c.func_195651_c();
    }
}

