/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.TranslationTextComponent;

public class TimeArgument
implements ArgumentType<Integer> {
    private static final Collection<String> field_218093_a = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType field_218094_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.time.invalid_unit", new Object[0]));
    private static final DynamicCommandExceptionType field_218095_c = new DynamicCommandExceptionType(object -> new TranslationTextComponent("argument.time.invalid_tick_count", object));
    private static final Object2IntMap<String> field_218096_d = new Object2IntOpenHashMap();

    public static TimeArgument func_218091_a() {
        return new TimeArgument();
    }

    public Integer parse(StringReader stringReader) throws CommandSyntaxException {
        float f = stringReader.readFloat();
        String \u26032 = stringReader.readUnquotedString();
        int \u26033 = field_218096_d.getOrDefault((Object)\u26032, 0);
        if (\u26033 == 0) {
            throw field_218094_b.create();
        }
        int \u26034 = Math.round(f * (float)\u26033);
        if (\u26034 < 0) {
            throw field_218095_c.create((Object)\u26034);
        }
        return \u26034;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        StringReader stringReader = new StringReader(suggestionsBuilder.getRemaining());
        try {
            stringReader.readFloat();
        }
        catch (CommandSyntaxException \u26032) {
            return suggestionsBuilder.buildFuture();
        }
        return ISuggestionProvider.func_197005_b((Iterable<String>)field_218096_d.keySet(), suggestionsBuilder.createOffset(suggestionsBuilder.getStart() + stringReader.getCursor()));
    }

    public Collection<String> getExamples() {
        return field_218093_a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static {
        field_218096_d.put((Object)"d", 24000);
        field_218096_d.put((Object)"s", 20);
        field_218096_d.put((Object)"t", 1);
        field_218096_d.put((Object)"", 1);
    }
}

