/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EndermanEntity
extends MonsterEntity {
    private static final UUID field_110192_bp = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier field_110193_bq = new AttributeModifier(field_110192_bp, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final DataParameter<Optional<BlockState>> field_184718_bv = EntityDataManager.func_187226_a(EndermanEntity.class, DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> field_184719_bw = EntityDataManager.func_187226_a(EndermanEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_226535_bx_ = EntityDataManager.func_187226_a(EndermanEntity.class, DataSerializers.field_187198_h);
    private static final Predicate<LivingEntity> field_213627_bA = livingEntity -> livingEntity instanceof EndermiteEntity && ((EndermiteEntity)livingEntity).func_175495_n();
    private int field_226536_bz_ = Integer.MIN_VALUE;
    private int field_184721_by;

    public EndermanEntity(EntityType<? extends EndermanEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new StareGoal(this));
        this.field_70714_bg.func_75776_a(2, new MeleeAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70714_bg.func_75776_a(10, new PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, new TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(2, new HurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<EndermiteEntity>(this, EndermiteEntity.class, 10, true, false, field_213627_bA));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @Override
    public void func_70624_b(@Nullable LivingEntity livingEntity) {
        super.func_70624_b(livingEntity);
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (livingEntity == null) {
            this.field_184721_by = 0;
            this.field_70180_af.func_187227_b(field_184719_bw, false);
            this.field_70180_af.func_187227_b(field_226535_bx_, false);
            iAttributeInstance.func_111124_b(field_110193_bq);
        } else {
            this.field_184721_by = this.field_70173_aa;
            this.field_70180_af.func_187227_b(field_184719_bw, true);
            if (!iAttributeInstance.func_180374_a(field_110193_bq)) {
                iAttributeInstance.func_111121_a(field_110193_bq);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184718_bv, Optional.empty());
        this.field_70180_af.func_187214_a(field_184719_bw, false);
        this.field_70180_af.func_187214_a(field_226535_bx_, false);
    }

    public void func_226539_l_() {
        if (this.field_70173_aa >= this.field_226536_bz_ + 400) {
            this.field_226536_bz_ = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184719_bw.equals(dataParameter) && this.func_226537_et_() && this.field_70170_p.field_72995_K) {
            this.func_226539_l_();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        BlockState blockState = this.func_195405_dq();
        if (blockState != null) {
            compoundNBT.func_218657_a("carriedBlockState", NBTUtil.func_190009_a(blockState));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        BlockState blockState = null;
        if (compoundNBT.func_150297_b("carriedBlockState", 10) && (blockState = NBTUtil.func_190008_d(compoundNBT.func_74775_l("carriedBlockState"))).func_196958_f()) {
            blockState = null;
        }
        this.func_195406_b(blockState);
    }

    private boolean func_70821_d(PlayerEntity playerEntity) {
        ItemStack itemStack = playerEntity.field_71071_by.field_70460_b.get(3);
        if (itemStack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vec3d \u26032 = playerEntity.func_70676_i(1.0f).func_72432_b();
        Vec3d \u26033 = new Vec3d(this.func_226277_ct_() - playerEntity.func_226277_ct_(), this.func_226280_cw_() - playerEntity.func_226280_cw_(), this.func_226281_cx_() - playerEntity.func_226281_cx_());
        double \u26034 = \u26033.func_72433_c();
        double \u26035 = \u26032.func_72430_b(\u26033 = \u26033.func_72432_b());
        if (\u26035 > 1.0 - 0.025 / \u26034) {
            return playerEntity.func_70685_l(this);
        }
        return false;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 2.55f;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a(ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        float f;
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.field_184721_by + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(new BlockPos(this)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.func_70820_n();
        }
        super.func_70619_bc();
    }

    protected boolean func_70820_n() {
        if (this.field_70170_p.func_201670_d() || !this.func_70089_S()) {
            return false;
        }
        double d = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        \u2603 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
        \u2603 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.func_70825_j(d, \u2603, \u2603);
    }

    private boolean func_70816_c(Entity entity) {
        Vec3d vec3d = new Vec3d(this.func_226277_ct_() - entity.func_226277_ct_(), this.func_226283_e_(0.5) - entity.func_226280_cw_(), this.func_226281_cx_() - entity.func_226281_cx_());
        vec3d = vec3d.func_72432_b();
        double \u26032 = 16.0;
        double \u26033 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double \u26034 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double \u26035 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.func_70825_j(\u26033, \u26034, \u26035);
    }

    private boolean func_70825_j(double d, double d2, double d3) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(d, d2, d3);
        while (mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p(mutable).func_185904_a().func_76230_c()) {
            mutable.func_189536_c(Direction.DOWN);
        }
        BlockState \u26032 = this.field_70170_p.func_180495_p(mutable);
        boolean \u26033 = \u26032.func_185904_a().func_76230_c();
        boolean \u26034 = \u26032.func_204520_s().func_206884_a(FluidTags.field_206959_a);
        if (!\u26033 || \u26034) {
            return false;
        }
        boolean \u26035 = this.func_213373_a(d, d2, d3, true);
        if (\u26035) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return \u26035;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.func_70823_r() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187531_aU;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    @Override
    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
        super.func_213333_a(damageSource, n, bl);
        BlockState blockState = this.func_195405_dq();
        if (blockState != null) {
            this.func_199703_a(blockState.func_177230_c());
        }
    }

    public void func_195406_b(@Nullable BlockState blockState) {
        this.field_70180_af.func_187227_b(field_184718_bv, Optional.ofNullable(blockState));
    }

    @Nullable
    public BlockState func_195405_dq() {
        return this.field_70180_af.func_187225_a(field_184718_bv).orElse(null);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        if (damageSource2 instanceof IndirectEntityDamageSource || damageSource2 == DamageSource.field_191552_t) {
            for (int i = 0; i < 64; ++i) {
                if (!this.func_70820_n()) continue;
                return true;
            }
            return false;
        }
        boolean \u26032 = super.func_70097_a(damageSource2, f);
        if (!this.field_70170_p.func_201670_d() && damageSource2.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.func_70820_n();
        }
        return \u26032;
    }

    public boolean func_70823_r() {
        return this.field_70180_af.func_187225_a(field_184719_bw);
    }

    public boolean func_226537_et_() {
        return this.field_70180_af.func_187225_a(field_226535_bx_);
    }

    public void func_226538_eu_() {
        this.field_70180_af.func_187227_b(field_226535_bx_, true);
    }

    static class TakeBlockGoal
    extends Goal {
        private final EndermanEntity field_179473_a;

        public TakeBlockGoal(EndermanEntity endermanEntity) {
            this.field_179473_a = endermanEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_179473_a.func_195405_dq() != null) {
                return false;
            }
            if (!this.field_179473_a.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                return false;
            }
            return this.field_179473_a.func_70681_au().nextInt(20) == 0;
        }

        @Override
        public void func_75246_d() {
            Random random = this.field_179473_a.func_70681_au();
            World \u26032 = this.field_179473_a.field_70170_p;
            int \u26033 = MathHelper.func_76128_c(this.field_179473_a.func_226277_ct_() - 2.0 + random.nextDouble() * 4.0);
            int \u26034 = MathHelper.func_76128_c(this.field_179473_a.func_226278_cu_() + random.nextDouble() * 3.0);
            int \u26035 = MathHelper.func_76128_c(this.field_179473_a.func_226281_cx_() - 2.0 + random.nextDouble() * 4.0);
            BlockPos \u26036 = new BlockPos(\u26033, \u26034, \u26035);
            BlockState \u26037 = \u26032.func_180495_p(\u26036);
            Block \u26038 = \u26037.func_177230_c();
            Vec3d \u26039 = new Vec3d((double)MathHelper.func_76128_c(this.field_179473_a.func_226277_ct_()) + 0.5, (double)\u26034 + 0.5, (double)MathHelper.func_76128_c(this.field_179473_a.func_226281_cx_()) + 0.5);
            Vec3d \u260310 = new Vec3d((double)\u26033 + 0.5, (double)\u26034 + 0.5, (double)\u26035 + 0.5);
            BlockRayTraceResult \u260311 = \u26032.func_217299_a(new RayTraceContext(\u26039, \u260310, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, this.field_179473_a));
            boolean \u260312 = \u260311.func_216350_a().equals(\u26036);
            if (\u26038.func_203417_a(BlockTags.field_201151_l) && \u260312) {
                this.field_179473_a.func_195406_b(\u26037);
                \u26032.func_217377_a(\u26036, false);
            }
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EndermanEntity field_179475_a;

        public PlaceBlockGoal(EndermanEntity endermanEntity) {
            this.field_179475_a = endermanEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_179475_a.func_195405_dq() == null) {
                return false;
            }
            if (!this.field_179475_a.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                return false;
            }
            return this.field_179475_a.func_70681_au().nextInt(2000) == 0;
        }

        @Override
        public void func_75246_d() {
            Random random = this.field_179475_a.func_70681_au();
            World \u26032 = this.field_179475_a.field_70170_p;
            int \u26033 = MathHelper.func_76128_c(this.field_179475_a.func_226277_ct_() - 1.0 + random.nextDouble() * 2.0);
            int \u26034 = MathHelper.func_76128_c(this.field_179475_a.func_226278_cu_() + random.nextDouble() * 2.0);
            int \u26035 = MathHelper.func_76128_c(this.field_179475_a.func_226281_cx_() - 1.0 + random.nextDouble() * 2.0);
            BlockPos \u26036 = new BlockPos(\u26033, \u26034, \u26035);
            BlockState \u26037 = \u26032.func_180495_p(\u26036);
            BlockPos \u26038 = \u26036.func_177977_b();
            BlockState \u26039 = \u26032.func_180495_p(\u26038);
            BlockState \u260310 = this.field_179475_a.func_195405_dq();
            if (\u260310 != null && this.func_220836_a(\u26032, \u26036, \u260310, \u26037, \u26039, \u26038)) {
                \u26032.func_180501_a(\u26036, \u260310, 3);
                this.field_179475_a.func_195406_b(null);
            }
        }

        private boolean func_220836_a(IWorldReader iWorldReader, BlockPos blockPos, BlockState blockState, BlockState blockState2, BlockState blockState3, BlockPos blockPos2) {
            return blockState2.func_196958_f() && !blockState3.func_196958_f() && blockState3.func_224756_o(iWorldReader, blockPos2) && blockState.func_196955_c(iWorldReader, blockPos);
        }
    }

    static class StareGoal
    extends Goal {
        private final EndermanEntity field_220835_a;
        private LivingEntity field_226540_b_;

        public StareGoal(EndermanEntity endermanEntity) {
            this.field_220835_a = endermanEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            this.field_226540_b_ = this.field_220835_a.func_70638_az();
            if (!(this.field_226540_b_ instanceof PlayerEntity)) {
                return false;
            }
            double d = this.field_226540_b_.func_70068_e(this.field_220835_a);
            if (d > 256.0) {
                return false;
            }
            return this.field_220835_a.func_70821_d((PlayerEntity)this.field_226540_b_);
        }

        @Override
        public void func_75249_e() {
            this.field_220835_a.func_70661_as().func_75499_g();
        }

        @Override
        public void func_75246_d() {
            this.field_220835_a.func_70671_ap().func_220679_a(this.field_226540_b_.func_226277_ct_(), this.field_226540_b_.func_226280_cw_(), this.field_226540_b_.func_226281_cx_());
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final EndermanEntity field_179449_j;
        private PlayerEntity field_179448_g;
        private int field_179450_h;
        private int field_179451_i;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(EndermanEntity endermanEntity) {
            super((MobEntity)endermanEntity, PlayerEntity.class, false);
            this.field_179449_j = endermanEntity;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(livingEntity -> endermanEntity.func_70821_d((PlayerEntity)livingEntity));
        }

        @Override
        public boolean func_75250_a() {
            this.field_179448_g = this.field_179449_j.field_70170_p.func_217370_a(this.field_220791_m, this.field_179449_j);
            return this.field_179448_g != null;
        }

        @Override
        public void func_75249_e() {
            this.field_179450_h = 5;
            this.field_179451_i = 0;
            this.field_179449_j.func_226538_eu_();
        }

        @Override
        public void func_75251_c() {
            this.field_179448_g = null;
            super.func_75251_c();
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_179448_g != null) {
                if (!this.field_179449_j.func_70821_d(this.field_179448_g)) {
                    return false;
                }
                this.field_179449_j.func_70625_a(this.field_179448_g, 10.0f, 10.0f);
                return true;
            }
            if (this.field_75309_a != null && this.field_220792_n.func_221015_a(this.field_179449_j, this.field_75309_a)) {
                return true;
            }
            return super.func_75253_b();
        }

        @Override
        public void func_75246_d() {
            if (this.field_179448_g != null) {
                if (--this.field_179450_h <= 0) {
                    this.field_75309_a = this.field_179448_g;
                    this.field_179448_g = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.field_179449_j.func_184218_aH()) {
                    if (this.field_179449_j.func_70821_d((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e(this.field_179449_j) < 16.0) {
                            this.field_179449_j.func_70820_n();
                        }
                        this.field_179451_i = 0;
                    } else if (this.field_75309_a.func_70068_e(this.field_179449_j) > 256.0 && this.field_179451_i++ >= 30 && this.field_179449_j.func_70816_c(this.field_75309_a)) {
                        this.field_179451_i = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

