/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionEntity
extends ThrowableEntity {
    private static final DataParameter<ItemStack> field_184545_d = EntityDataManager.func_187226_a(PotionEntity.class, DataSerializers.field_187196_f);
    private static final Logger field_184546_e = LogManager.getLogger();
    public static final Predicate<LivingEntity> field_190546_d = PotionEntity::func_190544_c;

    public PotionEntity(EntityType<? extends PotionEntity> entityType, World world) {
        super((EntityType<? extends ThrowableEntity>)entityType, world);
    }

    public PotionEntity(World world, LivingEntity livingEntity) {
        super(EntityType.field_200754_at, livingEntity, world);
    }

    public PotionEntity(World world, double d, double d2, double d3) {
        super(EntityType.field_200754_at, d, d2, d3, world);
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184545_d, ItemStack.field_190927_a);
    }

    public ItemStack func_184543_l() {
        ItemStack itemStack = this.func_184212_Q().func_187225_a(field_184545_d);
        if (itemStack.func_77973_b() != Items.field_185155_bH && itemStack.func_77973_b() != Items.field_185156_bI) {
            if (this.field_70170_p != null) {
                field_184546_e.error("ThrownPotion entity {} has no item?!", (Object)this.func_145782_y());
            }
            return new ItemStack(Items.field_185155_bH);
        }
        return itemStack;
    }

    public void func_184541_a(ItemStack itemStack) {
        this.func_184212_Q().func_187227_b(field_184545_d, itemStack.func_77946_l());
    }

    @Override
    protected float func_70185_h() {
        return 0.05f;
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTraceResult) {
        boolean bl;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = this.func_184543_l();
        Potion \u26032 = PotionUtils.func_185191_c(itemStack);
        List<EffectInstance> \u26033 = PotionUtils.func_185189_a(itemStack);
        boolean bl2 = bl = \u26032 == Potions.field_185230_b && \u26033.isEmpty();
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && bl) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            Direction \u26034 = blockRayTraceResult.func_216354_b();
            BlockPos \u26035 = blockRayTraceResult.func_216350_a().func_177972_a(\u26034);
            this.func_184542_a(\u26035, \u26034);
            this.func_184542_a(\u26035.func_177972_a(\u26034.func_176734_d()), \u26034);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                this.func_184542_a(\u26035.func_177972_a(direction), direction);
            }
        }
        if (bl) {
            this.func_190545_n();
        } else if (!\u26033.isEmpty()) {
            if (this.func_184544_n()) {
                this.func_190542_a(itemStack, \u26032);
            } else {
                this.func_213888_a(\u26033, rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)rayTraceResult).func_216348_a() : null);
            }
        }
        int \u26036 = \u26032.func_185172_c() ? 2007 : 2002;
        this.field_70170_p.func_217379_c(\u26036, new BlockPos(this), PotionUtils.func_190932_c(itemStack));
        this.func_70106_y();
    }

    private void func_190545_n() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<LivingEntity> \u26032 = this.field_70170_p.func_175647_a(LivingEntity.class, axisAlignedBB, field_190546_d);
        if (!\u26032.isEmpty()) {
            for (LivingEntity livingEntity : \u26032) {
                double d = this.func_70068_e(livingEntity);
                if (!(d < 16.0) || !PotionEntity.func_190544_c(livingEntity)) continue;
                livingEntity.func_70097_a(DamageSource.func_76354_b(livingEntity, this.func_85052_h()), 1.0f);
            }
        }
    }

    private void func_213888_a(List<EffectInstance> list, @Nullable Entity entity) {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<LivingEntity> \u26032 = this.field_70170_p.func_217357_a(LivingEntity.class, axisAlignedBB);
        if (!\u26032.isEmpty()) {
            for (LivingEntity livingEntity : \u26032) {
                if (!livingEntity.func_184603_cC() || !((\u2603 = this.func_70068_e(livingEntity)) < 16.0)) continue;
                double d = 1.0 - Math.sqrt(\u2603) / 4.0;
                if (livingEntity == entity) {
                    d = 1.0;
                }
                for (EffectInstance effectInstance : list) {
                    Effect effect = effectInstance.func_188419_a();
                    if (effect.func_76403_b()) {
                        effect.func_180793_a(this, this.func_85052_h(), livingEntity, effectInstance.func_76458_c(), d);
                        continue;
                    }
                    int \u26033 = (int)(d * (double)effectInstance.func_76459_b() + 0.5);
                    if (\u26033 <= 20) continue;
                    livingEntity.func_195064_c(new EffectInstance(effect, \u26033, effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e()));
                }
            }
        }
    }

    private void func_190542_a(ItemStack itemStack2, Potion potion) {
        ItemStack itemStack2;
        AreaEffectCloudEntity areaEffectCloudEntity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaEffectCloudEntity.func_184481_a(this.func_85052_h());
        areaEffectCloudEntity.func_184483_a(3.0f);
        areaEffectCloudEntity.func_184495_b(-0.5f);
        areaEffectCloudEntity.func_184485_d(10);
        areaEffectCloudEntity.func_184487_c(-areaEffectCloudEntity.func_184490_j() / (float)areaEffectCloudEntity.func_184489_o());
        areaEffectCloudEntity.func_184484_a(potion);
        for (EffectInstance effectInstance : PotionUtils.func_185190_b(itemStack2)) {
            areaEffectCloudEntity.func_184496_a(new EffectInstance(effectInstance));
        }
        CompoundNBT \u26032 = itemStack2.func_77978_p();
        if (\u26032 != null && \u26032.func_150297_b("CustomPotionColor", 99)) {
            areaEffectCloudEntity.func_184482_a(\u26032.func_74762_e("CustomPotionColor"));
        }
        this.field_70170_p.func_217376_c(areaEffectCloudEntity);
    }

    private boolean func_184544_n() {
        return this.func_184543_l().func_77973_b() == Items.field_185156_bI;
    }

    private void func_184542_a(BlockPos blockPos, Direction direction) {
        BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
        Block \u26032 = blockState.func_177230_c();
        if (\u26032 == Blocks.field_150480_ab) {
            this.field_70170_p.func_175719_a(null, blockPos.func_177972_a(direction), direction.func_176734_d());
        } else if (\u26032 == Blocks.field_222433_lV && blockState.func_177229_b(CampfireBlock.field_220101_b).booleanValue()) {
            this.field_70170_p.func_217378_a(null, 1009, blockPos, 0);
            this.field_70170_p.func_175656_a(blockPos, (BlockState)blockState.func_206870_a(CampfireBlock.field_220101_b, false));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        ItemStack itemStack = ItemStack.func_199557_a(compoundNBT.func_74775_l("Potion"));
        if (itemStack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.func_184541_a(itemStack);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        ItemStack itemStack = this.func_184543_l();
        if (!itemStack.func_190926_b()) {
            compoundNBT.func_218657_a("Potion", itemStack.func_77955_b(new CompoundNBT()));
        }
    }

    private static boolean func_190544_c(LivingEntity livingEntity) {
        return livingEntity instanceof EndermanEntity || livingEntity instanceof BlazeEntity;
    }
}

