/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SPlayerDiggingPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerInteractionManager {
    private static final Logger field_225418_c = LogManager.getLogger();
    public ServerWorld field_73092_a;
    public ServerPlayerEntity field_73090_b;
    private GameType field_73091_c = GameType.NOT_SET;
    private boolean field_73088_d;
    private int field_73089_e;
    private BlockPos field_180240_f = BlockPos.field_177992_a;
    private int field_73100_i;
    private boolean field_73097_j;
    private BlockPos field_180241_i = BlockPos.field_177992_a;
    private int field_73093_n;
    private int field_73094_o = -1;

    public PlayerInteractionManager(ServerWorld serverWorld) {
        this.field_73092_a = serverWorld;
    }

    public void func_73076_a(GameType gameType) {
        this.field_73091_c = gameType;
        gameType.func_77147_a(this.field_73090_b.field_71075_bZ);
        this.field_73090_b.func_71016_p();
        this.field_73090_b.field_71133_b.func_184103_al().func_148540_a(new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_GAME_MODE, this.field_73090_b));
        this.field_73092_a.func_72854_c();
    }

    public GameType func_73081_b() {
        return this.field_73091_c;
    }

    public boolean func_180239_c() {
        return this.field_73091_c.func_77144_e();
    }

    public boolean func_73083_d() {
        return this.field_73091_c.func_77145_d();
    }

    public void func_73077_b(GameType gameType) {
        if (this.field_73091_c == GameType.NOT_SET) {
            this.field_73091_c = gameType;
        }
        this.func_73076_a(this.field_73091_c);
    }

    public void func_73075_a() {
        ++this.field_73100_i;
        if (this.field_73097_j) {
            BlockState blockState = this.field_73092_a.func_180495_p(this.field_180241_i);
            if (blockState.func_196958_f()) {
                this.field_73097_j = false;
            } else {
                float f = this.func_229859_a_(blockState, this.field_180241_i, this.field_73093_n);
                if (f >= 1.0f) {
                    this.field_73097_j = false;
                    this.func_180237_b(this.field_180241_i);
                }
            }
        } else if (this.field_73088_d) {
            BlockState blockState = this.field_73092_a.func_180495_p(this.field_180240_f);
            if (blockState.func_196958_f()) {
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
                this.field_73094_o = -1;
                this.field_73088_d = false;
            } else {
                this.func_229859_a_(blockState, this.field_180240_f, this.field_73089_e);
            }
        }
    }

    private float func_229859_a_(BlockState blockState, BlockPos blockPos, int n) {
        \u2603 = this.field_73100_i - n;
        float f = blockState.func_185903_a(this.field_73090_b, this.field_73090_b.field_70170_p, blockPos) * (float)(\u2603 + 1);
        int \u26032 = (int)(f * 10.0f);
        if (\u26032 != this.field_73094_o) {
            this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos, \u26032);
            this.field_73094_o = \u26032;
        }
        return f;
    }

    public void func_225416_a(BlockPos blockPos2, CPlayerDiggingPacket.Action action2, Direction direction, int n) {
        CPlayerDiggingPacket.Action action2;
        double d = this.field_73090_b.func_226277_ct_() - ((double)blockPos2.func_177958_n() + 0.5);
        \u2603 = d * d + (\u2603 = this.field_73090_b.func_226278_cu_() - ((double)blockPos2.func_177956_o() + 0.5) + 1.5) * \u2603 + (\u2603 = this.field_73090_b.func_226281_cx_() - ((double)blockPos2.func_177952_p() + 0.5)) * \u2603;
        if (\u2603 > 36.0) {
            this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, false, "too far"));
            return;
        }
        if (blockPos2.func_177956_o() >= n) {
            this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, false, "too high"));
            return;
        }
        if (action2 == CPlayerDiggingPacket.Action.START_DESTROY_BLOCK) {
            if (!this.field_73092_a.func_175660_a(this.field_73090_b, blockPos2)) {
                this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, false, "may not interact"));
                return;
            }
            if (this.func_73083_d()) {
                if (!this.field_73092_a.func_175719_a(null, blockPos2, direction)) {
                    this.func_229860_a_(blockPos2, action2, "creative destroy");
                } else {
                    this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, true, "fire put out"));
                }
                return;
            }
            if (this.field_73090_b.func_223729_a(this.field_73092_a, blockPos2, this.field_73091_c)) {
                this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, false, "block action restricted"));
                return;
            }
            this.field_73092_a.func_175719_a(null, blockPos2, direction);
            this.field_73089_e = this.field_73100_i;
            float f = 1.0f;
            BlockState \u26032 = this.field_73092_a.func_180495_p(blockPos2);
            if (!\u26032.func_196958_f()) {
                \u26032.func_196942_a(this.field_73092_a, blockPos2, this.field_73090_b);
                f = \u26032.func_185903_a(this.field_73090_b, this.field_73090_b.field_70170_p, blockPos2);
            }
            if (!\u26032.func_196958_f() && f >= 1.0f) {
                this.func_229860_a_(blockPos2, action2, "insta mine");
            } else {
                if (this.field_73088_d) {
                    this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(this.field_180240_f, this.field_73092_a.func_180495_p(this.field_180240_f), CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, false, "abort destroying since another started (client insta mine, server disagreed)"));
                }
                this.field_73088_d = true;
                this.field_180240_f = blockPos2.func_185334_h();
                int n2 = (int)(f * 10.0f);
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos2, n2);
                this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, true, "actual start of destroying"));
                this.field_73094_o = n2;
            }
        } else if (action2 == CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK) {
            BlockPos blockPos2;
            if (blockPos2.equals(this.field_180240_f)) {
                int n3 = this.field_73100_i - this.field_73089_e;
                BlockState \u26033 = this.field_73092_a.func_180495_p(blockPos2);
                if (!\u26033.func_196958_f()) {
                    float f = \u26033.func_185903_a(this.field_73090_b, this.field_73090_b.field_70170_p, blockPos2) * (float)(n3 + 1);
                    if (f >= 0.7f) {
                        this.field_73088_d = false;
                        this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos2, -1);
                        this.func_229860_a_(blockPos2, action2, "destroyed");
                        return;
                    }
                    if (!this.field_73097_j) {
                        this.field_73088_d = false;
                        this.field_73097_j = true;
                        this.field_180241_i = blockPos2;
                        this.field_73093_n = this.field_73089_e;
                    }
                }
            }
            this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, true, "stopped destroying"));
        } else if (action2 == CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK) {
            this.field_73088_d = false;
            if (!Objects.equals(this.field_180240_f, blockPos2)) {
                field_225418_c.warn("Mismatch in destroy block pos: " + this.field_180240_f + " " + blockPos2);
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
                this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(this.field_180240_f, this.field_73092_a.func_180495_p(this.field_180240_f), action2, true, "aborted mismatched destroying"));
            }
            this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos2, -1);
            this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos2, this.field_73092_a.func_180495_p(blockPos2), action2, true, "aborted destroying"));
        }
    }

    public void func_229860_a_(BlockPos blockPos, CPlayerDiggingPacket.Action action, String string) {
        if (this.func_180237_b(blockPos)) {
            this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, true, string));
        } else {
            this.field_73090_b.field_71135_a.func_147359_a(new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, false, string));
        }
    }

    public boolean func_180237_b(BlockPos blockPos) {
        BlockState blockState = this.field_73092_a.func_180495_p(blockPos);
        if (!this.field_73090_b.func_184614_ca().func_77973_b().func_195938_a(blockState, this.field_73092_a, blockPos, this.field_73090_b)) {
            return false;
        }
        TileEntity \u26032 = this.field_73092_a.func_175625_s(blockPos);
        Block \u26033 = blockState.func_177230_c();
        if ((\u26033 instanceof CommandBlockBlock || \u26033 instanceof StructureBlock || \u26033 instanceof JigsawBlock) && !this.field_73090_b.func_195070_dx()) {
            this.field_73092_a.func_184138_a(blockPos, blockState, blockState, 3);
            return false;
        }
        if (this.field_73090_b.func_223729_a(this.field_73092_a, blockPos, this.field_73091_c)) {
            return false;
        }
        \u26033.func_176208_a(this.field_73092_a, blockPos, blockState, this.field_73090_b);
        boolean \u26034 = this.field_73092_a.func_217377_a(blockPos, false);
        if (\u26034) {
            \u26033.func_176206_d(this.field_73092_a, blockPos, blockState);
        }
        if (this.func_73083_d()) {
            return true;
        }
        ItemStack \u26035 = this.field_73090_b.func_184614_ca();
        ItemStack \u26036 = \u26035.func_77946_l();
        boolean \u26037 = this.field_73090_b.func_184823_b(blockState);
        \u26035.func_179548_a(this.field_73092_a, blockState, blockPos, this.field_73090_b);
        if (\u26034 && \u26037) {
            \u26033.func_180657_a(this.field_73092_a, this.field_73090_b, blockPos, blockState, \u26032, \u26036);
        }
        return true;
    }

    public ActionResultType func_187250_a(PlayerEntity playerEntity, World world, ItemStack itemStack, Hand hand) {
        if (this.field_73091_c == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        if (playerEntity.func_184811_cZ().func_185141_a(itemStack.func_77973_b())) {
            return ActionResultType.PASS;
        }
        int n = itemStack.func_190916_E();
        \u2603 = itemStack.func_77952_i();
        ActionResult<ItemStack> \u26032 = itemStack.func_77957_a(world, playerEntity, hand);
        ItemStack \u26033 = \u26032.func_188398_b();
        if (\u26033 == itemStack && \u26033.func_190916_E() == n && \u26033.func_77988_m() <= 0 && \u26033.func_77952_i() == \u2603) {
            return \u26032.func_188397_a();
        }
        if (\u26032.func_188397_a() == ActionResultType.FAIL && \u26033.func_77988_m() > 0 && !playerEntity.func_184587_cr()) {
            return \u26032.func_188397_a();
        }
        playerEntity.func_184611_a(hand, \u26033);
        if (this.func_73083_d()) {
            \u26033.func_190920_e(n);
            if (\u26033.func_77984_f() && \u26033.func_77952_i() != \u2603) {
                \u26033.func_196085_b(\u2603);
            }
        }
        if (\u26033.func_190926_b()) {
            playerEntity.func_184611_a(hand, ItemStack.field_190927_a);
        }
        if (!playerEntity.func_184587_cr()) {
            ((ServerPlayerEntity)playerEntity).func_71120_a(playerEntity.field_71069_bz);
        }
        return \u26032.func_188397_a();
    }

    public ActionResultType func_219441_a(PlayerEntity playerEntity2, World world, ItemStack itemStack, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        PlayerEntity playerEntity2;
        BlockPos blockPos = blockRayTraceResult.func_216350_a();
        BlockState \u26032 = world.func_180495_p(blockPos);
        if (this.field_73091_c == GameType.SPECTATOR) {
            INamedContainerProvider iNamedContainerProvider = \u26032.func_215699_b(world, blockPos);
            if (iNamedContainerProvider != null) {
                playerEntity2.func_213829_a(iNamedContainerProvider);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        boolean \u26033 = !playerEntity2.func_184614_ca().func_190926_b() || !playerEntity2.func_184592_cb().func_190926_b();
        boolean bl = \u2603 = playerEntity2.func_226563_dT_() && \u26033;
        if (!\u2603 && (\u26034 = \u26032.func_227031_a_(world, playerEntity2, hand, blockRayTraceResult)).func_226246_a_()) {
            return \u26034;
        }
        if (itemStack.func_190926_b() || playerEntity2.func_184811_cZ().func_185141_a(itemStack.func_77973_b())) {
            return ActionResultType.PASS;
        }
        Object \u26034 = new ItemUseContext(playerEntity2, hand, blockRayTraceResult);
        if (this.func_73083_d()) {
            int n = itemStack.func_190916_E();
            ActionResultType \u26035 = itemStack.func_196084_a((ItemUseContext)\u26034);
            itemStack.func_190920_e(n);
            return \u26035;
        }
        return itemStack.func_196084_a((ItemUseContext)\u26034);
    }

    public void func_73080_a(ServerWorld serverWorld) {
        this.field_73092_a = serverWorld;
    }
}

