/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class StructureBlockTileEntity
extends TileEntity {
    private ResourceLocation field_184420_a;
    private String field_184421_f = "";
    private String field_184422_g = "";
    private BlockPos field_184423_h = new BlockPos(0, 1, 0);
    private BlockPos field_184424_i = BlockPos.field_177992_a;
    private Mirror field_184425_j = Mirror.NONE;
    private Rotation field_184426_k = Rotation.NONE;
    private StructureMode field_184427_l = StructureMode.DATA;
    private boolean field_184428_m = true;
    private boolean field_189727_n;
    private boolean field_189728_o;
    private boolean field_189729_p = true;
    private float field_189730_q = 1.0f;
    private long field_189731_r;

    public StructureBlockTileEntity() {
        super(TileEntityType.field_200990_u);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        compoundNBT.func_74778_a("name", this.func_189715_d());
        compoundNBT.func_74778_a("author", this.field_184421_f);
        compoundNBT.func_74778_a("metadata", this.field_184422_g);
        compoundNBT.func_74768_a("posX", this.field_184423_h.func_177958_n());
        compoundNBT.func_74768_a("posY", this.field_184423_h.func_177956_o());
        compoundNBT.func_74768_a("posZ", this.field_184423_h.func_177952_p());
        compoundNBT.func_74768_a("sizeX", this.field_184424_i.func_177958_n());
        compoundNBT.func_74768_a("sizeY", this.field_184424_i.func_177956_o());
        compoundNBT.func_74768_a("sizeZ", this.field_184424_i.func_177952_p());
        compoundNBT.func_74778_a("rotation", this.field_184426_k.toString());
        compoundNBT.func_74778_a("mirror", this.field_184425_j.toString());
        compoundNBT.func_74778_a("mode", this.field_184427_l.toString());
        compoundNBT.func_74757_a("ignoreEntities", this.field_184428_m);
        compoundNBT.func_74757_a("powered", this.field_189727_n);
        compoundNBT.func_74757_a("showair", this.field_189728_o);
        compoundNBT.func_74757_a("showboundingbox", this.field_189729_p);
        compoundNBT.func_74776_a("integrity", this.field_189730_q);
        compoundNBT.func_74772_a("seed", this.field_189731_r);
        return compoundNBT;
    }

    @Override
    public void func_145839_a(CompoundNBT compoundNBT) {
        super.func_145839_a(compoundNBT);
        this.func_184404_a(compoundNBT.func_74779_i("name"));
        this.field_184421_f = compoundNBT.func_74779_i("author");
        this.field_184422_g = compoundNBT.func_74779_i("metadata");
        int n = MathHelper.func_76125_a(compoundNBT.func_74762_e("posX"), -32, 32);
        \u2603 = MathHelper.func_76125_a(compoundNBT.func_74762_e("posY"), -32, 32);
        \u2603 = MathHelper.func_76125_a(compoundNBT.func_74762_e("posZ"), -32, 32);
        this.field_184423_h = new BlockPos(n, \u2603, \u2603);
        \u2603 = MathHelper.func_76125_a(compoundNBT.func_74762_e("sizeX"), 0, 32);
        \u2603 = MathHelper.func_76125_a(compoundNBT.func_74762_e("sizeY"), 0, 32);
        \u2603 = MathHelper.func_76125_a(compoundNBT.func_74762_e("sizeZ"), 0, 32);
        this.field_184424_i = new BlockPos(\u2603, \u2603, \u2603);
        try {
            this.field_184426_k = Rotation.valueOf(compoundNBT.func_74779_i("rotation"));
        }
        catch (IllegalArgumentException \u26032) {
            this.field_184426_k = Rotation.NONE;
        }
        try {
            this.field_184425_j = Mirror.valueOf(compoundNBT.func_74779_i("mirror"));
        }
        catch (IllegalArgumentException \u26033) {
            this.field_184425_j = Mirror.NONE;
        }
        try {
            this.field_184427_l = StructureMode.valueOf(compoundNBT.func_74779_i("mode"));
        }
        catch (IllegalArgumentException \u26034) {
            this.field_184427_l = StructureMode.DATA;
        }
        this.field_184428_m = compoundNBT.func_74767_n("ignoreEntities");
        this.field_189727_n = compoundNBT.func_74767_n("powered");
        this.field_189728_o = compoundNBT.func_74767_n("showair");
        this.field_189729_p = compoundNBT.func_74767_n("showboundingbox");
        this.field_189730_q = compoundNBT.func_74764_b("integrity") ? compoundNBT.func_74760_g("integrity") : 1.0f;
        this.field_189731_r = compoundNBT.func_74763_f("seed");
        this.func_189704_J();
    }

    private void func_189704_J() {
        if (this.field_145850_b == null) {
            return;
        }
        BlockPos blockPos = this.func_174877_v();
        BlockState \u26032 = this.field_145850_b.func_180495_p(blockPos);
        if (\u26032.func_177230_c() == Blocks.field_185779_df) {
            this.field_145850_b.func_180501_a(blockPos, (BlockState)\u26032.func_206870_a(StructureBlock.field_185587_a, this.field_184427_l), 2);
        }
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 7, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_189701_a(PlayerEntity playerEntity) {
        if (!playerEntity.func_195070_dx()) {
            return false;
        }
        if (playerEntity.func_130014_f_().field_72995_K) {
            playerEntity.func_189807_a(this);
        }
        return true;
    }

    public String func_189715_d() {
        return this.field_184420_a == null ? "" : this.field_184420_a.toString();
    }

    public String func_227014_f_() {
        return this.field_184420_a == null ? "" : this.field_184420_a.func_110623_a();
    }

    public boolean func_208404_d() {
        return this.field_184420_a != null;
    }

    public void func_184404_a(@Nullable String string) {
        this.func_210163_a(StringUtils.func_151246_b(string) ? null : ResourceLocation.func_208304_a(string));
    }

    public void func_210163_a(@Nullable ResourceLocation resourceLocation) {
        this.field_184420_a = resourceLocation;
    }

    public void func_189720_a(LivingEntity livingEntity) {
        this.field_184421_f = livingEntity.func_200200_C_().getString();
    }

    public BlockPos func_189711_e() {
        return this.field_184423_h;
    }

    public void func_184414_b(BlockPos blockPos) {
        this.field_184423_h = blockPos;
    }

    public BlockPos func_189717_g() {
        return this.field_184424_i;
    }

    public void func_184409_c(BlockPos blockPos) {
        this.field_184424_i = blockPos;
    }

    public void func_184411_a(Mirror mirror) {
        this.field_184425_j = mirror;
    }

    public void func_184408_a(Rotation rotation) {
        this.field_184426_k = rotation;
    }

    public void func_184410_b(String string) {
        this.field_184422_g = string;
    }

    public StructureMode func_189700_k() {
        return this.field_184427_l;
    }

    public void func_184405_a(StructureMode structureMode) {
        this.field_184427_l = structureMode;
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == Blocks.field_185779_df) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)blockState.func_206870_a(StructureBlock.field_185587_a, structureMode), 2);
        }
    }

    public void func_184406_a(boolean bl) {
        this.field_184428_m = bl;
    }

    public void func_189718_a(float f) {
        this.field_189730_q = f;
    }

    public void func_189725_a(long l) {
        this.field_189731_r = l;
    }

    public boolean func_184417_l() {
        if (this.field_184427_l != StructureMode.SAVE) {
            return false;
        }
        BlockPos blockPos = this.func_174877_v();
        int \u26032 = 80;
        \u2603 = new BlockPos(blockPos.func_177958_n() - 80, 0, blockPos.func_177952_p() - 80);
        List<StructureBlockTileEntity> \u26033 = this.func_184418_a(\u2603, \u2603 = new BlockPos(blockPos.func_177958_n() + 80, 255, blockPos.func_177952_p() + 80));
        List<StructureBlockTileEntity> \u26034 = this.func_184415_a(\u26033);
        if (\u26034.size() < 1) {
            return false;
        }
        MutableBoundingBox \u26035 = this.func_184416_a(blockPos, \u26034);
        if (\u26035.field_78893_d - \u26035.field_78897_a > 1 && \u26035.field_78894_e - \u26035.field_78895_b > 1 && \u26035.field_78892_f - \u26035.field_78896_c > 1) {
            this.field_184423_h = new BlockPos(\u26035.field_78897_a - blockPos.func_177958_n() + 1, \u26035.field_78895_b - blockPos.func_177956_o() + 1, \u26035.field_78896_c - blockPos.func_177952_p() + 1);
            this.field_184424_i = new BlockPos(\u26035.field_78893_d - \u26035.field_78897_a - 1, \u26035.field_78894_e - \u26035.field_78895_b - 1, \u26035.field_78892_f - \u26035.field_78896_c - 1);
            this.func_70296_d();
            BlockState blockState = this.field_145850_b.func_180495_p(blockPos);
            this.field_145850_b.func_184138_a(blockPos, blockState, blockState, 3);
            return true;
        }
        return false;
    }

    private List<StructureBlockTileEntity> func_184415_a(List<StructureBlockTileEntity> list) {
        Predicate<StructureBlockTileEntity> predicate = structureBlockTileEntity -> structureBlockTileEntity.field_184427_l == StructureMode.CORNER && Objects.equals(this.field_184420_a, structureBlockTileEntity.field_184420_a);
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    private List<StructureBlockTileEntity> func_184418_a(BlockPos blockPos, BlockPos blockPos2) {
        ArrayList arrayList = Lists.newArrayList();
        for (BlockPos blockPos3 : BlockPos.func_218278_a(blockPos, blockPos2)) {
            BlockState blockState = this.field_145850_b.func_180495_p(blockPos3);
            if (blockState.func_177230_c() != Blocks.field_185779_df || (\u2603 = this.field_145850_b.func_175625_s(blockPos3)) == null || !(\u2603 instanceof StructureBlockTileEntity)) continue;
            arrayList.add((StructureBlockTileEntity)\u2603);
        }
        return arrayList;
    }

    private MutableBoundingBox func_184416_a(BlockPos blockPos, List<StructureBlockTileEntity> list) {
        MutableBoundingBox \u26032;
        if (list.size() > 1) {
            BlockPos blockPos2 = list.get(0).func_174877_v();
            \u26032 = new MutableBoundingBox(blockPos2, blockPos2);
        } else {
            \u26032 = new MutableBoundingBox(blockPos, blockPos);
        }
        for (StructureBlockTileEntity \u26033 : list) {
            \u2603 = \u26033.func_174877_v();
            if (\u2603.func_177958_n() < \u26032.field_78897_a) {
                \u26032.field_78897_a = \u2603.func_177958_n();
            } else if (\u2603.func_177958_n() > \u26032.field_78893_d) {
                \u26032.field_78893_d = \u2603.func_177958_n();
            }
            if (\u2603.func_177956_o() < \u26032.field_78895_b) {
                \u26032.field_78895_b = \u2603.func_177956_o();
            } else if (\u2603.func_177956_o() > \u26032.field_78894_e) {
                \u26032.field_78894_e = \u2603.func_177956_o();
            }
            if (\u2603.func_177952_p() < \u26032.field_78896_c) {
                \u26032.field_78896_c = \u2603.func_177952_p();
                continue;
            }
            if (\u2603.func_177952_p() <= \u26032.field_78892_f) continue;
            \u26032.field_78892_f = \u2603.func_177952_p();
        }
        return \u26032;
    }

    public boolean func_184419_m() {
        return this.func_189712_b(true);
    }

    public boolean func_189712_b(boolean bl) {
        if (this.field_184427_l != StructureMode.SAVE || this.field_145850_b.field_72995_K || this.field_184420_a == null) {
            return false;
        }
        BlockPos blockPos = this.func_174877_v().func_177971_a(this.field_184423_h);
        ServerWorld \u26032 = (ServerWorld)this.field_145850_b;
        TemplateManager \u26033 = \u26032.func_184163_y();
        try {
            Template template = \u26033.func_200220_a(this.field_184420_a);
        }
        catch (ResourceLocationException resourceLocationException) {
            return false;
        }
        template.func_186254_a(this.field_145850_b, blockPos, this.field_184424_i, !this.field_184428_m, Blocks.field_189881_dj);
        template.func_186252_a(this.field_184421_f);
        if (bl) {
            try {
                return \u26033.func_195429_b(this.field_184420_a);
            }
            catch (ResourceLocationException resourceLocationException) {
                return false;
            }
        }
        return true;
    }

    public boolean func_184412_n() {
        return this.func_189714_c(true);
    }

    private static Random func_214074_b(long l) {
        if (l == 0L) {
            return new Random(Util.func_211177_b());
        }
        return new Random(l);
    }

    public boolean func_189714_c(boolean bl) {
        if (this.field_184427_l != StructureMode.LOAD || this.field_145850_b.field_72995_K || this.field_184420_a == null) {
            return false;
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        TemplateManager \u26032 = serverWorld.func_184163_y();
        try {
            Template template = \u26032.func_200219_b(this.field_184420_a);
        }
        catch (ResourceLocationException resourceLocationException) {
            return false;
        }
        if (template == null) {
            return false;
        }
        return this.func_227013_a_(bl, template);
    }

    public boolean func_227013_a_(boolean bl2, Template template) {
        boolean bl2;
        Object object;
        BlockPos blockPos = this.func_174877_v();
        if (!StringUtils.func_151246_b(template.func_186261_b())) {
            this.field_184421_f = template.func_186261_b();
        }
        if (!(\u2603 = this.field_184424_i.equals(\u2603 = template.func_186259_a()))) {
            this.field_184424_i = \u2603;
            this.func_70296_d();
            object = this.field_145850_b.func_180495_p(blockPos);
            this.field_145850_b.func_184138_a(blockPos, (BlockState)object, (BlockState)object, 3);
        }
        if (!bl2 || \u2603) {
            object = new PlacementSettings().func_186214_a(this.field_184425_j).func_186220_a(this.field_184426_k).func_186222_a(this.field_184428_m).func_186218_a(null);
            if (this.field_189730_q < 1.0f) {
                ((PlacementSettings)object).func_215219_b().func_215222_a(new IntegrityProcessor(MathHelper.func_76131_a(this.field_189730_q, 0.0f, 1.0f))).func_189950_a(StructureBlockTileEntity.func_214074_b(this.field_189731_r));
            }
            BlockPos \u26032 = blockPos.func_177971_a(this.field_184423_h);
            template.func_186260_a(this.field_145850_b, \u26032, (PlacementSettings)object);
            return true;
        }
        return false;
    }

    public void func_189706_E() {
        if (this.field_184420_a == null) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        TemplateManager \u26032 = serverWorld.func_184163_y();
        \u26032.func_189941_a(this.field_184420_a);
    }

    public boolean func_189709_F() {
        if (this.field_184427_l != StructureMode.LOAD || this.field_145850_b.field_72995_K || this.field_184420_a == null) {
            return false;
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        TemplateManager \u26032 = serverWorld.func_184163_y();
        try {
            return \u26032.func_200219_b(this.field_184420_a) != null;
        }
        catch (ResourceLocationException \u26033) {
            return false;
        }
    }

    public boolean func_189722_G() {
        return this.field_189727_n;
    }

    public void func_189723_d(boolean bl) {
        this.field_189727_n = bl;
    }

    public void func_189703_e(boolean bl) {
        this.field_189728_o = bl;
    }

    public void func_189710_f(boolean bl) {
        this.field_189729_p = bl;
    }

    public static enum UpdateCommand {
        UPDATE_DATA,
        SAVE_AREA,
        LOAD_AREA,
        SCAN_AREA;

    }
}

