/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.util.datafix.TypeReferences;

public class StringToUUID
extends DataFix {
    public StringToUUID(Schema schema, boolean bl) {
        super(schema, bl);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("EntityStringUuidFix", this.getInputSchema().getType(TypeReferences.field_211299_o), typed -> typed.update(DSL.remainderFinder(), dynamic2 -> {
            Dynamic dynamic2;
            Optional optional = dynamic2.get("UUID").asString();
            if (optional.isPresent()) {
                UUID uUID = UUID.fromString((String)optional.get());
                return dynamic2.remove("UUID").set("UUIDMost", dynamic2.createLong(uUID.getMostSignificantBits())).set("UUIDLeast", dynamic2.createLong(uUID.getLeastSignificantBits()));
            }
            return dynamic2;
        }));
    }
}

