/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JigsawManager {
    private static final Logger field_214892_b = LogManager.getLogger();
    public static final JigsawPatternRegistry field_214891_a = new JigsawPatternRegistry();

    public static void func_214889_a(ResourceLocation resourceLocation, int n, IPieceFactory iPieceFactory, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, BlockPos blockPos, List<StructurePiece> list, Random random) {
        Structures.func_215140_a();
        new Assembler(resourceLocation, n, iPieceFactory, chunkGenerator, templateManager, blockPos, list, random);
    }

    static {
        field_214891_a.func_214932_a(JigsawPattern.field_214949_a);
    }

    public static interface IPieceFactory {
        public AbstractVillagePiece create(TemplateManager var1, JigsawPiece var2, BlockPos var3, int var4, Rotation var5, MutableBoundingBox var6);
    }

    static final class Assembler {
        private final int field_214882_a;
        private final IPieceFactory field_214883_b;
        private final ChunkGenerator<?> field_214884_c;
        private final TemplateManager field_214885_d;
        private final List<StructurePiece> field_214886_e;
        private final Random field_214887_f;
        private final Deque<Entry> field_214888_g = Queues.newArrayDeque();

        public Assembler(ResourceLocation resourceLocation, int n, IPieceFactory iPieceFactory, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, BlockPos blockPos, List<StructurePiece> list, Random random) {
            this.field_214882_a = n;
            this.field_214883_b = iPieceFactory;
            this.field_214884_c = chunkGenerator;
            this.field_214885_d = templateManager;
            this.field_214886_e = list;
            this.field_214887_f = random;
            Rotation rotation = Rotation.func_222466_a(random);
            JigsawPattern \u26032 = field_214891_a.func_214933_a(resourceLocation);
            JigsawPiece \u26033 = \u26032.func_214944_a(random);
            AbstractVillagePiece \u26034 = iPieceFactory.create(templateManager, \u26033, blockPos, \u26033.func_214850_d(), rotation, \u26033.func_214852_a(templateManager, blockPos, rotation));
            MutableBoundingBox \u26035 = \u26034.func_74874_b();
            int \u26036 = (\u26035.field_78893_d + \u26035.field_78897_a) / 2;
            int \u26037 = (\u26035.field_78892_f + \u26035.field_78896_c) / 2;
            int \u26038 = chunkGenerator.func_222532_b(\u26036, \u26037, Heightmap.Type.WORLD_SURFACE_WG);
            \u26034.func_181138_a(0, \u26038 - (\u26035.field_78895_b + \u26034.func_214830_d()), 0);
            list.add(\u26034);
            if (n <= 0) {
                return;
            }
            int \u26039 = 80;
            AxisAlignedBB \u260310 = new AxisAlignedBB(\u26036 - 80, \u26038 - 80, \u26037 - 80, \u26036 + 80 + 1, \u26038 + 80 + 1, \u26037 + 80 + 1);
            this.field_214888_g.addLast(new Entry(\u26034, new AtomicReference<VoxelShape>(VoxelShapes.func_197878_a(VoxelShapes.func_197881_a(\u260310), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u26035)), IBooleanFunction.field_223234_e_)), \u26038 + 80, 0));
            while (!this.field_214888_g.isEmpty()) {
                Entry entry = this.field_214888_g.removeFirst();
                this.func_214881_a(entry.field_214876_a, entry.field_214877_b, entry.field_214878_c, entry.field_214879_d);
            }
        }

        private void func_214881_a(AbstractVillagePiece abstractVillagePiece, AtomicReference<VoxelShape> atomicReference, int n, int n2) {
            JigsawPiece jigsawPiece = abstractVillagePiece.func_214826_b();
            BlockPos \u26032 = abstractVillagePiece.func_214828_c();
            Rotation \u26033 = abstractVillagePiece.func_214809_Y_();
            JigsawPattern.PlacementBehaviour \u26034 = jigsawPiece.func_214854_c();
            boolean \u26035 = \u26034 == JigsawPattern.PlacementBehaviour.RIGID;
            AtomicReference<VoxelShape> \u26036 = new AtomicReference<VoxelShape>();
            MutableBoundingBox \u26037 = abstractVillagePiece.func_74874_b();
            int \u26038 = \u26037.field_78895_b;
            block0: for (Template.BlockInfo blockInfo2 : jigsawPiece.func_214849_a(this.field_214885_d, \u26032, \u26033, this.field_214887_f)) {
                int \u260316;
                Direction direction = blockInfo2.field_186243_b.func_177229_b(JigsawBlock.field_176387_N);
                BlockPos \u26039 = blockInfo2.field_186242_a;
                BlockPos \u260310 = \u26039.func_177972_a(direction);
                int \u260311 = \u26039.func_177956_o() - \u26038;
                int \u260312 = -1;
                JigsawPattern \u260313 = field_214891_a.func_214933_a(new ResourceLocation(blockInfo2.field_186244_c.func_74779_i("target_pool")));
                JigsawPattern \u260314 = field_214891_a.func_214933_a(\u260313.func_214948_a());
                if (\u260313 == JigsawPattern.field_214950_b || \u260313.func_214946_c() == 0 && \u260313 != JigsawPattern.field_214949_a) {
                    field_214892_b.warn("Empty or none existent pool: {}", (Object)blockInfo2.field_186244_c.func_74779_i("target_pool"));
                    continue;
                }
                boolean \u260315 = \u26037.func_175898_b(\u260310);
                if (\u260315) {
                    AtomicReference<Object> atomicReference2 = \u26036;
                    \u260316 = \u26038;
                    if (\u26036.get() == null) {
                        \u26036.set(VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u26037)));
                    }
                } else {
                    atomicReference2 = atomicReference;
                    \u260316 = n;
                }
                ArrayList arrayList = Lists.newArrayList();
                if (n2 != this.field_214882_a) {
                    arrayList.addAll(\u260313.func_214943_b(this.field_214887_f));
                }
                arrayList.addAll(\u260314.func_214943_b(this.field_214887_f));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext() && (\u2603 = (JigsawPiece)iterator.next()) != EmptyJigsawPiece.field_214856_a) {
                    for (Rotation rotation : Rotation.func_222467_b(this.field_214887_f)) {
                        List<Template.BlockInfo> list = \u2603.func_214849_a(this.field_214885_d, BlockPos.field_177992_a, rotation, this.field_214887_f);
                        MutableBoundingBox \u260317 = \u2603.func_214852_a(this.field_214885_d, BlockPos.field_177992_a, rotation);
                        int \u260318 = \u260317.func_78882_c() > 16 ? 0 : list.stream().mapToInt(blockInfo -> {
                            if (!\u260317.func_175898_b(blockInfo.field_186242_a.func_177972_a(blockInfo.field_186243_b.func_177229_b(JigsawBlock.field_176387_N)))) {
                                return 0;
                            }
                            ResourceLocation resourceLocation = new ResourceLocation(blockInfo.field_186244_c.func_74779_i("target_pool"));
                            JigsawPattern \u26032 = field_214891_a.func_214933_a(resourceLocation);
                            JigsawPattern \u26033 = field_214891_a.func_214933_a(\u26032.func_214948_a());
                            return Math.max(\u26032.func_214945_a(this.field_214885_d), \u26033.func_214945_a(this.field_214885_d));
                        }).max().orElse(0);
                        for (Template.BlockInfo blockInfo3 : list) {
                            int n3;
                            if (!JigsawBlock.func_220171_a(blockInfo2, blockInfo3)) continue;
                            BlockPos blockPos = blockInfo3.field_186242_a;
                            \u2603 = new BlockPos(\u260310.func_177958_n() - blockPos.func_177958_n(), \u260310.func_177956_o() - blockPos.func_177956_o(), \u260310.func_177952_p() - blockPos.func_177952_p());
                            MutableBoundingBox \u260319 = \u2603.func_214852_a(this.field_214885_d, \u2603, rotation);
                            int \u260320 = \u260319.field_78895_b;
                            JigsawPattern.PlacementBehaviour \u260321 = \u2603.func_214854_c();
                            boolean \u260322 = \u260321 == JigsawPattern.PlacementBehaviour.RIGID;
                            int \u260323 = blockPos.func_177956_o();
                            int \u260324 = \u260311 - \u260323 + blockInfo2.field_186243_b.func_177229_b(JigsawBlock.field_176387_N).func_96559_d();
                            if (\u26035 && \u260322) {
                                n3 = \u26038 + \u260324;
                            } else {
                                if (\u260312 == -1) {
                                    \u260312 = this.field_214884_c.func_222532_b(\u26039.func_177958_n(), \u26039.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                }
                                n3 = \u260312 - \u260323;
                            }
                            \u2603 = n3 - \u260320;
                            MutableBoundingBox \u260325 = \u260319.func_215127_b(0, \u2603, 0);
                            BlockPos \u260326 = \u2603.func_177982_a(0, \u2603, 0);
                            if (\u260318 > 0) {
                                \u2603 = Math.max(\u260318 + 1, \u260325.field_78894_e - \u260325.field_78895_b);
                                \u260325.field_78894_e = \u260325.field_78895_b + \u2603;
                            }
                            if (VoxelShapes.func_197879_c((VoxelShape)atomicReference2.get(), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u260325).func_186664_h(0.25)), IBooleanFunction.field_223232_c_)) continue;
                            atomicReference2.set(VoxelShapes.func_197882_b((VoxelShape)atomicReference2.get(), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u260325)), IBooleanFunction.field_223234_e_));
                            \u2603 = abstractVillagePiece.func_214830_d();
                            \u2603 = \u260322 ? \u2603 - \u260324 : \u2603.func_214850_d();
                            AbstractVillagePiece \u260327 = this.field_214883_b.create(this.field_214885_d, \u2603, \u260326, \u2603, rotation, \u260325);
                            if (\u26035) {
                                \u2603 = \u26038 + \u260311;
                            } else if (\u260322) {
                                \u2603 = n3 + \u260323;
                            } else {
                                if (\u260312 == -1) {
                                    \u260312 = this.field_214884_c.func_222532_b(\u26039.func_177958_n(), \u26039.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                }
                                \u2603 = \u260312 + \u260324 / 2;
                            }
                            abstractVillagePiece.func_214831_a(new JigsawJunction(\u260310.func_177958_n(), \u2603 - \u260311 + \u2603, \u260310.func_177952_p(), \u260324, \u260321));
                            \u260327.func_214831_a(new JigsawJunction(\u26039.func_177958_n(), \u2603 - \u260323 + \u2603, \u26039.func_177952_p(), -\u260324, \u26034));
                            this.field_214886_e.add(\u260327);
                            if (n2 + 1 > this.field_214882_a) continue block0;
                            this.field_214888_g.addLast(new Entry(\u260327, atomicReference2, \u260316, n2 + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class Entry {
        private final AbstractVillagePiece field_214876_a;
        private final AtomicReference<VoxelShape> field_214877_b;
        private final int field_214878_c;
        private final int field_214879_d;

        private Entry(AbstractVillagePiece abstractVillagePiece, AtomicReference<VoxelShape> atomicReference, int n, int n2) {
            this.field_214876_a = abstractVillagePiece;
            this.field_214877_b = atomicReference;
            this.field_214878_c = n;
            this.field_214879_d = n2;
        }
    }
}

