/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureIndexesSavedData;
import net.minecraft.world.storage.DimensionSavedDataManager;

public class LegacyStructureDataUtil {
    private static final Map<String, String> field_208220_b = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put("Village", "Village");
        hashMap.put("Mineshaft", "Mineshaft");
        hashMap.put("Mansion", "Mansion");
        hashMap.put("Igloo", "Temple");
        hashMap.put("Desert_Pyramid", "Temple");
        hashMap.put("Jungle_Pyramid", "Temple");
        hashMap.put("Swamp_Hut", "Temple");
        hashMap.put("Stronghold", "Stronghold");
        hashMap.put("Monument", "Monument");
        hashMap.put("Fortress", "Fortress");
        hashMap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> field_208221_c = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put("Iglu", "Igloo");
        hashMap.put("TeDP", "Desert_Pyramid");
        hashMap.put("TeJP", "Jungle_Pyramid");
        hashMap.put("TeSH", "Swamp_Hut");
    });
    private final boolean field_208222_d;
    private final Map<String, Long2ObjectMap<CompoundNBT>> field_208223_e = Maps.newHashMap();
    private final Map<String, StructureIndexesSavedData> field_208224_f = Maps.newHashMap();
    private final List<String> field_215132_f;
    private final List<String> field_215133_g;

    public LegacyStructureDataUtil(@Nullable DimensionSavedDataManager dimensionSavedDataManager, List<String> list, List<String> list2) {
        this.field_215132_f = list;
        this.field_215133_g = list2;
        this.func_212184_a(dimensionSavedDataManager);
        boolean bl = false;
        for (String string : this.field_215133_g) {
            bl |= this.field_208223_e.get(string) != null;
        }
        this.field_208222_d = bl;
    }

    public void func_208216_a(long l) {
        for (String string : this.field_215132_f) {
            StructureIndexesSavedData structureIndexesSavedData = this.field_208224_f.get(string);
            if (structureIndexesSavedData == null || !structureIndexesSavedData.func_208023_c(l)) continue;
            structureIndexesSavedData.func_201762_c(l);
            structureIndexesSavedData.func_76185_a();
        }
    }

    public CompoundNBT func_212181_a(CompoundNBT compoundNBT4) {
        CompoundNBT compoundNBT2;
        CompoundNBT compoundNBT3;
        compoundNBT3 = compoundNBT4.func_74775_l("Level");
        ChunkPos chunkPos = new ChunkPos(compoundNBT3.func_74762_e("xPos"), compoundNBT3.func_74762_e("zPos"));
        if (this.func_208209_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            CompoundNBT compoundNBT4 = this.func_212182_a(compoundNBT4, chunkPos);
        }
        compoundNBT2 = compoundNBT3.func_74775_l("Structures");
        compoundNBT5 = compoundNBT2.func_74775_l("References");
        for (String string : this.field_215133_g) {
            CompoundNBT compoundNBT5;
            Structure structure = (Structure)Feature.field_202300_at.get((Object)string.toLowerCase(Locale.ROOT));
            if (compoundNBT5.func_150297_b(string, 12) || structure == null) continue;
            int \u26032 = structure.func_202367_b();
            LongArrayList \u26033 = new LongArrayList();
            for (int i = chunkPos.field_77276_a - \u26032; i <= chunkPos.field_77276_a + \u26032; ++i) {
                for (\u2603 = chunkPos.field_77275_b - \u26032; \u2603 <= chunkPos.field_77275_b + \u26032; ++\u2603) {
                    if (!this.func_208211_a(i, \u2603, string)) continue;
                    \u26033.add(ChunkPos.func_77272_a(i, \u2603));
                }
            }
            compoundNBT5.func_202168_c(string, (List<Long>)\u26033);
        }
        compoundNBT2.func_218657_a("References", compoundNBT5);
        compoundNBT3.func_218657_a("Structures", compoundNBT2);
        compoundNBT4.func_218657_a("Level", compoundNBT3);
        return compoundNBT4;
    }

    private boolean func_208211_a(int n, int n2, String string) {
        if (!this.field_208222_d) {
            return false;
        }
        return this.field_208223_e.get(string) != null && this.field_208224_f.get(field_208220_b.get(string)).func_208024_b(ChunkPos.func_77272_a(n, n2));
    }

    private boolean func_208209_a(int n, int n2) {
        if (!this.field_208222_d) {
            return false;
        }
        for (String string : this.field_215133_g) {
            if (this.field_208223_e.get(string) == null || !this.field_208224_f.get(field_208220_b.get(string)).func_208023_c(ChunkPos.func_77272_a(n, n2))) continue;
            return true;
        }
        return false;
    }

    private CompoundNBT func_212182_a(CompoundNBT compoundNBT, ChunkPos chunkPos) {
        CompoundNBT compoundNBT2 = compoundNBT.func_74775_l("Level");
        \u2603 = compoundNBT2.func_74775_l("Structures");
        \u2603 = \u2603.func_74775_l("Starts");
        for (String string : this.field_215133_g) {
            Long2ObjectMap<CompoundNBT> long2ObjectMap = this.field_208223_e.get(string);
            if (long2ObjectMap == null) continue;
            long \u26032 = chunkPos.func_201841_a();
            if (!this.field_208224_f.get(field_208220_b.get(string)).func_208023_c(\u26032) || (\u2603 = (CompoundNBT)long2ObjectMap.get(\u26032)) == null) continue;
            \u2603.func_218657_a(string, \u2603);
        }
        \u2603.func_218657_a("Starts", \u2603);
        compoundNBT2.func_218657_a("Structures", \u2603);
        compoundNBT.func_218657_a("Level", compoundNBT2);
        return compoundNBT;
    }

    private void func_212184_a(@Nullable DimensionSavedDataManager dimensionSavedDataManager) {
        if (dimensionSavedDataManager == null) {
            return;
        }
        for (String string22 : this.field_215132_f) {
            CompoundNBT compoundNBT = new CompoundNBT();
            try {
                compoundNBT = dimensionSavedDataManager.func_215755_a(string22, 1493).func_74775_l("data").func_74775_l("Features");
                if (compoundNBT.isEmpty()) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String string2 : compoundNBT.func_150296_c()) {
                String string3;
                CompoundNBT object = compoundNBT.func_74775_l(string2);
                long l = ChunkPos.func_77272_a(object.func_74762_e("ChunkX"), object.func_74762_e("ChunkZ"));
                ListNBT \u26032 = object.func_150295_c("Children", 10);
                if (!\u26032.isEmpty() && (string3 = field_208221_c.get(\u2603 = \u26032.func_150305_b(0).func_74779_i("id"))) != null) {
                    object.func_74778_a("id", string3);
                }
                String \u26033 = object.func_74779_i("id");
                this.field_208223_e.computeIfAbsent(\u26033, string -> new Long2ObjectOpenHashMap()).put(l, (Object)object);
            }
            String string3 = string22 + "_index";
            StructureIndexesSavedData structureIndexesSavedData = dimensionSavedDataManager.func_215752_a(() -> new StructureIndexesSavedData(string3), string3);
            if (structureIndexesSavedData.func_208025_a().isEmpty()) {
                StructureIndexesSavedData structureIndexesSavedData2 = new StructureIndexesSavedData(string3);
                this.field_208224_f.put(string22, structureIndexesSavedData2);
                for (String string4 : compoundNBT.func_150296_c()) {
                    CompoundNBT compoundNBT2 = compoundNBT.func_74775_l(string4);
                    structureIndexesSavedData2.func_201763_a(ChunkPos.func_77272_a(compoundNBT2.func_74762_e("ChunkX"), compoundNBT2.func_74762_e("ChunkZ")));
                }
                structureIndexesSavedData2.func_76185_a();
                continue;
            }
            this.field_208224_f.put(string22, structureIndexesSavedData);
        }
    }

    public static LegacyStructureDataUtil func_215130_a(DimensionType dimensionType2, @Nullable DimensionSavedDataManager dimensionSavedDataManager) {
        DimensionType dimensionType2;
        if (dimensionType2 == DimensionType.field_223227_a_) {
            return new LegacyStructureDataUtil(dimensionSavedDataManager, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (dimensionType2 == DimensionType.field_223228_b_) {
            ImmutableList immutableList = ImmutableList.of((Object)"Fortress");
            return new LegacyStructureDataUtil(dimensionSavedDataManager, (List<String>)immutableList, (List<String>)immutableList);
        }
        if (dimensionType2 == DimensionType.field_223229_c_) {
            ImmutableList immutableList = ImmutableList.of((Object)"EndCity");
            return new LegacyStructureDataUtil(dimensionSavedDataManager, (List<String>)immutableList, (List<String>)immutableList);
        }
        throw new RuntimeException(String.format("Unknown dimension type : %s", dimensionType2));
    }
}

