/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemplateManager
implements IResourceManagerReloadListener {
    private static final Logger field_195431_a = LogManager.getLogger();
    private final Map<ResourceLocation, Template> field_186240_a = Maps.newHashMap();
    private final DataFixer field_191154_c;
    private final MinecraftServer field_195432_d;
    private final Path field_195433_e;

    public TemplateManager(MinecraftServer minecraftServer, File file, DataFixer dataFixer) {
        this.field_195432_d = minecraftServer;
        this.field_191154_c = dataFixer;
        this.field_195433_e = file.toPath().resolve("generated").normalize();
        minecraftServer.func_195570_aG().func_219534_a(this);
    }

    public Template func_200220_a(ResourceLocation resourceLocation) {
        Template template = this.func_200219_b(resourceLocation);
        if (template == null) {
            template = new Template();
            this.field_186240_a.put(resourceLocation, template);
        }
        return template;
    }

    @Nullable
    public Template func_200219_b(ResourceLocation resourceLocation2) {
        return this.field_186240_a.computeIfAbsent(resourceLocation2, resourceLocation -> {
            Template template = this.func_195428_d((ResourceLocation)resourceLocation);
            return template != null ? template : this.func_209201_e((ResourceLocation)resourceLocation);
        });
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_186240_a.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Template func_209201_e(ResourceLocation resourceLocation) {
        ResourceLocation resourceLocation2 = new ResourceLocation(resourceLocation.func_110624_b(), "structures/" + resourceLocation.func_110623_a() + ".nbt");
        try (IResource iResource = this.field_195432_d.func_195570_aG().func_199002_a(resourceLocation2);){
            Template template = this.func_209205_a(iResource.func_199027_b());
            return template;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Throwable throwable6) {
            field_195431_a.error("Couldn't load structure {}: {}", (Object)resourceLocation, (Object)throwable6.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Template func_195428_d(ResourceLocation resourceLocation) {
        if (!this.field_195433_e.toFile().isDirectory()) {
            return null;
        }
        Path path = this.func_209510_b(resourceLocation, ".nbt");
        try (FileInputStream \u26032 = new FileInputStream(path.toFile());){
            Template template = this.func_209205_a(\u26032);
            return template;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            field_195431_a.error("Couldn't load structure from {}", (Object)path, (Object)iOException);
            return null;
        }
    }

    private Template func_209205_a(InputStream inputStream) throws IOException {
        CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(inputStream);
        return this.func_227458_a_(compoundNBT);
    }

    public Template func_227458_a_(CompoundNBT compoundNBT) {
        if (!compoundNBT.func_150297_b("DataVersion", 99)) {
            compoundNBT.func_74768_a("DataVersion", 500);
        }
        Template template = new Template();
        template.func_186256_b(NBTUtil.func_210822_a(this.field_191154_c, DefaultTypeReferences.STRUCTURE, compoundNBT, compoundNBT.func_74762_e("DataVersion")));
        return template;
    }

    public boolean func_195429_b(ResourceLocation resourceLocation) {
        Template template = this.field_186240_a.get(resourceLocation);
        if (template == null) {
            return false;
        }
        Path \u26032 = this.func_209510_b(resourceLocation, ".nbt");
        Path \u26033 = \u26032.getParent();
        if (\u26033 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(\u26033, new LinkOption[0]) ? \u26033.toRealPath(new LinkOption[0]) : \u26033, new FileAttribute[0]);
        }
        catch (IOException \u26034) {
            field_195431_a.error("Failed to create parent directory: {}", (Object)\u26033);
            return false;
        }
        CompoundNBT \u26035 = template.func_189552_a(new CompoundNBT());
        try (FileOutputStream fileOutputStream = new FileOutputStream(\u26032.toFile());){
            CompressedStreamTools.func_74799_a(\u26035, fileOutputStream);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public Path func_209509_a(ResourceLocation resourceLocation, String string) {
        try {
            Path path = this.field_195433_e.resolve(resourceLocation.func_110624_b());
            \u2603 = path.resolve("structures");
            return FileUtil.func_214993_b(\u2603, resourceLocation.func_110623_a(), string);
        }
        catch (InvalidPathException invalidPathException) {
            throw new ResourceLocationException("Invalid resource path: " + resourceLocation, invalidPathException);
        }
    }

    private Path func_209510_b(ResourceLocation resourceLocation, String string) {
        if (resourceLocation.func_110623_a().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + resourceLocation);
        }
        Path path = this.func_209509_a(resourceLocation, string);
        if (!(path.startsWith(this.field_195433_e) && FileUtil.func_214995_a(path) && FileUtil.func_214994_b(path))) {
            throw new ResourceLocationException("Invalid resource path: " + path);
        }
        return path;
    }

    public void func_189941_a(ResourceLocation resourceLocation) {
        this.field_186240_a.remove(resourceLocation);
    }
}

