/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionSavedDataManager {
    private static final Logger field_212776_a = LogManager.getLogger();
    private final Map<String, WorldSavedData> field_212778_c = Maps.newHashMap();
    private final DataFixer field_215758_c;
    private final File field_215759_d;

    public DimensionSavedDataManager(File file, DataFixer dataFixer) {
        this.field_215758_c = dataFixer;
        this.field_215759_d = file;
    }

    private File func_215754_a(String string) {
        return new File(this.field_215759_d, string + ".dat");
    }

    public <T extends WorldSavedData> T func_215752_a(Supplier<T> supplier, String string) {
        T t = this.func_215753_b(supplier, string);
        if (t != null) {
            return t;
        }
        WorldSavedData \u26032 = (WorldSavedData)supplier.get();
        this.func_215757_a(\u26032);
        return (T)\u26032;
    }

    @Nullable
    public <T extends WorldSavedData> T func_215753_b(Supplier<T> supplier, String string) {
        WorldSavedData worldSavedData = this.field_212778_c.get(string);
        if (worldSavedData == null && !this.field_212778_c.containsKey(string)) {
            worldSavedData = this.func_223409_c(supplier, string);
            this.field_212778_c.put(string, worldSavedData);
        }
        return (T)worldSavedData;
    }

    @Nullable
    private <T extends WorldSavedData> T func_223409_c(Supplier<T> supplier, String string) {
        try {
            File file = this.func_215754_a(string);
            if (file.exists()) {
                WorldSavedData worldSavedData = (WorldSavedData)supplier.get();
                CompoundNBT \u26032 = this.func_215755_a(string, SharedConstants.func_215069_a().getWorldVersion());
                worldSavedData.func_76184_a(\u26032.func_74775_l("data"));
                return (T)worldSavedData;
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Error loading saved data: {}", (Object)string, (Object)exception);
        }
        return null;
    }

    public void func_215757_a(WorldSavedData worldSavedData) {
        this.field_212778_c.put(worldSavedData.func_195925_e(), worldSavedData);
    }

    public CompoundNBT func_215755_a(String string, int n) throws IOException {
        File file = this.func_215754_a(string);
        try (PushbackInputStream \u26032 = new PushbackInputStream(new FileInputStream(file), 2);){
            Object object;
            CompoundNBT compoundNBT;
            if (this.func_215756_a(\u26032)) {
                compoundNBT = CompressedStreamTools.func_74796_a(\u26032);
            } else {
                DataInputStream dataInputStream = new DataInputStream(\u26032);
                object = null;
                try {
                    compoundNBT = CompressedStreamTools.func_74794_a(dataInputStream);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataInputStream != null) {
                        if (object != null) {
                            try {
                                dataInputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataInputStream.close();
                        }
                    }
                }
            }
            int \u26033 = compoundNBT.func_150297_b("DataVersion", 99) ? compoundNBT.func_74762_e("DataVersion") : 1343;
            object = NBTUtil.func_210821_a(this.field_215758_c, DefaultTypeReferences.SAVED_DATA, compoundNBT, \u26033, n);
            return object;
        }
    }

    private boolean func_215756_a(PushbackInputStream pushbackInputStream) throws IOException {
        byte[] byArray = new byte[2];
        boolean \u26032 = false;
        int \u26033 = pushbackInputStream.read(byArray, 0, 2);
        if (\u26033 == 2 && (\u2603 = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) == 35615) {
            \u26032 = true;
        }
        if (\u26033 != 0) {
            pushbackInputStream.unread(byArray, 0, \u26033);
        }
        return \u26032;
    }

    public void func_212775_b() {
        for (WorldSavedData worldSavedData : this.field_212778_c.values()) {
            if (worldSavedData == null) continue;
            worldSavedData.func_215158_a(this.func_215754_a(worldSavedData.func_195925_e()));
        }
    }
}

