/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.AnvilSaveConverter;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormat {
    private static final Logger field_215785_a = LogManager.getLogger();
    private static final DateTimeFormatter field_197716_d = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Path field_215786_c;
    private final Path field_215787_d;
    private final DataFixer field_215788_e;

    public SaveFormat(Path path, Path path2, DataFixer dataFixer) {
        this.field_215788_e = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_215786_c = path;
        this.field_215787_d = path2;
    }

    private int func_215782_e() {
        return 19133;
    }

    public SaveHandler func_197715_a(String string, @Nullable MinecraftServer minecraftServer) {
        return SaveFormat.func_215783_a(this.field_215786_c, this.field_215788_e, string, minecraftServer);
    }

    protected static SaveHandler func_215783_a(Path path, DataFixer dataFixer, String string, @Nullable MinecraftServer minecraftServer) {
        return new SaveHandler(path.toFile(), string, minecraftServer, dataFixer);
    }

    public boolean func_75801_b(String string) {
        WorldInfo worldInfo = this.func_75803_c(string);
        return worldInfo != null && worldInfo.func_76088_k() != this.func_215782_e();
    }

    public boolean func_75805_a(String string, IProgressUpdate iProgressUpdate) {
        return AnvilSaveConverter.func_215792_a(this.field_215786_c, this.field_215788_e, string, iProgressUpdate);
    }

    @Nullable
    public WorldInfo func_75803_c(String string) {
        return SaveFormat.func_215779_a(this.field_215786_c, this.field_215788_e, string);
    }

    @Nullable
    protected static WorldInfo func_215779_a(Path path, DataFixer dataFixer, String string) {
        File file = new File(path.toFile(), string);
        if (!file.exists()) {
            return null;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists() && (\u2603 = SaveFormat.func_215780_a(\u2603, dataFixer)) != null) {
            return \u2603;
        }
        \u2603 = new File(file, "level.dat_old");
        if (\u2603.exists()) {
            return SaveFormat.func_215780_a(\u2603, dataFixer);
        }
        return null;
    }

    @Nullable
    public static WorldInfo func_215780_a(File file, DataFixer dataFixer) {
        try {
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            \u2603 = compoundNBT.func_74775_l("Data");
            \u2603 = \u2603.func_150297_b("Player", 10) ? \u2603.func_74775_l("Player") : null;
            \u2603.func_82580_o("Player");
            int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
            return new WorldInfo(NBTUtil.func_210822_a(dataFixer, DefaultTypeReferences.LEVEL, \u2603, \u26032), dataFixer, \u26032, \u2603);
        }
        catch (Exception exception) {
            field_215785_a.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    public File func_186352_b(String string, String string2) {
        return this.field_215786_c.resolve(string).resolve(string2).toFile();
    }
}

