/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class CopyBlockState
extends LootFunction {
    private final Block field_227543_a_;
    private final Set<IProperty<?>> field_227544_c_;

    private CopyBlockState(ILootCondition[] iLootConditionArray, Block block, Set<IProperty<?>> set) {
        super(iLootConditionArray);
        this.field_227543_a_ = block;
        this.field_227544_c_ = set;
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_216287_g);
    }

    @Override
    protected ItemStack func_215859_a(ItemStack itemStack2, LootContext lootContext) {
        ItemStack itemStack2;
        BlockState blockState = lootContext.func_216031_c(LootParameters.field_216287_g);
        if (blockState != null) {
            CompoundNBT compoundNBT = itemStack2.func_196082_o();
            if (compoundNBT.func_150297_b("BlockStateTag", 10)) {
                \u2603 = compoundNBT.func_74775_l("BlockStateTag");
            } else {
                \u2603 = new CompoundNBT();
                compoundNBT.func_218657_a("BlockStateTag", \u2603);
            }
            this.field_227544_c_.stream().filter(blockState::func_196959_b).forEach(iProperty -> \u2603.func_74778_a(iProperty.func_177701_a(), CopyBlockState.func_227546_a_(blockState, iProperty)));
        }
        return itemStack2;
    }

    public static Builder func_227545_a_(Block block) {
        return new Builder(block);
    }

    private static <T extends Comparable<T>> String func_227546_a_(BlockState blockState, IProperty<T> iProperty) {
        T t = blockState.func_177229_b(iProperty);
        return iProperty.func_177702_a(t);
    }

    public static class Serializer
    extends LootFunction.Serializer<CopyBlockState> {
        public Serializer() {
            super(new ResourceLocation("copy_state"), CopyBlockState.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject, CopyBlockState copyBlockState, JsonSerializationContext jsonSerializationContext) {
            super.func_186532_a(jsonObject, copyBlockState, jsonSerializationContext);
            jsonObject.addProperty("block", Registry.field_212618_g.func_177774_c(copyBlockState.field_227543_a_).toString());
            JsonArray jsonArray = new JsonArray();
            copyBlockState.field_227544_c_.forEach(iProperty -> jsonArray.add(iProperty.func_177701_a()));
            jsonObject.add("properties", (JsonElement)jsonArray);
        }

        @Override
        public CopyBlockState func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "block"));
            Block \u26032 = (Block)Registry.field_212618_g.func_218349_b(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Can't find block " + resourceLocation));
            StateContainer<Block, BlockState> \u26033 = \u26032.func_176194_O();
            HashSet \u26034 = Sets.newHashSet();
            JsonArray \u26035 = JSONUtils.func_151213_a(jsonObject, "properties", null);
            if (\u26035 != null) {
                \u26035.forEach(jsonElement -> \u26034.add(\u26033.func_185920_a(JSONUtils.func_151206_a(jsonElement, "property"))));
            }
            return new CopyBlockState(iLootConditionArray, \u26032, \u26034);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final Block field_227550_a_;
        private final Set<IProperty<?>> field_227551_b_ = Sets.newHashSet();

        private Builder(Block block) {
            this.field_227550_a_ = block;
        }

        public Builder func_227552_a_(IProperty<?> iProperty) {
            if (!this.field_227550_a_.func_176194_O().func_177623_d().contains(iProperty)) {
                throw new IllegalStateException("Property " + iProperty + " is not present on block " + this.field_227550_a_);
            }
            this.field_227551_b_.add(iProperty);
            return this;
        }

        @Override
        protected Builder func_212826_d_() {
            return this;
        }

        @Override
        public ILootFunction func_216052_b() {
            return new CopyBlockState(this.func_216053_g(), this.field_227550_a_, this.field_227551_b_);
        }

        @Override
        protected /* synthetic */ LootFunction.Builder func_212826_d_() {
            return this.func_212826_d_();
        }
    }
}

