/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class SetAttributes
extends LootFunction {
    private final List<Modifier> field_186561_b;

    private SetAttributes(ILootCondition[] iLootConditionArray, List<Modifier> list) {
        super(iLootConditionArray);
        this.field_186561_b = ImmutableList.copyOf(list);
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        Random random = lootContext.func_216032_b();
        for (Modifier modifier : this.field_186561_b) {
            UUID uUID = modifier.field_186600_e;
            if (uUID == null) {
                uUID = UUID.randomUUID();
            }
            EquipmentSlotType \u26032 = modifier.field_186601_f[random.nextInt(modifier.field_186601_f.length)];
            itemStack.func_185129_a(modifier.field_186597_b, new AttributeModifier(uUID, modifier.field_186596_a, (double)modifier.field_186599_d.func_186507_b(random), modifier.field_186598_c), \u26032);
        }
        return itemStack;
    }

    static class Modifier {
        private final String field_186596_a;
        private final String field_186597_b;
        private final AttributeModifier.Operation field_186598_c;
        private final RandomValueRange field_186599_d;
        @Nullable
        private final UUID field_186600_e;
        private final EquipmentSlotType[] field_186601_f;

        private Modifier(String string, String string2, AttributeModifier.Operation operation, RandomValueRange randomValueRange, EquipmentSlotType[] equipmentSlotTypeArray, @Nullable UUID uUID) {
            this.field_186596_a = string;
            this.field_186597_b = string2;
            this.field_186598_c = operation;
            this.field_186599_d = randomValueRange;
            this.field_186600_e = uUID;
            this.field_186601_f = equipmentSlotTypeArray;
        }

        public JsonObject func_186592_a(JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", this.field_186596_a);
            jsonObject.addProperty("attribute", this.field_186597_b);
            jsonObject.addProperty("operation", Modifier.func_216244_a(this.field_186598_c));
            jsonObject.add("amount", jsonSerializationContext.serialize((Object)this.field_186599_d));
            if (this.field_186600_e != null) {
                jsonObject.addProperty("id", this.field_186600_e.toString());
            }
            if (this.field_186601_f.length == 1) {
                jsonObject.addProperty("slot", this.field_186601_f[0].func_188450_d());
            } else {
                JsonArray jsonArray = new JsonArray();
                for (EquipmentSlotType equipmentSlotType : this.field_186601_f) {
                    jsonArray.add((JsonElement)new JsonPrimitive(equipmentSlotType.func_188450_d()));
                }
                jsonObject.add("slot", (JsonElement)jsonArray);
            }
            return jsonObject;
        }

        public static Modifier func_186586_a(JsonObject jsonObject2, JsonDeserializationContext jsonDeserializationContext) {
            Object object;
            JsonObject jsonObject2;
            EquipmentSlotType[] \u26035;
            String string = JSONUtils.func_151200_h(jsonObject2, "name");
            \u2603 = JSONUtils.func_151200_h(jsonObject2, "attribute");
            AttributeModifier.Operation \u26032 = Modifier.func_216246_a(JSONUtils.func_151200_h(jsonObject2, "operation"));
            RandomValueRange \u26033 = JSONUtils.func_188174_a(jsonObject2, "amount", jsonDeserializationContext, RandomValueRange.class);
            UUID \u26034 = null;
            if (JSONUtils.func_151205_a(jsonObject2, "slot")) {
                \u26035 = new EquipmentSlotType[]{EquipmentSlotType.func_188451_a(JSONUtils.func_151200_h(jsonObject2, "slot"))};
            } else if (JSONUtils.func_151202_d(jsonObject2, "slot")) {
                object = JSONUtils.func_151214_t(jsonObject2, "slot");
                \u26035 = new EquipmentSlotType[object.size()];
                int \u26036 = 0;
                for (JsonElement jsonElement : object) {
                    \u26035[\u26036++] = EquipmentSlotType.func_188451_a(JSONUtils.func_151206_a(jsonElement, "slot"));
                }
                if (\u26035.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            } else {
                throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
            }
            if (jsonObject2.has("id")) {
                object = JSONUtils.func_151200_h(jsonObject2, "id");
                try {
                    \u26034 = UUID.fromString((String)object);
                }
                catch (IllegalArgumentException \u26037) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + (String)object + "' (must be UUID format, with dashes)");
                }
            }
            return new Modifier(string, \u2603, \u26032, \u26033, \u26035, \u26034);
        }

        private static String func_216244_a(AttributeModifier.Operation operation) {
            switch (operation) {
                case ADDITION: {
                    return "addition";
                }
                case MULTIPLY_BASE: {
                    return "multiply_base";
                }
                case MULTIPLY_TOTAL: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + (Object)((Object)operation));
        }

        private static AttributeModifier.Operation func_216246_a(String string) {
            switch (string) {
                case "addition": {
                    return AttributeModifier.Operation.ADDITION;
                }
                case "multiply_base": {
                    return AttributeModifier.Operation.MULTIPLY_BASE;
                }
                case "multiply_total": {
                    return AttributeModifier.Operation.MULTIPLY_TOTAL;
                }
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + string);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<SetAttributes> {
        public Serializer() {
            super(new ResourceLocation("set_attributes"), SetAttributes.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject2, SetAttributes setAttributes, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject2;
            super.func_186532_a(jsonObject2, setAttributes, jsonSerializationContext);
            JsonArray jsonArray = new JsonArray();
            for (Modifier modifier : setAttributes.field_186561_b) {
                jsonArray.add((JsonElement)modifier.func_186592_a(jsonSerializationContext));
            }
            jsonObject2.add("modifiers", (JsonElement)jsonArray);
        }

        @Override
        public SetAttributes func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray2) {
            ILootCondition[] iLootConditionArray2;
            JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "modifiers");
            ArrayList \u26032 = Lists.newArrayListWithExpectedSize((int)jsonArray.size());
            for (JsonElement jsonElement : jsonArray) {
                \u26032.add(Modifier.func_186586_a(JSONUtils.func_151210_l(jsonElement, "modifier"), jsonDeserializationContext));
            }
            if (\u26032.isEmpty()) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new SetAttributes(iLootConditionArray2, \u26032);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }
}

