/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public abstract class SimpleModelFontRenderer
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    private final TransformationMatrix transform;
    private ImmutableList.Builder<BakedQuad> builder = ImmutableList.builder();
    private final Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Direction orientation;
    private boolean fillBlanks = false;
    private TextureAtlasSprite sprite;
    private final Vector4f vec = new Vector4f();

    public SimpleModelFontRenderer(GameSettings settings, ResourceLocation font, TextureManager manager, boolean isUnicode, Matrix4f matrix) {
        super(manager, null);
        this.transform = new TransformationMatrix(matrix);
        this.transform.transformNormal(this.normal);
        this.orientation = Direction.func_176737_a((float)this.normal.func_195899_a(), (float)this.normal.func_195900_b(), (float)this.normal.func_195902_c());
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void setFillBlanks(boolean fillBlanks) {
        this.fillBlanks = fillBlanks;
    }

    private void addVertex(BakedQuadBuilder quadBuilder, float x, float y, float u, float v) {
        ImmutableList elements = quadBuilder.getVertexFormat().func_227894_c_();
        block6: for (int e = 0; e < elements.size(); ++e) {
            VertexFormatElement element = (VertexFormatElement)elements.get(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    this.vec.func_195911_a(x, y, 0.0f, 1.0f);
                    this.transform.transformPosition(this.vec);
                    quadBuilder.put(e, this.vec.func_195910_a(), this.vec.func_195913_b(), this.vec.func_195914_c(), this.vec.func_195915_d());
                    continue block6;
                }
                case COLOR: {
                    quadBuilder.put(e, this.r, this.g, this.b, this.a);
                    continue block6;
                }
                case NORMAL: {
                    quadBuilder.put(e, 0.0f, 0.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case UV: {
                    if (element.func_177369_e() == 0) {
                        quadBuilder.put(e, this.sprite.func_94214_a((double)(u * 16.0f)), this.sprite.func_94207_b((double)(v * 16.0f)), 0.0f, 1.0f);
                        continue block6;
                    }
                }
                default: {
                    quadBuilder.put(e, new float[0]);
                }
            }
        }
    }

    public ImmutableList<BakedQuad> build() {
        ImmutableList ret = this.builder.build();
        this.builder = ImmutableList.builder();
        return ret;
    }
}

