/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.model.animation.CapabilityAnimation;

public final class AnimationItemOverrideList
extends ItemOverrideList {
    private final ModelBakery bakery;
    private final IUnbakedModel model;
    private final ResourceLocation modelLoc;
    private final IModelTransform state;
    private final Function<Material, TextureAtlasSprite> bakedTextureGetter;

    public AnimationItemOverrideList(ModelBakery bakery, IUnbakedModel model, ResourceLocation modelLoc, IModelTransform state, Function<Material, TextureAtlasSprite> bakedTextureGetter, ItemOverrideList overrides) {
        this(bakery, model, modelLoc, state, bakedTextureGetter, (List<ItemOverride>)overrides.getOverrides().reverse());
    }

    public AnimationItemOverrideList(ModelBakery bakery, IUnbakedModel model, ResourceLocation modelLoc, IModelTransform state, Function<Material, TextureAtlasSprite> bakedTextureGetter, List<ItemOverride> overrides) {
        super(bakery, model, ModelLoader.defaultModelGetter(), bakedTextureGetter, overrides);
        this.bakery = bakery;
        this.model = model;
        this.modelLoc = modelLoc;
        this.state = state;
        this.bakedTextureGetter = bakedTextureGetter;
    }

    public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        return stack.getCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null).map(asm -> {
            World w = world;
            if (w == null && entity != null) {
                w = entity.field_70170_p;
            }
            if (world == null) {
                w = Minecraft.func_71410_x().field_71441_e;
            }
            return (IModelTransform)asm.apply(Animation.getWorldTime(world, Animation.getPartialTickTime())).getLeft();
        }).map(state -> this.model.func_225613_a_(this.bakery, this.bakedTextureGetter, (IModelTransform)new ModelTransformComposition((IModelTransform)state, this.state), this.modelLoc)).orElseGet(() -> super.func_209581_a(originalModel, stack, world, entity));
    }
}

