/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import io.izzel.arclight.common.bridge.bukkit.CraftServerBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.server.ServerChunkProviderBridge;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_15_R1.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_15_R1.util.permissions.CraftDefaultPermissions;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.util.permissions.DefaultPermissions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftServer.class}, remap=false)
public abstract class CraftServerMixin
implements CraftServerBridge {
    @Shadow(remap=false)
    @Final
    private CraftCommandMap commandMap;
    @Shadow(remap=false)
    @Final
    private SimplePluginManager pluginManager;
    @Shadow(remap=false)
    @Final
    private SimpleHelpMap helpMap;
    @Shadow(remap=false)
    @Final
    protected DedicatedServer console;
    @Shadow(remap=false)
    @Final
    @Mutable
    private String serverName;
    @Shadow(remap=false)
    @Final
    @Mutable
    protected DedicatedPlayerList playerList;
    @Shadow
    @Final
    private Map<String, World> worlds;
    @Shadow
    @Final
    private Logger logger;
    @Mutable
    @Shadow
    @Final
    private List<CraftPlayer> playerView;

    @Shadow(remap=false)
    protected abstract void enablePlugin(Plugin var1);

    @Shadow(remap=false)
    protected abstract void loadCustomPermissions();

    @Accessor(value="logger", remap=false)
    @Mutable
    public abstract void setLogger(Logger var1);

    @Shadow
    public abstract World getWorld(UUID var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$setBrand(DedicatedServer console, PlayerList playerList, CallbackInfo ci) {
        this.serverName = "Arclight";
    }

    @Overwrite(remap=false)
    public String getName() {
        return "Arclight";
    }

    @Overwrite(remap=false)
    public ConsoleReader getReader() {
        try {
            return new ConsoleReader();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Overwrite(remap=false)
    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.setFallbackCommands();
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CraftDefaultPermissions.registerCorePermissions();
            this.loadCustomPermissions();
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    @Overwrite(remap=false)
    private void syncCommands() {
        Commands dispatcher = this.console.func_195571_aL();
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            new BukkitCommandWrapper((CraftServer)((Object)this), command).register((CommandDispatcher<CommandSource>)dispatcher.func_197054_a(), label);
        }
    }

    @Override
    public void bridge$updatePlayerList(PlayerList playerList) {
        this.playerList = (DedicatedPlayerList)playerList;
        this.playerView = Collections.unmodifiableList(Lists.transform(playerList.field_72404_b, player -> ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity()));
    }

    @Overwrite
    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        ServerWorld handle = ((CraftWorld)world).getHandle();
        if (!this.console.field_71305_c.containsKey(handle.func_201675_m().func_186058_p())) {
            return false;
        }
        if (handle.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            return false;
        }
        if (handle.func_217369_A().size() > 0) {
            return false;
        }
        WorldUnloadEvent e = new WorldUnloadEvent(((WorldBridge)handle).bridge$getWorld());
        this.pluginManager.callEvent(e);
        if (e.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.func_217445_a(null, true, true);
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)handle));
            ((ServerChunkProviderBridge)handle.func_72863_F()).bridge$close(save);
        }
        catch (Exception var6) {
            this.logger.log(Level.SEVERE, null, var6);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ENGLISH));
        this.console.markWorldsDirty();
        this.console.field_71305_c.remove(handle.func_201675_m().func_186058_p());
        return true;
    }

    @Override
    public void bridge$removeWorld(ServerWorld world) {
        if (world == null) {
            return;
        }
        this.worlds.remove(((WorldBridge)world).bridge$getWorld().getName().toLowerCase(Locale.ROOT));
    }
}

