/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.bridge.bukkit.EntityTypeBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.i18n.LocalizedException;
import io.izzel.arclight.i18n.conf.EntityPropertySpec;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityType.class}, remap=false)
public class EntityTypeMixin
implements EntityTypeBridge {
    @Shadow
    @Final
    @Mutable
    private NamespacedKey key;
    @Shadow
    @Final
    @Mutable
    private Class<? extends org.bukkit.entity.Entity> clazz;
    @Shadow
    @Final
    @Mutable
    private String name;
    private net.minecraft.entity.EntityType<?> handleType;
    private EntityPropertySpec spec;
    private Function<Location, ? extends Entity> factory;

    @Override
    public void bridge$setup(ResourceLocation location, net.minecraft.entity.EntityType<?> entityType, EntityPropertySpec spec) {
        this.key = CraftNamespacedKey.fromMinecraft(location);
        this.name = location.toString();
        this.handleType = entityType;
        this.spec = spec.clone();
        this.setup();
    }

    private void setup() {
        if (this.spec.entityClass != null) {
            try {
                Class<?> cl = Class.forName(this.spec.entityClass);
                if (!org.bukkit.entity.Entity.class.isAssignableFrom(cl)) {
                    throw LocalizedException.checked("registry.entity.not-subclass", cl, org.bukkit.entity.Entity.class);
                }
                this.clazz = cl;
            }
            catch (Exception e) {
                if (e instanceof LocalizedException) {
                    ArclightMod.LOGGER.warn(((LocalizedException)((Object)e)).node(), ((LocalizedException)((Object)e)).args());
                }
                ArclightMod.LOGGER.warn("registry.entity.error", (Object)this, (Object)this.spec.entityClass, (Object)e);
            }
        }
        this.factory = loc -> {
            if (loc != null && loc.getWorld() != null) {
                ServerWorld world = ((CraftWorld)loc.getWorld()).getHandle();
                Entity entity = this.handleType.func_200721_a((World)world);
                if (entity != null) {
                    entity.func_70080_a(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
                }
                return entity;
            }
            return null;
        };
    }

    @Override
    public net.minecraft.entity.EntityType<?> bridge$getHandle() {
        return this.handleType;
    }

    @Override
    public EntityPropertySpec bridge$getSpec() {
        return this.spec;
    }

    @Override
    public Function<Location, ? extends Entity> bridge$entityFactory() {
        return this.factory;
    }

    @Override
    public void bridge$setEntityFactory(Function<Location, ? extends Entity> function) {
        this.factory = function;
    }
}

