/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.entity.EntityMixin;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge {
    @Shadow
    protected int field_70718_bc;
    @Shadow
    public PlayerEntity field_70717_bb;
    @Shadow
    public int field_70725_aQ;
    @Shadow
    protected boolean field_70729_aU;
    @Shadow
    public boolean field_70752_e;
    @Shadow
    @Final
    public static DataParameter<Float> field_184632_c;
    @Shadow
    protected int field_70708_bq;
    @Shadow
    public float field_70721_aZ;
    @Shadow
    public float field_110153_bc;
    @Shadow
    public int field_70738_aO;
    @Shadow
    public int field_70737_aN;
    @Shadow
    public float field_70739_aP;
    @Shadow
    private DamageSource field_189750_bF;
    @Shadow
    private long field_189751_bG;
    @Shadow
    private AbstractAttributeMap field_110155_d;
    @Shadow
    protected net.minecraft.item.ItemStack field_184627_bm;
    @Shadow
    protected int field_70744_aE;
    @Shadow
    @Nullable
    public LivingEntity field_70755_b;
    @Shadow
    public CombatTracker field_94063_bt;
    @Shadow
    @Final
    private static DataParameter<Integer> field_184633_f;
    @Shadow
    @Final
    private static DataParameter<Boolean> field_184634_g;
    @Shadow
    @Final
    public Map<Effect, EffectInstance> field_70713_bf;
    public int expToDrop;
    public int maxAirTicks;
    public boolean forceDrops;
    public CraftAttributeMap craftAttributes;
    public boolean collides;
    public boolean canPickUpLoot;
    private boolean isTickingEffects = false;
    private List<Map.Entry<Either<EffectInstance, Effect>, EntityPotionEffectEvent.Cause>> effectsToProcess = Lists.newArrayList();
    private transient boolean arclight$fallSuccess;
    private transient EntityPotionEffectEvent.Action arclight$action;
    private transient EntityRegainHealthEvent.RegainReason arclight$regainReason;
    private transient EntityPotionEffectEvent.Cause arclight$cause;
    private transient net.minecraft.item.ItemStack arclight$consumePost;

    @Shadow
    public abstract float func_110138_aP();

    @Shadow
    public abstract void func_70691_i(float var1);

    @Shadow
    public abstract float func_110143_aJ();

    @Shadow
    public abstract void func_70606_j(float var1);

    @Shadow
    public abstract float func_70079_am();

    @Shadow
    protected abstract int func_70693_a(PlayerEntity var1);

    @Shadow
    protected abstract boolean func_146066_aG();

    @Shadow
    protected abstract boolean func_70684_aJ();

    @Override
    @Shadow(remap=false)
    public void remove(boolean keepData) {
    }

    @Shadow
    public abstract IAttributeInstance func_110148_a(IAttribute var1);

    @Shadow
    public abstract boolean func_195063_d(Effect var1);

    @Shadow
    public abstract boolean func_195061_cb();

    @Shadow
    public abstract boolean func_70644_a(Effect var1);

    @Shadow
    public abstract boolean func_70608_bn();

    @Shadow
    public abstract void func_213366_dy();

    @Shadow
    public abstract net.minecraft.item.ItemStack func_184582_a(EquipmentSlotType var1);

    @Shadow
    protected abstract boolean func_184583_d(DamageSource var1);

    @Shadow
    protected abstract void func_184590_k(float var1);

    @Shadow
    protected abstract void func_190629_c(LivingEntity var1);

    @Shadow
    public abstract void func_70604_c(@Nullable LivingEntity var1);

    @Override
    @Shadow
    protected abstract void func_70018_K();

    @Shadow
    public abstract void func_70653_a(Entity var1, float var2, double var3, double var5);

    @Shadow
    @Nullable
    protected abstract SoundEvent func_184615_bR();

    @Shadow
    protected abstract float func_70599_aP();

    @Shadow
    protected abstract float func_70647_i();

    @Shadow
    public abstract void func_70645_a(DamageSource var1);

    @Shadow
    protected abstract void func_184581_c(DamageSource var1);

    @Shadow
    protected abstract float func_70655_b(DamageSource var1, float var2);

    @Shadow
    public abstract net.minecraft.item.ItemStack func_184586_b(Hand var1);

    @Shadow
    @Nullable
    public abstract EffectInstance func_70660_b(Effect var1);

    @Shadow
    protected abstract float func_70672_c(DamageSource var1, float var2);

    @Shadow
    public abstract float func_110139_bj();

    @Shadow
    protected abstract void func_70675_k(float var1);

    @Shadow
    public abstract void func_110149_m(float var1);

    @Shadow
    public abstract CombatTracker func_110142_aN();

    @Shadow
    public abstract boolean func_70617_f_();

    @Shadow
    public abstract void func_71001_a(Entity var1, int var2);

    @Shadow
    protected abstract void func_213345_d(DamageSource var1);

    @Shadow
    public abstract net.minecraft.item.ItemStack func_184614_ca();

    @Shadow
    public abstract void func_70031_b(boolean var1);

    @Shadow
    public abstract void func_130011_c(Entity var1);

    @Shadow
    public abstract void func_184611_a(Hand var1, net.minecraft.item.ItemStack var2);

    @Shadow
    public abstract boolean func_70685_l(Entity var1);

    @Shadow
    @Nullable
    public abstract LivingEntity func_94060_bK();

    @Shadow
    public abstract Collection<EffectInstance> func_70651_bq();

    @Shadow
    public abstract void func_85034_r(int var1);

    @Shadow
    public abstract net.minecraft.item.ItemStack func_184592_cb();

    @Shadow
    public abstract Random func_70681_au();

    @Shadow
    public abstract Optional<BlockPos> func_213374_dv();

    @Shadow
    protected abstract void func_70688_c(EffectInstance var1);

    @Shadow
    protected abstract void func_70695_b(EffectInstance var1, boolean var2);

    @Shadow
    protected abstract void func_175135_B();

    @Shadow
    public abstract boolean func_70687_e(EffectInstance var1);

    @Shadow
    protected abstract void func_70670_a(EffectInstance var1);

    @Shadow
    @Nullable
    public abstract EffectInstance func_184596_c(@Nullable Effect var1);

    @Shadow
    protected abstract void func_226298_f_(@Nullable LivingEntity var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(EntityType<? extends LivingEntity> type, World worldIn, CallbackInfo ci) {
        this.maxAirTicks = 300;
        this.collides = true;
    }

    @Inject(method={"canEntityBeSeen"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$preventChunkLoad(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        if (entityIn.func_130014_f_() != this.field_70170_p) {
            cir.setReturnValue((Object)false);
        }
    }

    @Overwrite
    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ >= 20 && !this.field_70128_L) {
            this.remove(this instanceof ServerPlayerEntity);
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    @Redirect(method={"spawnDrops"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;dropExperience()V"))
    private void arclight$dropLater(LivingEntity livingEntity) {
    }

    @Inject(method={"spawnDrops"}, at={@At(value="RETURN")})
    private void arclight$dropLast(DamageSource damageSourceIn, CallbackInfo ci) {
        this.func_226294_cV_();
    }

    @Overwrite
    protected void func_226294_cV_() {
        int j;
        for (int i = this.bridge$getExpToDrop(); i > 0; i -= j) {
            j = ExperienceOrbEntity.func_70527_a((int)i);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
        }
        this.bridge$setExpToDrop(0);
    }

    @Overwrite
    protected void func_70679_bo() {
        this.isTickingEffects = true;
        Iterator<Effect> iterator = this.field_70713_bf.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                Effect effect = iterator.next();
                EffectInstance effectInstance = this.field_70713_bf.get(effect);
                if (!effectInstance.func_76455_a((LivingEntity)this, () -> this.func_70695_b(effectinstance, true))) {
                    EntityPotionEffectEvent event;
                    if (this.field_70170_p.field_72995_K || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionExpiryEvent((LivingEntity)this, effectInstance)) || (event = CraftEventFactory.callEntityPotionEffectChangeEvent((LivingEntity)this, effectInstance, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.func_70688_c(effectInstance);
                    continue;
                }
                if (effectInstance.func_76459_b() % 600 != 0) continue;
                this.func_70695_b(effectInstance, false);
            }
        }
        catch (ConcurrentModificationException effect) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (Map.Entry entry : this.effectsToProcess) {
            Either either = (Either)entry.getKey();
            EntityPotionEffectEvent.Cause cause = (EntityPotionEffectEvent.Cause)((Object)entry.getValue());
            this.bridge$pushEffectCause(cause);
            if (either.left().isPresent()) {
                this.func_195064_c((EffectInstance)either.left().get());
                continue;
            }
            this.func_195063_d((Effect)either.right().get());
        }
        this.effectsToProcess.clear();
        if (this.field_70752_e) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_175135_B();
            }
            this.field_70752_e = false;
        }
        int i = (Integer)this.field_70180_af.func_187225_a(field_184633_f);
        boolean bl = (Boolean)this.field_70180_af.func_187225_a(field_184634_g);
        if (i > 0) {
            boolean flag = this.func_82150_aj() ? this.field_70146_Z.nextInt(15) == 0 : this.field_70146_Z.nextBoolean();
            if (bl) {
                flag &= this.field_70146_Z.nextInt(5) == 0;
            }
            if (flag && i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                this.field_70170_p.func_195594_a((IParticleData)(bl ? ParticleTypes.field_197608_a : ParticleTypes.field_197625_r), this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
    }

    @Overwrite
    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        EntityPotionEffectEvent event;
        EntityPotionEffectEvent.Cause cause = this.bridge$getEffectCause().orElse(EntityPotionEffectEvent.Cause.UNKNOWN);
        if (this.isTickingEffects) {
            this.effectsToProcess.add(Maps.immutableEntry(Either.left((Object)effectInstanceIn), cause));
            return true;
        }
        if (!this.func_70687_e(effectInstanceIn)) {
            return false;
        }
        EffectInstance effectinstance = this.field_70713_bf.get(effectInstanceIn.func_188419_a());
        boolean override = false;
        if (effectinstance != null) {
            override = new EffectInstance(effectinstance).func_199308_a(effectInstanceIn);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent((LivingEntity)this, effectinstance, effectInstanceIn, cause, override)).isCancelled()) {
            return false;
        }
        MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionAddedEvent((LivingEntity)this, effectinstance, effectInstanceIn));
        if (effectinstance == null) {
            this.field_70713_bf.put(effectInstanceIn.func_188419_a(), effectInstanceIn);
            this.func_70670_a(effectInstanceIn);
            return true;
        }
        if (event.isOverride()) {
            effectinstance.func_199308_a(effectInstanceIn);
            this.func_70695_b(effectinstance, true);
            return true;
        }
        return false;
    }

    public EffectInstance c(@Nullable Effect potioneffectin, EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.func_184596_c(potioneffectin);
    }

    @Inject(method={"removeActivePotionEffect"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$clearActive(Effect effect, CallbackInfoReturnable<EffectInstance> cir) {
        EntityPotionEffectEvent.Cause cause = this.bridge$getEffectCause().orElse(EntityPotionEffectEvent.Cause.UNKNOWN);
        if (this.isTickingEffects) {
            this.effectsToProcess.add(Maps.immutableEntry(Either.right((Object)effect), cause));
            cir.setReturnValue(null);
            return;
        }
        EffectInstance effectInstance = this.field_70713_bf.get(effect);
        if (effectInstance == null) {
            cir.setReturnValue(null);
            return;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent((LivingEntity)this, effectInstance, null, cause);
        if (event.isCancelled()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"onLivingFall"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/LivingEntity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z")})
    public void arclight$fall(float distance, float damageMultiplier, CallbackInfoReturnable<Boolean> cir) {
        if (!this.arclight$fallSuccess) {
            cir.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"onLivingFall"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    public boolean arclight$fall(LivingEntity livingEntity, DamageSource source, float amount) {
        this.arclight$fallSuccess = livingEntity.func_70097_a(source, amount);
        return this.arclight$fallSuccess;
    }

    @Override
    public boolean bridge$canPickUpLoot() {
        return this.canPickUpLoot;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getMaxHealth()F"))
    public float arclight$muteHealth(LivingEntity livingEntity) {
        return 0.0f;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setHealth(F)V"))
    public void arclight$muteHealth2(LivingEntity livingEntity, float health) {
        this.field_70180_af.func_187227_b(field_184632_c, (Object)Float.valueOf((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e()));
    }

    @Override
    public float getBukkitYaw() {
        return this.func_70079_am();
    }

    public int getExpReward() {
        if (!this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            int exp = this.func_70693_a(this.field_70717_bb);
            return ForgeEventFactory.getExperienceDrop((LivingEntity)((LivingEntity)this), (PlayerEntity)this.field_70717_bb, (int)exp);
        }
        return 0;
    }

    @Override
    public int bridge$getExpReward() {
        return this.getExpReward();
    }

    @Override
    public void bridge$setExpToDrop(int amount) {
        this.expToDrop = amount;
    }

    @Override
    public int bridge$getExpToDrop() {
        return this.expToDrop;
    }

    @Override
    public boolean bridge$isForceDrops() {
        return this.forceDrops;
    }

    @Inject(method={"readAdditional"}, at={@At(value="HEAD")})
    public void arclight$readMaxHealth(CompoundNBT compound, CallbackInfo ci) {
        if (compound.func_74764_b("Bukkit.MaxHealth")) {
            INBT nbtbase = compound.func_74781_a("Bukkit.MaxHealth");
            if (nbtbase.func_74732_a() == 5) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(((FloatNBT)nbtbase).func_150286_g());
            } else if (nbtbase.func_74732_a() == 3) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(((IntNBT)nbtbase).func_150286_g());
            }
        }
    }

    @Inject(method={"clearActivePotions"}, at={@At(value="INVOKE", remap=false, target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")})
    public void arclight$clearReason(CallbackInfoReturnable<Boolean> cir) {
        this.arclight$action = EntityPotionEffectEvent.Action.CLEARED;
    }

    @Override
    public EntityPotionEffectEvent.Action bridge$getAndResetAction() {
        try {
            EntityPotionEffectEvent.Action action = this.arclight$action;
            return action;
        }
        finally {
            this.arclight$action = null;
        }
    }

    @Override
    @Overwrite
    public boolean func_70089_S() {
        return !this.field_70128_L && ((Float)this.field_70180_af.func_187225_a(field_184632_c)).floatValue() > 0.0f;
    }

    @Inject(method={"getHealth"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$scaledHealth(CallbackInfoReturnable<Float> cir) {
        if (this instanceof ServerPlayerEntityBridge && ((ServerPlayerEntityBridge)((Object)this)).bridge$initialized()) {
            cir.setReturnValue((Object)Float.valueOf((float)((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().getHealth()));
        }
    }

    @Inject(method={"setHealth"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setScaled(float health, CallbackInfo ci) {
        if (this instanceof ServerPlayerEntityBridge && ((ServerPlayerEntityBridge)((Object)this)).bridge$initialized()) {
            CraftPlayer player = ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity();
            double realHealth = MathHelper.func_151237_a((double)health, (double)0.0, (double)player.getMaxHealth());
            player.setRealHealth(realHealth);
            player.updateScaledHealth(false);
            player.setRealHealth(realHealth);
            ci.cancel();
        }
    }

    @Override
    @Overwrite
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        if (!ForgeHooks.onLivingAttack((LivingEntity)((LivingEntity)this), (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.field_70729_aU || this.field_70128_L || this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && this.func_70644_a(Effects.field_76426_n)) {
            return false;
        }
        if (this.func_70608_bn() && !this.field_70170_p.field_72995_K) {
            this.func_213366_dy();
        }
        this.field_70708_bq = 0;
        float f = amount;
        boolean flag = false;
        float f1 = 0.0f;
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        if ((float)this.field_70172_ad > 10.0f) {
            if (amount <= this.field_110153_bc) {
                this.forceExplosionKnockback = true;
                return false;
            }
            if (!this.damageEntity0(source, amount - this.field_110153_bc)) {
                return false;
            }
            this.field_110153_bc = amount;
            flag1 = false;
        } else {
            if (!this.damageEntity0(source, amount)) {
                return false;
            }
            this.field_110153_bc = amount;
            this.field_70172_ad = 20;
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        if (this instanceof AnimalEntity) {
            SitGoal sitGoal;
            ((AnimalEntity)this).func_70875_t();
            if (this instanceof TameableEntity && (sitGoal = ((TameableEntity)this).func_70907_r()) != null) {
                sitGoal.func_75270_a(false);
            }
        }
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            TameableEntity wolfentity;
            if (entity1 instanceof LivingEntity) {
                this.func_70604_c((LivingEntity)entity1);
            }
            if (entity1 instanceof PlayerEntity) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (PlayerEntity)entity1;
            } else if (entity1 instanceof TameableEntity && (wolfentity = (TameableEntity)entity1).func_70909_n()) {
                this.field_70718_bc = 100;
                LivingEntity livingentity = wolfentity.func_70902_q();
                this.field_70717_bb = livingentity != null && livingentity.func_200600_R() == EntityType.field_200729_aH ? (PlayerEntity)livingentity : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a((Entity)((LivingEntity)this), (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((Entity)((LivingEntity)this), (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : (source == DamageSource.field_220302_v ? (byte)44 : 2));
                this.field_70170_p.func_72960_a((Entity)((LivingEntity)this), b0);
            }
            if (source != DamageSource.field_76369_e && (!flag || amount > 0.0f)) {
                this.func_70018_K();
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - this.field_70165_t;
                double d0 = entity1.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.2957763671875 - (double)this.field_70177_z);
                this.func_70653_a(entity1, 0.4f, d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (!this.func_190628_d(source)) {
                SoundEvent soundevent = this.func_184615_bR();
                if (flag1 && soundevent != null) {
                    this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
                }
                this.func_70645_a(source);
            }
        } else if (flag1) {
            this.func_184581_c(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.field_189750_bF = source;
            this.field_189751_bG = this.field_70170_p.func_82737_E();
        }
        if (this instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192128_h.func_192200_a((ServerPlayerEntity)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((ServerPlayerEntity)this).func_195067_a(Stats.field_212737_I, Math.round(f1 * 10.0f));
            }
        }
        if (entity1 instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192127_g.func_192220_a((ServerPlayerEntity)entity1, (Entity)((LivingEntity)this), source, f, amount, flag);
        }
        return flag2;
    }

    @Inject(method={"damageEntity"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$redirectDamageEntity(DamageSource damageSrc, float damageAmount, CallbackInfo ci) {
        this.damageEntity0(damageSrc, damageAmount);
        ci.cancel();
    }

    protected boolean damageEntity0(DamageSource damagesource, float f) {
        if (!this.func_180431_b(damagesource)) {
            float f3;
            boolean human = this instanceof PlayerEntity;
            if ((f = ForgeHooks.onLivingHurt((LivingEntity)((LivingEntity)this), (DamageSource)damagesource, (float)f)) <= 0.0f) {
                return true;
            }
            float originalDamage = f;
            Function hardHat = f12 -> {
                if (!(damagesource != DamageSource.field_82728_o && damagesource != DamageSource.field_82729_p || this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b())) {
                    return -(f12 - f12 * 0.75);
                }
                return -0.0;
            };
            float hardHatModifier = ((Double)hardHat.apply(Double.valueOf(f))).floatValue();
            Function blocking = f13 -> -(this.func_184583_d(damagesource) ? f13 : 0.0);
            float blockingModifier = ((Double)blocking.apply(Double.valueOf(f += hardHatModifier))).floatValue();
            Function armor = f14 -> -(f14 - (double)this.func_70655_b(damagesource, f14.floatValue()));
            float armorModifier = ((Double)armor.apply(Double.valueOf(f += blockingModifier))).floatValue();
            Function resistance = f15 -> {
                if (!damagesource.func_151517_h() && this.func_70644_a(Effects.field_76429_m) && damagesource != DamageSource.field_76380_i) {
                    int i = (this.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5;
                    int j = 25 - i;
                    float f1 = f15.floatValue() * (float)j;
                    return -(f15 - (double)(f1 / 25.0f));
                }
                return -0.0;
            };
            float resistanceModifier = ((Double)resistance.apply(Double.valueOf(f += armorModifier))).floatValue();
            Function magic = f16 -> -(f16 - (double)this.func_70672_c(damagesource, f16.floatValue()));
            float magicModifier = ((Double)magic.apply(Double.valueOf(f += resistanceModifier))).floatValue();
            Function absorption = f17 -> -Math.max(f17 - Math.max(f17 - (double)this.func_110139_bj(), 0.0), 0.0);
            float absorptionModifier = ((Double)absorption.apply(Double.valueOf(f += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent((Entity)((LivingEntity)this), damagesource, originalDamage, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, hardHat, blocking, armor, resistance, magic, absorption);
            if (damagesource.func_76346_g() instanceof PlayerEntity) {
                ((PlayerEntity)damagesource.func_76346_g()).func_184821_cY();
            }
            if (event.isCancelled()) {
                return false;
            }
            f = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)this).func_195067_a(Stats.field_212739_K, Math.round(f3 * 10.0f));
                } else if (damagesource.func_76346_g() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)damagesource.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f3 * 10.0f));
                }
            }
            if ((damagesource == DamageSource.field_82728_o || damagesource == DamageSource.field_82729_p) && this.func_184582_a(EquipmentSlotType.HEAD) != null) {
                this.func_184582_a(EquipmentSlotType.HEAD).func_222118_a((int)(event.getDamage() * 4.0 + (double)this.field_70146_Z.nextFloat() * event.getDamage() * 2.0), (LivingEntity)this, entityliving -> entityliving.func_213361_c(EquipmentSlotType.HEAD));
            }
            if (!damagesource.func_76363_c()) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.func_70675_k(armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
                this.func_184590_k((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity = damagesource.func_76364_f();
                if (entity instanceof LivingEntity) {
                    this.func_190629_c((LivingEntity)entity);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.func_110149_m(Math.max(this.func_110139_bj() - absorptionModifier, 0.0f));
            float f2 = absorptionModifier;
            if (f2 > 0.0f && f2 < 3.4028235E37f && this instanceof PlayerEntity) {
                ((PlayerEntity)this).func_195067_a(Stats.field_212738_J, Math.round(f2 * 10.0f));
            }
            if (f2 > 0.0f && f2 < 3.4028235E37f && damagesource.func_76346_g() instanceof PlayerEntity) {
                ((PlayerEntity)damagesource.func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(f2 * 10.0f));
            }
            if ((f = ForgeHooks.onLivingDamage((LivingEntity)((LivingEntity)this), (DamageSource)damagesource, (float)f)) > 0.0f || !human) {
                if (human) {
                    ((PlayerEntity)this).func_71020_j(damagesource.func_76345_d());
                    if (f < 3.4028235E37f) {
                        ((PlayerEntity)this).func_195067_a(Stats.field_188112_z, Math.round(f * 10.0f));
                    }
                }
                float f32 = this.func_110143_aJ();
                this.func_70606_j(f32 - f);
                this.func_110142_aN().func_94547_a(damagesource, f32, f);
                if (!human) {
                    this.func_110149_m(this.func_110139_bj() - f);
                }
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192128_h.func_192200_a((ServerPlayerEntity)this, damagesource, f, originalDamage, true);
                    f2 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f2 > 0.0f && f2 < 3.4028235E37f) {
                        ((ServerPlayerEntity)this).func_195067_a(Stats.field_212737_I, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.func_76346_g() instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192127_g.func_192220_a((ServerPlayerEntity)damagesource.func_76346_g(), (Entity)this, damagesource, f, originalDamage, true);
                }
                return false;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public void heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.bridge$pushHealReason(regainReason);
        this.func_70691_i(healAmount);
    }

    @Redirect(method={"heal"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setHealth(F)V"))
    public void arclight$healEvent(LivingEntity livingEntity, float health) {
        EntityRegainHealthEvent.RegainReason regainReason = this.arclight$regainReason == null ? EntityRegainHealthEvent.RegainReason.CUSTOM : this.arclight$regainReason;
        this.arclight$regainReason = null;
        float f = this.func_110143_aJ();
        float amount = health - f;
        EntityRegainHealthEvent event = new EntityRegainHealthEvent(this.getBukkitEntity(), amount, regainReason);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent(event);
        }
        if (!event.isCancelled()) {
            this.func_70606_j(this.func_110143_aJ() + (float)event.getAmount());
        }
    }

    @Inject(method={"heal"}, at={@At(value="RETURN")})
    public void arclight$resetReason(float healAmount, CallbackInfo ci) {
        this.arclight$regainReason = null;
    }

    public boolean removeEffect(Effect effect, EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.func_195063_d(effect);
    }

    @Override
    public boolean bridge$removeEffect(Effect effect, EntityPotionEffectEvent.Cause cause) {
        return this.removeEffect(effect, cause);
    }

    public boolean addEffect(EffectInstance effect, EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.func_195064_c(effect);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        this.bridge$pushEffectCause(cause);
        return this.func_195061_cb();
    }

    @Override
    public boolean bridge$removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        return this.removeAllEffects(cause);
    }

    @Override
    public CraftLivingEntity getBukkitEntity() {
        return (CraftLivingEntity)this.internal$getBukkitEntity();
    }

    @Override
    public CraftLivingEntity bridge$getBukkitEntity() {
        return (CraftLivingEntity)this.internal$getBukkitEntity();
    }

    @Overwrite
    private boolean func_190628_d(DamageSource damageSourceIn) {
        if (damageSourceIn.func_76357_e()) {
            return false;
        }
        net.minecraft.item.ItemStack itemstack = null;
        net.minecraft.item.ItemStack itemstack1 = null;
        for (Hand hand : Hand.values()) {
            itemstack1 = this.func_184586_b(hand);
            if (itemstack1.func_77973_b() != Items.field_190929_cY) continue;
            itemstack = itemstack1.func_77946_l();
            itemstack1.func_190918_g(1);
            break;
        }
        EntityResurrectEvent event = new EntityResurrectEvent(this.getBukkitEntity());
        event.setCancelled(itemstack == null);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_190918_g(1);
            }
            if (itemstack != null && this instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this;
                serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_190929_cY));
                CriteriaTriggers.field_193130_A.func_193187_a(serverplayerentity, itemstack);
            }
            this.func_70606_j(1.0f);
            this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.TOTEM);
            this.func_195061_cb();
            this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.TOTEM);
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
            this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.TOTEM);
            this.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
            this.field_70170_p.func_72960_a((Entity)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Redirect(method={"applyArmorCalculations"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageArmor(F)V"))
    public void arclight$muteDamageArmor(LivingEntity livingEntity, float damage) {
    }

    @Redirect(method={"applyPotionDamageCalculations"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isPotionActive(Lnet/minecraft/potion/Effect;)Z"))
    public boolean arclight$mutePotion(LivingEntity livingEntity, Effect potionIn) {
        return false;
    }

    @Inject(method={"getAttributes"}, at={@At(value="RETURN")})
    public void arclight$initializeCraftAttr(CallbackInfoReturnable<AbstractAttributeMap> cir) {
        if (this.craftAttributes == null) {
            this.craftAttributes = new CraftAttributeMap(this.field_110155_d);
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setFlag(IZ)V"))
    public void arclight$stopGlide(LivingEntity livingEntity, int flag, boolean set) {
        if (set != livingEntity.func_70083_f(flag) && !CraftEventFactory.callToggleGlideEvent(livingEntity, set).isCancelled()) {
            livingEntity.func_70052_a(flag, set);
        }
    }

    @Redirect(method={"updateElytra"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setFlag(IZ)V"))
    public void arclight$toggleGlide(LivingEntity livingEntity, int flag, boolean set) {
        if (set != livingEntity.func_70083_f(flag) && !CraftEventFactory.callToggleGlideEvent(livingEntity, set).isCancelled()) {
            livingEntity.func_70052_a(flag, set);
        }
    }

    @Overwrite
    public boolean func_70067_L() {
        return !this.field_70128_L && this.collides;
    }

    @Overwrite
    public boolean func_70104_M() {
        return this.func_70089_S() && !this.func_70617_f_() && this.collides;
    }

    @Inject(method={"onItemUseFinish"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getItemInUseCount()I")})
    public void arclight$itemConsume(CallbackInfo ci, net.minecraft.item.ItemStack copy) {
        this.arclight$consumePost = null;
        if (this instanceof ServerPlayerEntityBridge) {
            ItemStack craftItem = CraftItemStack.asBukkitCopy(this.field_184627_bm);
            PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)((Object)this.getBukkitEntity()), craftItem);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().updateInventory();
                ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().updateScaledHealth();
                ci.cancel();
            } else if (!craftItem.equals(event.getItem())) {
                this.arclight$consumePost = CraftItemStack.asNMSCopy(event.getItem());
            }
        }
    }

    @Redirect(method={"onItemUseFinish"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;onItemUseFinish(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)Lnet/minecraft/item/ItemStack;"))
    public net.minecraft.item.ItemStack arclight$useEventItem(net.minecraft.item.ItemStack itemStack, World worldIn, LivingEntity entityLiving) {
        if (this.arclight$consumePost != null) {
            itemStack = this.arclight$consumePost;
        }
        this.arclight$consumePost = null;
        return itemStack.func_77950_b(worldIn, entityLiving);
    }

    @Inject(method={"attemptTeleport"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/LivingEntity;setPositionAndUpdate(DDD)V")})
    public void arclight$entityTeleport(double d0, double d1, double d2, boolean flag, CallbackInfoReturnable<Boolean> cir, double d3, double d4, double d5) {
        EntityTeleportEvent event = new EntityTeleportEvent(this.getBukkitEntity(), new Location(((WorldBridge)this.field_70170_p).bridge$getWorld(), d3, d4, d5), new Location(((WorldBridge)this.field_70170_p).bridge$getWorld(), this.field_70165_t, this.field_70163_u, this.field_70161_v));
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.field_70165_t = event.getTo().getX();
            this.field_70163_u = event.getTo().getY();
            this.field_70161_v = event.getTo().getZ();
        } else {
            this.func_70634_a(d3, d4, d5);
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"spawnDrops"}, at=@At(value="INVOKE", ordinal=0, remap=false, target="Lnet/minecraft/entity/LivingEntity;captureDrops(Ljava/util/Collection;)Ljava/util/Collection;"))
    private Collection<ItemEntity> arclight$captureIfNeed(LivingEntity livingEntity, Collection<ItemEntity> value) {
        Collection drops = livingEntity.captureDrops();
        return drops == null ? livingEntity.captureDrops(value) : drops;
    }

    @Redirect(method={"spawnDrops"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/Collection;forEach(Ljava/util/function/Consumer;)V"))
    private void arclight$cancelEvent(Collection<ItemEntity> collection, Consumer<ItemEntity> action) {
        if (this instanceof ServerPlayerEntityBridge) {
            this.captureDrops(collection);
        } else {
            collection.forEach(action);
        }
    }

    @Inject(method={"applyFoodEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;addPotionEffect(Lnet/minecraft/potion/EffectInstance;)Z")})
    public void arclight$foodEffectCause(net.minecraft.item.ItemStack p_213349_1_, World p_213349_2_, LivingEntity livingEntity, CallbackInfo ci) {
        ((LivingEntityBridge)livingEntity).bridge$pushEffectCause(EntityPotionEffectEvent.Cause.FOOD);
    }

    @Override
    public void bridge$heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(healAmount, regainReason);
    }

    @Override
    public void bridge$pushHealReason(EntityRegainHealthEvent.RegainReason regainReason) {
        this.arclight$regainReason = regainReason;
    }

    @Override
    public void bridge$pushEffectCause(EntityPotionEffectEvent.Cause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public boolean bridge$addEffect(EffectInstance effect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effect, cause);
    }

    @Override
    public Optional<EntityPotionEffectEvent.Cause> bridge$getEffectCause() {
        try {
            Optional<EntityPotionEffectEvent.Cause> optional = Optional.ofNullable(this.arclight$cause);
            return optional;
        }
        finally {
            this.arclight$cause = null;
        }
    }

    private static /* synthetic */ void lambda$attackEntityFrom$1(LivingEntity p_213341_0_) {
        p_213341_0_.func_213361_c(EquipmentSlotType.HEAD);
    }
}

